/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.spi;

import io.debezium.converters.spi.SerializerType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class CloudEventsValidator {
    private final Set<String> cloudEventsSpecRequiredFields = Set.of("id", "source", "specversion", "type");
    private SerializerType serializerType;
    private String cloudEventsSchemaName;

    public void configure(SerializerType serializerType, String cloudEventsSchemaName) {
        this.serializerType = serializerType;
        this.cloudEventsSchemaName = cloudEventsSchemaName;
    }

    public boolean isCloudEvent(SchemaAndValue schemaAndValue) {
        return this.baseCheck(schemaAndValue) && this.checkFields(schemaAndValue.value());
    }

    public void verifyIsCloudEvent(SchemaAndValue schemaAndValue) {
        if (!this.isCloudEvent(schemaAndValue)) {
            throw new DataException("A deserialized record's value is not a CloudEvent: value=" + String.valueOf(schemaAndValue.value()));
        }
    }

    private boolean baseCheck(SchemaAndValue schemaAndValue) {
        switch (this.serializerType) {
            case JSON: {
                return schemaAndValue.schema() == null && schemaAndValue.value() instanceof Map;
            }
            case AVRO: {
                String schemaName = schemaAndValue.schema().name();
                boolean schemaNameIsValid = this.cloudEventsSchemaName != null ? schemaName.equals(this.cloudEventsSchemaName) : schemaName.endsWith("CloudEvents.Envelope");
                return schemaNameIsValid && schemaAndValue.value() instanceof Struct;
            }
        }
        throw new DataException("Can't check whether a record is a CloudEvent for serializer type \"" + String.valueOf((Object)this.serializerType) + "\"");
    }

    private boolean checkFields(Object value) {
        List<Object> fieldNames;
        switch (this.serializerType) {
            case JSON: {
                Map valueMap = (Map)value;
                fieldNames = new ArrayList(valueMap.keySet());
                break;
            }
            case AVRO: {
                fieldNames = ((Struct)value).schema().fields().stream().map(Field::name).collect(Collectors.toList());
                break;
            }
            default: {
                throw new DataException("Can't check whether a record is a CloudEvent for serializer type \"" + String.valueOf((Object)this.serializerType) + "\"");
            }
        }
        return fieldNames.size() >= 4 && fieldNames.containsAll(this.cloudEventsSpecRequiredFields);
    }
}

