/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc.impl;

import com.hazelcast.jet.JetException;
import com.hazelcast.shaded.com.fasterxml.jackson.core.json.JsonReadFeature;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.MapperFeature;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.json.JsonMapper;
import com.hazelcast.shaded.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.RecordChangeEvent;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.connect.source.SourceRecord;

final class Utils {
    static final ObjectMapper MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS).enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)).disable(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)).addModule(new JavaTimeModule())).build();

    private Utils() {
    }

    static void markProcessed(DebeziumEngine.RecordCommitter<RecordChangeEvent<SourceRecord>> committer, RecordChangeEvent<SourceRecord> changeEvent) {
        try {
            committer.markProcessed(changeEvent);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JetException("Unable to mark event as processed", (Throwable)e);
        }
    }

    static void markBatchFinished(DebeziumEngine.RecordCommitter<RecordChangeEvent<SourceRecord>> committer) {
        try {
            committer.markBatchFinished();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JetException("Unable to mark event batch as processed", (Throwable)e);
        }
    }

    static String decode(Map<ByteBuffer, ByteBuffer> partitionsToOffset) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ByteBuffer, ByteBuffer> entry : partitionsToOffset.entrySet()) {
            ByteBuffer partition = entry.getKey();
            ByteBuffer offset = entry.getValue();
            sb.append(new String(partition.array())).append(" -> ").append(new String(offset.array()));
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }
}

