/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc.impl;

import com.hazelcast.enterprise.jet.cdc.RecordMappingFunction;
import com.hazelcast.enterprise.jet.cdc.impl.State;
import com.hazelcast.enterprise.jet.cdc.impl.Utils;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.tpcengine.util.CloseUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.EventTimeMapper;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import io.debezium.config.Configuration;
import io.debezium.embedded.Connect;
import io.debezium.embedded.EmbeddedEngineConfig;
import io.debezium.embedded.KafkaConnectUtil;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.RecordChangeEvent;
import io.debezium.engine.format.ChangeEventFormat;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.history.AbstractSchemaHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.relational.history.SchemaHistoryListener;
import java.nio.ByteBuffer;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.MemoryOffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetUtils;
import org.apache.kafka.connect.util.Callback;

public class ReadCdcP<T>
extends AbstractProcessor {
    public static final String NAME_PROPERTY = "name";
    public static final String CONNECTOR_CLASS_PROPERTY = "connector.class";
    public static final String SEQUENCE_EXTRACTOR_CLASS_PROPERTY = "sequence.extractor.class";
    private static final String TIMESTAMP_MS_FIELD_NAME = "ts_ms";
    private static final String JET_JOB_ID_REPLACEMENT_PROP_1 = "offset.storage.topic";
    private static final String JET_JOB_ID_REPLACEMENT_PROP_2 = "schema.history.internal.connector.id";
    private final Properties properties;
    private final EventTimeMapper<? super T> eventTimeMapper;
    private final RecordMappingFunction<T> recordMappingFunction;
    private final SupplierEx<DebeziumEngine.BuilderFactory> engineBuilderSupplier;
    private Traverser<Object> traverser = Traversers.empty();
    private Traverser<Map.Entry<BroadcastKey<String>, State>> snapshotTraverser;
    private boolean snapshotInProgress;
    private ILogger logger;
    private int maxShutdownWaitSeconds;
    private final ConcurrentLinkedDeque<EventBatch> itemsBuffer = new ConcurrentLinkedDeque();
    private final AtomicBoolean engineStarted = new AtomicBoolean(false);
    private DebeziumEngine<RecordChangeEvent<SourceRecord>> engine;
    private ExecutorService executor;
    private State state;
    private volatile CompletionEvent completionEvent;

    public ReadCdcP(@Nonnull Properties properties, @Nonnull EventTimePolicy<? super T> eventTimePolicy, @Nonnull RecordMappingFunction<T> recordMappingFunction, SupplierEx<DebeziumEngine.BuilderFactory> engineBuilderSupplier) {
        this.properties = Objects.requireNonNull(properties, "properties cannot be null");
        this.recordMappingFunction = Objects.requireNonNull(recordMappingFunction, "recordMappingFunction cannot be null");
        this.engineBuilderSupplier = Objects.requireNonNull(engineBuilderSupplier, "engineBuilderSupplier cannot be null");
        this.eventTimeMapper = new EventTimeMapper(Objects.requireNonNull(eventTimePolicy, "eventTimePolicy cannot be null"));
        this.eventTimeMapper.addPartitions(1);
    }

    protected void init(@Nonnull Processor.Context context) {
        this.logger = context.logger();
        this.properties.setProperty(EmbeddedEngineConfig.OFFSET_STORAGE.name(), JetOffsetStorage.class.getName());
        this.properties.setProperty(HistorizedRelationalDatabaseConnectorConfig.SCHEMA_HISTORY.name(), StatefulSchemaHistory.class.getName());
        this.state = State.getOrCreate(context.jobId());
        this.properties.setProperty(JET_JOB_ID_REPLACEMENT_PROP_1, String.valueOf(context.jobId()));
        this.properties.setProperty(JET_JOB_ID_REPLACEMENT_PROP_2, String.valueOf(context.jobId()));
        this.recordMappingFunction.init(this.properties, context.classLoader());
        this.executor = Executors.newFixedThreadPool(Integer.parseInt(this.properties.getProperty("tasks.max", "1")));
        if (this.logger.isFineEnabled()) {
            this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = (String)k;
                Object value = v;
                if (key.contains("password")) {
                    value = "****";
                }
                this.logger.fine("Property '" + key + "': " + String.valueOf(value));
            }));
        }
        this.maxShutdownWaitSeconds = Integer.parseInt(this.properties.getProperty("max.shutdown.wait.s", "120"));
        this.engine = ((DebeziumEngine.BuilderFactory)this.engineBuilderSupplier.get()).builder(ChangeEventFormat.of(Connect.class)).using(context.classLoader()).using(this.properties).notifying((records, committer) -> this.itemsBuffer.add(new EventBatch(records, committer))).using((success, message, error) -> {
            this.completionEvent = new CompletionEvent(success, message, error);
        }).build();
    }

    private void runEngine() {
        if (this.engineStarted.compareAndSet(false, true)) {
            this.logger.fine("Engine was not running yet, starting");
            this.executor.execute(this.engine);
        }
    }

    public boolean complete() {
        this.runEngine();
        this.checkCompleted();
        if (!this.emitFromTraverser(this.traverser)) {
            return false;
        }
        if (this.snapshotInProgress) {
            return false;
        }
        EventBatch batch = this.itemsBuffer.poll();
        if (batch == null) {
            this.traverser = this.eventTimeMapper.flatMapIdle();
        } else {
            DebeziumEngine.RecordCommitter<RecordChangeEvent<SourceRecord>> committer = batch.committer();
            this.traverser = Traversers.traverseIterable(batch.records()).flatMap(event -> {
                SourceRecord sourceRecord = (SourceRecord)event.record();
                if (sourceRecord == null) {
                    return this.eventTimeMapper.flatMapIdle();
                }
                long nativeTime = ReadCdcP.extractTimestamp(sourceRecord);
                Object mappedRecord = this.recordMappingFunction.apply(sourceRecord);
                Traverser mapped = this.eventTimeMapper.flatMapEvent(mappedRecord, 0, nativeTime);
                Utils.markProcessed(committer, event);
                return mapped;
            }).onFirstNull(() -> Utils.markBatchFinished(committer));
        }
        this.emitFromTraverser(this.traverser);
        return false;
    }

    private void checkCompleted() {
        CompletionEvent event = this.completionEvent;
        if (event != null && !event.success()) {
            throw new JetException(event.message(), event.throwable());
        }
    }

    public boolean saveToSnapshot() {
        if (!this.emitFromTraverser(this.traverser)) {
            return false;
        }
        this.snapshotInProgress = true;
        if (this.snapshotTraverser == null) {
            this.snapshotTraverser = Traversers.singleton((Object)Util.entry(this.snapshotKey(), (Object)this.state)).onFirstNull(() -> {
                this.snapshotTraverser = null;
                this.getLogger().finest("Finished saving snapshot.");
            });
        }
        return this.emitFromTraverserToSnapshot(this.snapshotTraverser);
    }

    private BroadcastKey<String> snapshotKey() {
        return BroadcastKey.broadcastKey((Object)"cdc-snapshot");
    }

    public boolean snapshotCommitFinish(boolean success) {
        this.snapshotInProgress = false;
        return true;
    }

    protected void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        if (!this.snapshotKey().equals(key)) {
            throw new RuntimeException("Unexpected key received from snapshot: " + String.valueOf(key));
        }
        ILogger logger = this.getLogger();
        if (logger.isFineEnabled()) {
            logger.fine("Restoring from snapshot: " + String.valueOf(value));
        }
        this.state.restore((State)value);
    }

    public void close() {
        CloseUtil.closeQuietly(this.engine);
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(this.maxShutdownWaitSeconds, TimeUnit.SECONDS)) {
                    this.logger.warning("Cannot shutdown executor after " + this.maxShutdownWaitSeconds + " seconds");
                }
            }
            catch (InterruptedException e) {
                throw new JetException((Throwable)e);
            }
        }
        if (this.state != null) {
            this.state.remove();
        }
    }

    private static long extractTimestamp(SourceRecord sourceRecord) {
        boolean noSourceTsMs;
        boolean noValueTsMs;
        Schema valueSchema = sourceRecord.valueSchema();
        boolean bl = noValueTsMs = valueSchema.field(TIMESTAMP_MS_FIELD_NAME) == null;
        if (valueSchema.name().equalsIgnoreCase("io.debezium.connector.common.Heartbeat")) {
            return ((Struct)sourceRecord.value()).getInt64(TIMESTAMP_MS_FIELD_NAME);
        }
        Field field = valueSchema.field("source");
        boolean bl2 = noSourceTsMs = field.schema().field(TIMESTAMP_MS_FIELD_NAME) == null;
        if (noValueTsMs && noSourceTsMs) {
            return Long.MIN_VALUE;
        }
        Struct valueStruct = (Struct)sourceRecord.value();
        Long timestamp = noValueTsMs ? valueStruct.getStruct("source").getInt64(TIMESTAMP_MS_FIELD_NAME) : valueStruct.getInt64(TIMESTAMP_MS_FIELD_NAME);
        return timestamp == null ? Long.MIN_VALUE : timestamp;
    }

    static {
        DriverManager.getDrivers();
    }

    public static class JetOffsetStorage
    extends MemoryOffsetBackingStore {
        private final Map<String, Set<Map<String, Object>>> connectorPartitions = new HashMap<String, Set<Map<String, Object>>>();
        private Converter keyConverter;
        private State state;

        @Override
        public void configure(WorkerConfig config) {
            super.configure(config);
            this.state = State.get(Long.parseLong(config.getString(ReadCdcP.JET_JOB_ID_REPLACEMENT_PROP_1)));
        }

        @Override
        public void start() {
            super.start();
            this.keyConverter = KafkaConnectUtil.converterForOffsetStore();
            this.state.getPartitionsToOffset().forEach((partition, offset) -> {
                byte[] partitionBytes = partition.array();
                byte[] offsetBytes = offset.array();
                OffsetUtils.processPartitionKey(partitionBytes, offsetBytes, this.keyConverter, this.connectorPartitions);
            });
        }

        @Override
        public Future<Map<ByteBuffer, ByteBuffer>> get(Collection<ByteBuffer> keys) {
            return this.executor.submit(() -> {
                HashMap<ByteBuffer, ByteBuffer> result = new HashMap<ByteBuffer, ByteBuffer>();
                for (ByteBuffer key : keys) {
                    ByteBuffer offset = this.state.getOffset(key);
                    if (offset == null) continue;
                    result.put(key, offset);
                }
                return result;
            });
        }

        @Override
        public Future<Void> set(Map<ByteBuffer, ByteBuffer> values, Callback<Void> callback) {
            return this.executor.submit(() -> {
                values.forEach((k, v) -> this.state.setOffset((ByteBuffer)k, (ByteBuffer)v));
                if (callback != null) {
                    callback.onCompletion(null, null);
                }
                return null;
            });
        }

        @Override
        protected void save() {
            this.state.getPartitionsToOffset().forEach((partition, offset) -> {
                byte[] partitionBytes = partition.array();
                byte[] offsetBytes = offset.array();
                OffsetUtils.processPartitionKey(partitionBytes, offsetBytes, this.keyConverter, this.connectorPartitions);
            });
        }

        @Override
        public Set<Map<String, Object>> connectorPartitions(String connectorName) {
            return this.connectorPartitions.getOrDefault(connectorName, Collections.emptySet());
        }
    }

    public static class StatefulSchemaHistory
    extends AbstractSchemaHistory {
        private static final ILogger LOGGER = Logger.getLogger(StatefulSchemaHistory.class);
        private State state;

        @Override
        public void configure(Configuration config, HistoryRecordComparator comparator, SchemaHistoryListener listener, boolean useCatalogBeforeSchema) {
            super.configure(config, comparator, listener, useCatalogBeforeSchema);
            long jobId = Long.parseLong(config.getString(ReadCdcP.JET_JOB_ID_REPLACEMENT_PROP_2));
            this.state = State.get(jobId);
            Objects.requireNonNull(this.state);
        }

        @Override
        protected void storeRecord(HistoryRecord historyRecord) throws SchemaHistoryException {
            LOGGER.fine("Storing history record: " + String.valueOf(historyRecord));
            this.state.addHistory(historyRecord);
        }

        @Override
        protected void recoverRecords(Consumer<HistoryRecord> records) {
            List<HistoryRecord> historyRecords = this.state.getHistoryRecords();
            LOGGER.fine("Recovering %d schema history records", (Object)historyRecords.size());
            historyRecords.forEach(records);
        }

        @Override
        public boolean exists() {
            List<HistoryRecord> historyRecords = this.state.getHistoryRecords();
            return historyRecords != null && !historyRecords.isEmpty();
        }

        @Override
        public boolean storageExists() {
            List<HistoryRecord> historyRecords = this.state.getHistoryRecords();
            return historyRecords != null;
        }
    }

    record EventBatch(List<RecordChangeEvent<SourceRecord>> records, DebeziumEngine.RecordCommitter<RecordChangeEvent<SourceRecord>> committer) {
    }

    record CompletionEvent(boolean success, String message, Throwable throwable) {
    }
}

