/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc.impl;

import com.hazelcast.enterprise.jet.cdc.Operation;
import com.hazelcast.enterprise.jet.cdc.RecordPart;
import com.hazelcast.enterprise.jet.cdc.impl.ChangeRecordImpl;
import com.hazelcast.enterprise.jet.cdc.impl.RecordPartImpl;
import com.hazelcast.enterprise.jet.cdc.impl.State;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.HistoryRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class CdcSerializerHooks {

    public static final class CdcSourceStateHook
    implements SerializerHook<State> {
        public Class<State> getSerializationType() {
            return State.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<State>(){

                public int getTypeId() {
                    return -345;
                }

                public void write(ObjectDataOutput out, State state) throws IOException {
                    out.writeObject(state.getPartitionsToOffset());
                    ArrayList<HistoryRecord> historyRecords = new ArrayList<HistoryRecord>(state.getHistoryRecords());
                    out.writeInt(historyRecords.size());
                    for (HistoryRecord r : historyRecords) {
                        assert (r != null);
                        out.writeString(DocumentWriter.defaultWriter().write(r.document()));
                    }
                    out.writeObject(null);
                }

                public State read(ObjectDataInput in) throws IOException {
                    String r;
                    Map partitionsToOffset = (Map)in.readObject();
                    int sizeHint = in.readInt();
                    ArrayList<HistoryRecord> historyRecords = new ArrayList<HistoryRecord>(sizeHint);
                    while (this.isNotEmpty(r = in.readString())) {
                        Document doc = DocumentReader.defaultReader().read(r);
                        historyRecords.add(new HistoryRecord(doc));
                    }
                    return new State(partitionsToOffset, new CopyOnWriteArrayList<HistoryRecord>(historyRecords));
                }

                private boolean isNotEmpty(String s) {
                    return s != null && !s.isEmpty();
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class RecordPartImplHook
    implements SerializerHook<RecordPartImpl> {
        public Class<RecordPartImpl> getSerializationType() {
            return RecordPartImpl.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<RecordPartImpl>(){

                public int getTypeId() {
                    return -344;
                }

                public void write(ObjectDataOutput out, RecordPartImpl part) throws IOException {
                    out.writeString(part.toJson());
                }

                public RecordPartImpl read(ObjectDataInput in) throws IOException {
                    String json = Objects.requireNonNull(in.readString(), "RecordPart.json must not be null");
                    return new RecordPartImpl(json);
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class ChangeRecordImplHook
    implements SerializerHook<ChangeRecordImpl> {
        public Class<ChangeRecordImpl> getSerializationType() {
            return ChangeRecordImpl.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<ChangeRecordImpl>(){

                public int getTypeId() {
                    return -343;
                }

                public void write(ObjectDataOutput out, ChangeRecordImpl record) throws IOException {
                    out.writeLong(record.timestamp());
                    out.writeLong(record.sequenceSource());
                    out.writeLong(record.sequenceValue());
                    out.writeString(record.operation().code());
                    out.writeString(record.getKeyJson());
                    out.writeString(record.source().toJson());
                    RecordPart oldValue = record.oldValue();
                    out.writeString(oldValue == null ? null : oldValue.toJson());
                    RecordPart newValue = record.newValue();
                    out.writeString(newValue == null ? null : newValue.toJson());
                    out.writeString(record.table());
                    out.writeString(record.schema());
                    out.writeString(record.database());
                }

                public ChangeRecordImpl read(ObjectDataInput in) throws IOException {
                    long timestamp = in.readLong();
                    long sequenceSource = in.readLong();
                    long sequenceValue = in.readLong();
                    Operation operation = Operation.get(in.readString());
                    String keyJson = Objects.requireNonNull(in.readString(), "keyJson cannot be null");
                    String sourceJson = Objects.requireNonNull(in.readString(), "sourceJson cannot be null");
                    String oldValueJson = in.readString();
                    String newValueJson = in.readString();
                    String table = in.readString();
                    String schema = in.readString();
                    String database = in.readString();
                    return new ChangeRecordImpl(timestamp, sequenceSource, sequenceValue, operation, keyJson, sourceJson, oldValueJson, newValueJson, table, schema, database);
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }
}

