/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.enterprise.jet.cdc;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.enterprise.jet.cdc.ChangeRecord;
import com.hazelcast.enterprise.jet.cdc.Operation;
import com.hazelcast.enterprise.jet.cdc.impl.WriteCdcP;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.AbstractHazelcastConnectorSupplier;
import com.hazelcast.jet.impl.pipeline.SinkImpl;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.map.IMap;
import com.hazelcast.security.PermissionsUtil;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.Serializable;
import java.security.Permission;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CdcSinks {
    public static final HazelcastProperty SEQUENCE_CACHE_EXPIRATION_SECONDS = new HazelcastProperty("jet.cdc.sink.sequence.cache.expiration.seconds", Integer.valueOf(10), TimeUnit.SECONDS);

    private CdcSinks() {
    }

    @Nonnull
    public static <K, V> Sink<ChangeRecord> map(@Nonnull String mapName, @Nonnull FunctionEx<? super ChangeRecord, ? extends K> keyFn, @Nonnull FunctionEx<? super ChangeRecord, ? extends V> valueFn) {
        String name = "mapCdcSink(" + mapName + ")";
        return CdcSinks.sink(name, mapName, null, keyFn, valueFn);
    }

    @Nonnull
    public static <K, V> Sink<ChangeRecord> map(@Nonnull IMap<? super K, ? super V> map, @Nonnull FunctionEx<? super ChangeRecord, ? extends K> keyFn, @Nonnull FunctionEx<? super ChangeRecord, ? extends V> valueFn) {
        return CdcSinks.map(map.getName(), keyFn, valueFn);
    }

    @Nonnull
    public static <K, V> Sink<ChangeRecord> remoteMap(@Nonnull String mapName, @Nonnull ClientConfig clientConfig, @Nonnull FunctionEx<? super ChangeRecord, ? extends K> keyFn, @Nonnull FunctionEx<? super ChangeRecord, ? extends V> valueFn) {
        String name = "remoteMapCdcSink(" + mapName + ")";
        return CdcSinks.sink(name, mapName, clientConfig, keyFn, valueFn);
    }

    @Nonnull
    private static <K, V> Sink<ChangeRecord> sink(@Nonnull String name, @Nonnull String map, @Nullable ClientConfig clientConfig, @Nonnull FunctionEx<? super ChangeRecord, ? extends K> keyFn, @Nonnull FunctionEx<? super ChangeRecord, ? extends V> valueFn) {
        FunctionEx & Serializable toValueFn = (FunctionEx & Serializable)changeRecord -> Operation.DELETE.equals((Object)changeRecord.operation()) ? null : valueFn.apply(changeRecord);
        String clientXml = ImdgUtil.asXmlString((ClientConfig)clientConfig);
        ProcessorSupplier supplier = AbstractHazelcastConnectorSupplier.ofMap((String)clientXml, CdcSinks.procFn(name, map, clientXml, keyFn, toValueFn));
        ProcessorMetaSupplier metaSupplier = ProcessorMetaSupplier.of((Permission)PermissionsUtil.mapUpdatePermission((String)clientXml, (String)name), (ProcessorSupplier)supplier);
        return new SinkImpl(name, metaSupplier, SinkImpl.Type.DISTRIBUTED_PARTITIONED, keyFn);
    }

    private static <K, V> FunctionEx<HazelcastInstance, Processor> procFn(final String name, final String map, final String clientXml, final FunctionEx<? super ChangeRecord, ? extends K> keyFn, final FunctionEx<? super ChangeRecord, ? extends V> valueFn) {
        return new FunctionEx<HazelcastInstance, Processor>(){
            private static final long serialVersionUID = 1L;

            public Processor applyEx(HazelcastInstance instance) {
                return new WriteCdcP(instance, map, keyFn, valueFn);
            }

            public List<Permission> permissions() {
                return Collections.singletonList(PermissionsUtil.mapUpdatePermission((String)clientXml, (String)name));
            }
        };
    }
}

