/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.binlog.BinlogOffsetContext;
import io.debezium.connector.common.OffsetUtils;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlReadOnlyIncrementalSnapshotContext;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import java.util.Map;
import org.apache.kafka.connect.errors.ConnectException;

public class MySqlOffsetContext
extends BinlogOffsetContext<SourceInfo> {
    public MySqlOffsetContext(boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext, SourceInfo sourceInfo) {
        super(snapshot, snapshotCompleted, transactionContext, incrementalSnapshotContext, sourceInfo);
    }

    public static MySqlOffsetContext initial(MySqlConnectorConfig config) {
        MySqlOffsetContext offset = new MySqlOffsetContext(false, false, new TransactionContext(), (IncrementalSnapshotContext<TableId>)(config.isReadOnlyConnection() ? new MySqlReadOnlyIncrementalSnapshotContext() : new SignalBasedIncrementalSnapshotContext()), new SourceInfo(config));
        offset.setBinlogStartPoint("", 0L);
        return offset;
    }

    public static class Loader
    extends BinlogOffsetContext.Loader<MySqlOffsetContext> {
        private final MySqlConnectorConfig connectorConfig;

        public Loader(MySqlConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        public MySqlOffsetContext load(Map<String, ?> offset) {
            String binlogFilename = (String)offset.get("file");
            if (binlogFilename == null) {
                throw new ConnectException("Source offset 'file' parameter is missing");
            }
            long binlogPosition = OffsetUtils.longOffsetValue(offset, (String)"pos");
            MySqlOffsetContext offsetContext = new MySqlOffsetContext(Loader.isTrue(offset, "snapshot"), Loader.isTrue(offset, "snapshot_completed"), TransactionContext.load(offset), (IncrementalSnapshotContext<TableId>)(this.connectorConfig.isReadOnlyConnection() ? MySqlReadOnlyIncrementalSnapshotContext.load(offset) : SignalBasedIncrementalSnapshotContext.load(offset)), new SourceInfo(this.connectorConfig));
            offsetContext.setBinlogStartPoint(binlogFilename, binlogPosition);
            offsetContext.setInitialSkips(OffsetUtils.longOffsetValue(offset, (String)"event"), (int)OffsetUtils.longOffsetValue(offset, (String)"row"));
            offsetContext.setCompletedGtidSet((String)offset.get("gtids"));
            return offsetContext;
        }
    }
}

