/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.event;

import com.github.luben.zstd.Zstd;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.TransactionPayloadEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.TransactionPayloadEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.binlog.event.RowDeserializers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;

public class TransactionPayloadDeserializer
extends TransactionPayloadEventDataDeserializer {
    private final Map<Long, TableMapEventData> tableMapEventByTableId;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode eventDeserializationFailureHandlingMode;

    public TransactionPayloadDeserializer(Map<Long, TableMapEventData> tableMapEventByTableId, CommonConnectorConfig.EventProcessingFailureHandlingMode eventDeserializationFailureHandlingMode) {
        this.tableMapEventByTableId = tableMapEventByTableId;
        this.eventDeserializationFailureHandlingMode = eventDeserializationFailureHandlingMode;
    }

    @Override
    public TransactionPayloadEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        TransactionPayloadEventData eventData = new TransactionPayloadEventData();
        block5: while (inputStream.available() > 0) {
            int fieldType = 0;
            int fieldLen = 0;
            if (inputStream.available() >= 1) {
                fieldType = inputStream.readPackedInteger();
            }
            if (fieldType == 0) break;
            if (inputStream.available() >= 1) {
                fieldLen = inputStream.readPackedInteger();
            }
            switch (fieldType) {
                case 1: {
                    eventData.setPayloadSize(inputStream.readPackedInteger());
                    continue block5;
                }
                case 2: {
                    eventData.setCompressionType(inputStream.readPackedInteger());
                    continue block5;
                }
                case 3: {
                    eventData.setUncompressedSize(inputStream.readPackedInteger());
                    continue block5;
                }
            }
            inputStream.read(fieldLen);
        }
        if (eventData.getUncompressedSize() == 0) {
            eventData.setUncompressedSize(eventData.getPayloadSize());
        }
        eventData.setPayload(inputStream.read(eventData.getPayloadSize()));
        byte[] src = eventData.getPayload();
        byte[] dst = ByteBuffer.allocate(eventData.getUncompressedSize()).array();
        Zstd.decompressByteArray(dst, 0, dst.length, src, 0, src.length);
        ArrayList<Event> decompressedEvents = new ArrayList<Event>();
        EventDeserializer transactionPayloadEventDeserializer = new EventDeserializer();
        transactionPayloadEventDeserializer.setEventDataDeserializer(EventType.WRITE_ROWS, new RowDeserializers.WriteRowsDeserializer(this.tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        transactionPayloadEventDeserializer.setEventDataDeserializer(EventType.UPDATE_ROWS, new RowDeserializers.UpdateRowsDeserializer(this.tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        transactionPayloadEventDeserializer.setEventDataDeserializer(EventType.DELETE_ROWS, new RowDeserializers.DeleteRowsDeserializer(this.tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        transactionPayloadEventDeserializer.setEventDataDeserializer(EventType.EXT_WRITE_ROWS, new RowDeserializers.WriteRowsDeserializer(this.tableMapEventByTableId, this.eventDeserializationFailureHandlingMode).setMayContainExtraInformation(true));
        transactionPayloadEventDeserializer.setEventDataDeserializer(EventType.EXT_UPDATE_ROWS, new RowDeserializers.UpdateRowsDeserializer(this.tableMapEventByTableId, this.eventDeserializationFailureHandlingMode).setMayContainExtraInformation(true));
        transactionPayloadEventDeserializer.setEventDataDeserializer(EventType.EXT_DELETE_ROWS, new RowDeserializers.DeleteRowsDeserializer(this.tableMapEventByTableId, this.eventDeserializationFailureHandlingMode).setMayContainExtraInformation(true));
        ByteArrayInputStream destinationInputStream = new ByteArrayInputStream(dst);
        Event internalEvent = transactionPayloadEventDeserializer.nextEvent(destinationInputStream);
        while (internalEvent != null) {
            decompressedEvents.add(internalEvent);
            if (internalEvent.getHeader().getEventType() == EventType.TABLE_MAP && internalEvent.getData() != null) {
                TableMapEventData tableMapEvent = (TableMapEventData)internalEvent.getData();
                this.tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
            }
            internalEvent = transactionPayloadEventDeserializer.nextEvent(destinationInputStream);
        }
        eventData.setUncompressedEvents(decompressedEvents);
        return eventData;
    }
}

