/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.BinaryNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.BooleanNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.IntNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.NullNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.ShortNode;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class JoinGroupResponseDataJsonConverter {
    public static JoinGroupResponseData read(JsonNode _node, short _version) {
        JoinGroupResponseData _object = new JoinGroupResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("JoinGroupResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
            }
            _object.throttleTimeMs = 0;
        } else {
            _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "JoinGroupResponseData");
        }
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("JoinGroupResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "JoinGroupResponseData");
        JsonNode _generationIdNode = _node.get("generationId");
        if (_generationIdNode == null) {
            throw new RuntimeException("JoinGroupResponseData: unable to locate field 'generationId', which is mandatory in version " + _version);
        }
        _object.generationId = MessageUtil.jsonNodeToInt(_generationIdNode, "JoinGroupResponseData");
        JsonNode _protocolTypeNode = _node.get("protocolType");
        if (_protocolTypeNode == null) {
            if (_version >= 7) {
                throw new RuntimeException("JoinGroupResponseData: unable to locate field 'protocolType', which is mandatory in version " + _version);
            }
            _object.protocolType = null;
        } else if (_protocolTypeNode.isNull()) {
            _object.protocolType = null;
        } else {
            if (!_protocolTypeNode.isTextual()) {
                throw new RuntimeException("JoinGroupResponseData expected a string type, but got " + _node.getNodeType());
            }
            _object.protocolType = _protocolTypeNode.asText();
        }
        JsonNode _protocolNameNode = _node.get("protocolName");
        if (_protocolNameNode == null) {
            throw new RuntimeException("JoinGroupResponseData: unable to locate field 'protocolName', which is mandatory in version " + _version);
        }
        if (_protocolNameNode.isNull()) {
            _object.protocolName = null;
        } else {
            if (!_protocolNameNode.isTextual()) {
                throw new RuntimeException("JoinGroupResponseData expected a string type, but got " + _node.getNodeType());
            }
            _object.protocolName = _protocolNameNode.asText();
        }
        JsonNode _leaderNode = _node.get("leader");
        if (_leaderNode == null) {
            throw new RuntimeException("JoinGroupResponseData: unable to locate field 'leader', which is mandatory in version " + _version);
        }
        if (!_leaderNode.isTextual()) {
            throw new RuntimeException("JoinGroupResponseData expected a string type, but got " + _node.getNodeType());
        }
        _object.leader = _leaderNode.asText();
        JsonNode _skipAssignmentNode = _node.get("skipAssignment");
        if (_skipAssignmentNode == null) {
            if (_version >= 9) {
                throw new RuntimeException("JoinGroupResponseData: unable to locate field 'skipAssignment', which is mandatory in version " + _version);
            }
            _object.skipAssignment = false;
        } else {
            if (!_skipAssignmentNode.isBoolean()) {
                throw new RuntimeException("JoinGroupResponseData expected Boolean type, but got " + _node.getNodeType());
            }
            _object.skipAssignment = _skipAssignmentNode.asBoolean();
        }
        JsonNode _memberIdNode = _node.get("memberId");
        if (_memberIdNode == null) {
            throw new RuntimeException("JoinGroupResponseData: unable to locate field 'memberId', which is mandatory in version " + _version);
        }
        if (!_memberIdNode.isTextual()) {
            throw new RuntimeException("JoinGroupResponseData expected a string type, but got " + _node.getNodeType());
        }
        _object.memberId = _memberIdNode.asText();
        JsonNode _membersNode = _node.get("members");
        if (_membersNode == null) {
            throw new RuntimeException("JoinGroupResponseData: unable to locate field 'members', which is mandatory in version " + _version);
        }
        if (!_membersNode.isArray()) {
            throw new RuntimeException("JoinGroupResponseData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<JoinGroupResponseData.JoinGroupResponseMember> _collection = new ArrayList<JoinGroupResponseData.JoinGroupResponseMember>(_membersNode.size());
        _object.members = _collection;
        for (JsonNode _element : _membersNode) {
            _collection.add(JoinGroupResponseMemberJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(JoinGroupResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version >= 2) {
            _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        }
        _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
        _node.set("generationId", (JsonNode)new IntNode(_object.generationId));
        if (_version >= 7) {
            if (_object.protocolType == null) {
                _node.set("protocolType", (JsonNode)NullNode.instance);
            } else {
                _node.set("protocolType", (JsonNode)new TextNode(_object.protocolType));
            }
        }
        if (_object.protocolName == null) {
            _node.set("protocolName", (JsonNode)NullNode.instance);
        } else {
            _node.set("protocolName", (JsonNode)new TextNode(_object.protocolName));
        }
        _node.set("leader", (JsonNode)new TextNode(_object.leader));
        if (_version >= 9) {
            _node.set("skipAssignment", (JsonNode)BooleanNode.valueOf((boolean)_object.skipAssignment));
        } else if (_object.skipAssignment) {
            throw new UnsupportedVersionException("Attempted to write a non-default skipAssignment at version " + _version);
        }
        _node.set("memberId", (JsonNode)new TextNode(_object.memberId));
        ArrayNode _membersArray = new ArrayNode(JsonNodeFactory.instance);
        for (JoinGroupResponseData.JoinGroupResponseMember _element : _object.members) {
            _membersArray.add(JoinGroupResponseMemberJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("members", (JsonNode)_membersArray);
        return _node;
    }

    public static JsonNode write(JoinGroupResponseData _object, short _version) {
        return JoinGroupResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class JoinGroupResponseMemberJsonConverter {
        public static JoinGroupResponseData.JoinGroupResponseMember read(JsonNode _node, short _version) {
            JoinGroupResponseData.JoinGroupResponseMember _object = new JoinGroupResponseData.JoinGroupResponseMember();
            JsonNode _memberIdNode = _node.get("memberId");
            if (_memberIdNode == null) {
                throw new RuntimeException("JoinGroupResponseMember: unable to locate field 'memberId', which is mandatory in version " + _version);
            }
            if (!_memberIdNode.isTextual()) {
                throw new RuntimeException("JoinGroupResponseMember expected a string type, but got " + _node.getNodeType());
            }
            _object.memberId = _memberIdNode.asText();
            JsonNode _groupInstanceIdNode = _node.get("groupInstanceId");
            if (_groupInstanceIdNode == null) {
                if (_version >= 5) {
                    throw new RuntimeException("JoinGroupResponseMember: unable to locate field 'groupInstanceId', which is mandatory in version " + _version);
                }
                _object.groupInstanceId = null;
            } else if (_groupInstanceIdNode.isNull()) {
                _object.groupInstanceId = null;
            } else {
                if (!_groupInstanceIdNode.isTextual()) {
                    throw new RuntimeException("JoinGroupResponseMember expected a string type, but got " + _node.getNodeType());
                }
                _object.groupInstanceId = _groupInstanceIdNode.asText();
            }
            JsonNode _metadataNode = _node.get("metadata");
            if (_metadataNode == null) {
                throw new RuntimeException("JoinGroupResponseMember: unable to locate field 'metadata', which is mandatory in version " + _version);
            }
            _object.metadata = MessageUtil.jsonNodeToBinary(_metadataNode, "JoinGroupResponseMember");
            return _object;
        }

        public static JsonNode write(JoinGroupResponseData.JoinGroupResponseMember _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("memberId", (JsonNode)new TextNode(_object.memberId));
            if (_version >= 5) {
                if (_object.groupInstanceId == null) {
                    _node.set("groupInstanceId", (JsonNode)NullNode.instance);
                } else {
                    _node.set("groupInstanceId", (JsonNode)new TextNode(_object.groupInstanceId));
                }
            }
            _node.set("metadata", (JsonNode)new BinaryNode(Arrays.copyOf(_object.metadata, _object.metadata.length)));
            return _node;
        }

        public static JsonNode write(JoinGroupResponseData.JoinGroupResponseMember _object, short _version) {
            return JoinGroupResponseMemberJsonConverter.write(_object, _version, true);
        }
    }
}

