/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapstore;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.sql.SqlColumnMetadata;
import java.util.List;

class JdbcParameters {
    private int idPos;
    private Object[] params;

    JdbcParameters() {
    }

    void setIdPos(int idPos) {
        this.idPos = idPos;
    }

    Object[] getParams() {
        return this.params;
    }

    void setParams(Object[] params) {
        this.params = params;
    }

    void shiftIdParameterToEnd() {
        Object id = this.params[this.idPos];
        for (int i = this.idPos; i < this.params.length - 1; ++i) {
            this.params[i] = this.params[i + 1];
        }
        this.params[this.params.length - 1] = id;
    }

    static <K, V> JdbcParameters convert(K key, V value, List<SqlColumnMetadata> columnMetadataList, String idColumn, boolean singleColumnAsValue) {
        JdbcParameters jdbcParameters = new JdbcParameters();
        int idPos = -1;
        Object[] params = new Object[columnMetadataList.size()];
        block15: for (int i = 0; i < columnMetadataList.size(); ++i) {
            SqlColumnMetadata columnMetadata = columnMetadataList.get(i);
            String columnName = columnMetadata.getName();
            if (columnName.equals(idColumn)) {
                idPos = i;
                params[i] = key;
                continue;
            }
            if (columnMetadataList.size() == 2 && singleColumnAsValue) {
                params[i] = value;
                continue;
            }
            GenericRecord genericRecord = (GenericRecord)value;
            switch (columnMetadata.getType()) {
                case VARCHAR: {
                    params[i] = genericRecord.getString(columnName);
                    continue block15;
                }
                case BOOLEAN: {
                    params[i] = genericRecord.getBoolean(columnName);
                    continue block15;
                }
                case TINYINT: {
                    params[i] = genericRecord.getInt8(columnName);
                    continue block15;
                }
                case SMALLINT: {
                    params[i] = genericRecord.getInt16(columnName);
                    continue block15;
                }
                case INTEGER: {
                    params[i] = genericRecord.getInt32(columnName);
                    continue block15;
                }
                case BIGINT: {
                    params[i] = genericRecord.getInt64(columnName);
                    continue block15;
                }
                case REAL: {
                    params[i] = Float.valueOf(genericRecord.getFloat32(columnName));
                    continue block15;
                }
                case DOUBLE: {
                    params[i] = genericRecord.getFloat64(columnName);
                    continue block15;
                }
                case DATE: {
                    params[i] = genericRecord.getDate(columnName);
                    continue block15;
                }
                case TIME: {
                    params[i] = genericRecord.getTime(columnName);
                    continue block15;
                }
                case TIMESTAMP: {
                    params[i] = genericRecord.getTimestamp(columnName);
                    continue block15;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    params[i] = genericRecord.getTimestampWithTimezone(columnName);
                    continue block15;
                }
                case DECIMAL: {
                    params[i] = genericRecord.getDecimal(columnName);
                    continue block15;
                }
                default: {
                    throw new HazelcastException("Column type " + String.valueOf(columnMetadata.getType()) + " not supported");
                }
            }
        }
        jdbcParameters.setParams(params);
        jdbcParameters.setIdPos(idPos);
        return jdbcParameters;
    }
}

