/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.time;

import com.mongodb.annotations.Immutable;
import java.time.Duration;

@Immutable
public final class TimePoint
implements Comparable<TimePoint> {
    private final long nanos;

    private TimePoint(long nanos) {
        this.nanos = nanos;
    }

    public static TimePoint now() {
        return TimePoint.at(System.nanoTime());
    }

    static TimePoint at(long nanos) {
        return new TimePoint(nanos);
    }

    public Duration durationSince(TimePoint t2) {
        return Duration.ofNanos(this.nanos - t2.nanos);
    }

    public Duration elapsed() {
        return Duration.ofNanos(System.nanoTime() - this.nanos);
    }

    public TimePoint add(Duration duration) {
        long durationNanos = duration.toNanos();
        return TimePoint.at(this.nanos + durationNanos);
    }

    @Override
    public int compareTo(TimePoint t2) {
        return Long.signum(this.nanos - t2.nanos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePoint timePoint = (TimePoint)o;
        return this.nanos == timePoint.nanos;
    }

    public int hashCode() {
        return Long.hashCode(this.nanos);
    }

    public String toString() {
        return "TimePoint{nanos=" + this.nanos + '}';
    }
}

