/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.Locks;
import com.mongodb.lang.Nullable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public class ClusterClock {
    private static final String CLUSTER_TIME_KEY = "clusterTime";
    private final ReentrantLock lock = new ReentrantLock();
    private BsonDocument clusterTime;

    public BsonDocument getCurrent() {
        return Locks.withInterruptibleLock((Lock)this.lock, () -> this.clusterTime);
    }

    public BsonTimestamp getClusterTime() {
        return Locks.withInterruptibleLock((Lock)this.lock, () -> this.clusterTime != null ? this.clusterTime.getTimestamp(CLUSTER_TIME_KEY) : null);
    }

    public void advance(@Nullable BsonDocument other) {
        Locks.withInterruptibleLock((Lock)this.lock, () -> {
            this.clusterTime = this.greaterOf(other);
            return this.clusterTime;
        });
    }

    public BsonDocument greaterOf(@Nullable BsonDocument other) {
        return Locks.withInterruptibleLock((Lock)this.lock, () -> {
            if (other == null) {
                return this.clusterTime;
            }
            if (this.clusterTime == null) {
                return other;
            }
            return other.getTimestamp(CLUSTER_TIME_KEY).compareTo(this.clusterTime.getTimestamp(CLUSTER_TIME_KEY)) > 0 ? other : this.clusterTime;
        });
    }
}

