/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.vault;

import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RangeOptions;
import com.mongodb.crypt.capi.MongoExplicitEncryptOptions;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;

public final class EncryptOptionsHelper {
    public static MongoExplicitEncryptOptions asMongoExplicitEncryptOptions(EncryptOptions options) {
        RangeOptions rangeOptions;
        MongoExplicitEncryptOptions.Builder encryptOptionsBuilder = MongoExplicitEncryptOptions.builder().algorithm(options.getAlgorithm());
        if (options.getKeyId() != null) {
            encryptOptionsBuilder.keyId(options.getKeyId());
        }
        if (options.getKeyAltName() != null) {
            encryptOptionsBuilder.keyAltName(options.getKeyAltName());
        }
        if (options.getContentionFactor() != null) {
            encryptOptionsBuilder.contentionFactor(options.getContentionFactor());
        }
        if (options.getQueryType() != null) {
            encryptOptionsBuilder.queryType(options.getQueryType());
        }
        if ((rangeOptions = options.getRangeOptions()) != null) {
            Integer precision;
            Long sparsity;
            BsonValue max;
            BsonDocument rangeOptionsBsonDocument = new BsonDocument();
            BsonValue min2 = rangeOptions.getMin();
            if (min2 != null) {
                rangeOptionsBsonDocument.put("min", min2);
            }
            if ((max = rangeOptions.getMax()) != null) {
                rangeOptionsBsonDocument.put("max", max);
            }
            if ((sparsity = rangeOptions.getSparsity()) != null) {
                rangeOptionsBsonDocument.put("sparsity", new BsonInt64(sparsity));
            }
            if ((precision = rangeOptions.getPrecision()) != null) {
                rangeOptionsBsonDocument.put("precision", new BsonInt32(precision));
            }
            encryptOptionsBuilder.rangeOptions(rangeOptionsBsonDocument);
        }
        return encryptOptionsBuilder.build();
    }

    private EncryptOptionsHelper() {
    }
}

