/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.function.RunnableEx;
import com.hazelcast.jet.impl.processor.TwoPhaseSnapshotCommitUtility;
import com.hazelcast.jet.impl.processor.UnboundedTransactionsProcessorUtility;
import com.hazelcast.jet.mongodb.WriteMode;
import com.hazelcast.jet.mongodb.impl.Mappers;
import com.hazelcast.jet.mongodb.impl.MongoConnection;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.mongodb.impl.WriteMongoParams;
import com.hazelcast.jet.retry.IntervalFunction;
import com.hazelcast.jet.retry.RetryStrategies;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.jet.retry.impl.RetryTracker;
import com.hazelcast.logging.ILogger;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoServerException;
import com.mongodb.MongoSocketException;
import com.mongodb.TransactionOptions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.model.WriteModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class WriteMongoP<IN, I>
extends AbstractProcessor {
    private static final int MAX_BATCH_SIZE = 2000;
    private static final RetryStrategy BACKPRESSURE_RETRY_STRATEGY = RetryStrategies.custom().intervalFunction(IntervalFunction.exponentialBackoffWithCap((long)100L, (double)2.0, (long)3000L)).build();
    private final MongoConnection connection;
    private final Class<I> documentType;
    private final FunctionEx<IN, I> intermediateMappingFn;
    private final RetryTracker backpressureTracker;
    private ILogger logger;
    private UnboundedTransactionsProcessorUtility<MongoTransactionId, MongoTransaction> transactionUtility;
    private final CollectionPicker<I> collectionPicker;
    private final FunctionEx<I, Object> documentIdentityFn;
    private final String documentIdentityFieldName;
    private final ReplaceOptions replaceOptions;
    private final Map<MongoTransactionId, MongoTransaction> activeTransactions = new HashMap<MongoTransactionId, MongoTransaction>();
    private final RetryStrategy commitRetryStrategy;
    private final SupplierEx<TransactionOptions> transactionOptionsSup;
    private final WriteMode writeMode;
    private final FunctionEx<I, WriteModel<I>> writeModelFn;

    public WriteMongoP(WriteMongoParams<I> params) {
        this.connection = new MongoConnection(params.clientSupplier, params.dataConnectionRef, client -> {});
        this.documentIdentityFn = params.documentIdentityFn;
        this.documentIdentityFieldName = params.documentIdentityFieldName;
        this.documentType = params.documentType;
        ReplaceOptions options = new ReplaceOptions().upsert(true);
        params.getReplaceOptionAdjuster().accept((Object)options);
        this.replaceOptions = options;
        this.commitRetryStrategy = params.commitRetryStrategy;
        this.transactionOptionsSup = params.transactionOptionsSup;
        this.collectionPicker = params.databaseName != null ? new ConstantCollectionPicker(params.checkExistenceOnEachConnect, params.databaseName, params.collectionName) : new FunctionalCollectionPicker(params.checkExistenceOnEachConnect, params.databaseNameSelectFn, params.collectionNameSelectFn);
        this.intermediateMappingFn = params.getIntermediateMappingFn();
        this.writeMode = params.getWriteMode();
        this.writeModelFn = params.getOptionalWriteModelFn().orElse(this::defaultWriteModelSupplier);
        this.backpressureTracker = new RetryTracker(BACKPRESSURE_RETRY_STRATEGY);
    }

    protected void init(@Nonnull Processor.Context context) {
        this.logger = context.logger();
        this.connection.assembleSupplier(com.hazelcast.jet.impl.util.Util.getNodeEngine((HazelcastInstance)context.hazelcastInstance()));
        int processorIndex = context.globalProcessorIndex();
        this.transactionUtility = new UnboundedTransactionsProcessorUtility(this.getOutbox(), context, context.processingGuarantee(), () -> new MongoTransactionId(context, processorIndex), (FunctionEx & Serializable)txId -> new MongoTransaction((MongoTransactionId)txId, this.logger), (ConsumerEx & Serializable)txId -> {
            MongoTransaction mongoTransaction = this.activeTransactions.get(txId);
            this.refreshTransaction(mongoTransaction, true);
        }, (RunnableEx & Serializable)() -> {
            for (MongoTransaction tx : this.activeTransactions.values()) {
                this.refreshTransaction(tx, false);
            }
        });
    }

    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        return this.transactionUtility.tryProcess();
    }

    public void process(int ordinal, @Nonnull Inbox inbox) {
        if (!this.connection.reconnectIfNecessary()) {
            return;
        }
        if (this.backpressureTracker.needsToWait()) {
            return;
        }
        try {
            MongoTransaction mongoTransaction = (MongoTransaction)this.transactionUtility.activeTransaction();
            ArrayList<I> items = WriteMongoP.drainItems(inbox);
            Map itemsPerCollection = items.stream().map(this.intermediateMappingFn).map(e -> Tuple2.tuple2((Object)this.collectionPicker.pick(e), (Object)e)).collect(Collectors.groupingBy(Tuple2::requiredF0, Collectors.mapping(Tuple2::requiredF1, Collectors.toList())));
            for (Map.Entry entry : itemsPerCollection.entrySet()) {
                MongoCollectionKey collectionKey = entry.getKey();
                MongoCollection<I> collection = collectionKey.get(this.connection.client(), this.documentType);
                ArrayList writes = new ArrayList();
                for (Object item : entry.getValue()) {
                    WriteModel write = (WriteModel)this.writeModelFn.apply(item);
                    writes.add(write);
                }
                if (this.transactionUtility.usesTransactionLifecycle()) {
                    Preconditions.checkNotNull((Object)mongoTransaction, (String)"there is no active transaction");
                    mongoTransaction.addWrites(collectionKey, writes);
                    continue;
                }
                collection.bulkWrite(writes);
            }
            for (int i = 0; i < items.size(); ++i) {
                inbox.remove();
            }
            this.backpressureTracker.reset();
        }
        catch (MongoBulkWriteException e2) {
            if (e2.hasErrorLabel("TransientTransactionError")) {
                this.logger.warning("Unable to process element: " + e2.getMessage());
                this.backpressureTracker.attemptFailed();
            }
            throw new JetException((Throwable)e2);
        }
        catch (MongoClientException | MongoServerException | MongoSocketException e3) {
            this.logger.warning("Unable to process Mongo Sink, will retry " + e3.getMessage(), (Throwable)e3);
            this.backpressureTracker.attemptFailed();
        }
        catch (Exception e4) {
            throw new JetException((Throwable)e4);
        }
    }

    private static <I> ArrayList<I> drainItems(Inbox inbox) {
        ArrayList items = new ArrayList();
        for (Object item : inbox) {
            items.add(item);
            if (items.size() < 2000) continue;
            break;
        }
        return items;
    }

    private WriteModel<I> defaultWriteModelSupplier(I item) {
        Object id = this.documentIdentityFn.apply(item);
        switch (this.writeMode) {
            case INSERT_ONLY: {
                return this.insert(item);
            }
            case UPDATE_ONLY: {
                return this.update(id, item, new UpdateOptions().upsert(false));
            }
            case UPSERT: {
                return this.upsert(id, item);
            }
            case REPLACE: {
                return this.replace(id, item);
            }
        }
        throw new IllegalStateException("unknown write mode");
    }

    WriteModel<I> insert(I item) {
        return new InsertOneModel<I>(item);
    }

    WriteModel<I> upsert(Object id, I item) {
        if (id == null) {
            return new InsertOneModel<I>(item);
        }
        return this.update(id, item, new UpdateOptions().upsert(true));
    }

    WriteModel<I> replace(Object id, I item) {
        if (id == null) {
            return new InsertOneModel<I>(item);
        }
        Bson filter = Filters.eq(this.documentIdentityFieldName, id);
        return new ReplaceOneModel<I>(filter, item, this.replaceOptions);
    }

    WriteModel<I> update(Object id, I item, UpdateOptions opts) {
        Bson filter = Filters.eq(this.documentIdentityFieldName, id);
        BsonDocument doc = Mappers.toBsonDocument(item);
        List updates = doc.entrySet().stream().map(e -> {
            String field = (String)e.getKey();
            BsonValue value = (BsonValue)e.getValue();
            return Updates.set(field, value);
        }).collect(Collectors.toList());
        return new UpdateOneModel(filter, updates, opts);
    }

    public void close() {
        IOUtil.closeResource(this.transactionUtility);
        IOUtil.closeResource((AutoCloseable)this.connection);
    }

    public boolean isCooperative() {
        return false;
    }

    public boolean snapshotCommitPrepare() {
        return this.transactionUtility.snapshotCommitPrepare();
    }

    public boolean snapshotCommitFinish(boolean success) {
        return this.transactionUtility.snapshotCommitFinish(success);
    }

    public boolean complete() {
        this.transactionUtility.afterCompleted();
        return true;
    }

    protected void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        this.transactionUtility.restoreFromSnapshot(key, value);
    }

    private void refreshTransaction(MongoTransaction transaction, boolean commit) {
        if (!this.transactionUtility.usesTransactionLifecycle()) {
            return;
        }
        if (transaction == null) {
            return;
        }
        if (commit) {
            transaction.commit();
        } else {
            transaction.rollback();
        }
    }

    private static final class ConstantCollectionPicker<I>
    implements CollectionPicker<I> {
        private final MongoCollectionKey key;

        private ConstantCollectionPicker(boolean throwOnNonExisting, String databaseName, String collectionName) {
            this.key = new MongoCollectionKey(throwOnNonExisting, databaseName, collectionName);
        }

        @Override
        public MongoCollectionKey pick(I item) {
            return this.key;
        }
    }

    private static interface CollectionPicker<I> {
        public MongoCollectionKey pick(I var1);
    }

    private static final class FunctionalCollectionPicker<I>
    implements CollectionPicker<I> {
        private final FunctionEx<I, String> databaseNameSelectFn;
        private final FunctionEx<I, String> collectionNameSelectFn;
        private final boolean throwOnNonExisting;

        private FunctionalCollectionPicker(boolean throwOnNonExisting, FunctionEx<I, String> databaseNameSelectFn, FunctionEx<I, String> collectionNameSelectFn) {
            this.throwOnNonExisting = throwOnNonExisting;
            this.databaseNameSelectFn = databaseNameSelectFn;
            this.collectionNameSelectFn = collectionNameSelectFn;
        }

        @Override
        public MongoCollectionKey pick(I item) {
            String databaseName = (String)this.databaseNameSelectFn.apply(item);
            String collectionName = (String)this.collectionNameSelectFn.apply(item);
            return new MongoCollectionKey(this.throwOnNonExisting, databaseName, collectionName);
        }
    }

    private final class MongoTransaction
    implements TwoPhaseSnapshotCommitUtility.TransactionalResource<MongoTransactionId> {
        private ClientSession clientSession;
        private final ILogger logger;
        private final MongoTransactionId transactionId;
        private boolean txnInitialized;
        private final RetryTracker commitRetryTracker;
        private final Map<MongoCollectionKey, List<WriteModel<I>>> documents = new HashMap();

        private MongoTransaction(MongoTransactionId transactionId, ILogger logger) {
            this.transactionId = transactionId;
            this.logger = logger;
            this.commitRetryTracker = new RetryTracker(WriteMongoP.this.commitRetryStrategy);
        }

        public MongoTransactionId id() {
            return this.transactionId;
        }

        void addWrites(MongoCollectionKey key, List<WriteModel<I>> writes) {
            this.documents.computeIfAbsent(key, k -> new ArrayList()).addAll(writes);
        }

        public void begin() {
            if (!this.txnInitialized) {
                this.logger.fine("beginning transaction %s", (Object)this.transactionId);
                this.txnInitialized = true;
            }
            this.clientSession = WriteMongoP.this.connection.client().startSession();
            WriteMongoP.this.activeTransactions.put(this.transactionId, this);
        }

        public void commit() {
            if (this.transactionId != null) {
                boolean success = false;
                while (this.commitRetryTracker.shouldTryAgain() && !success) {
                    try {
                        this.startTransactionQuietly();
                        for (Map.Entry entry : this.documents.entrySet()) {
                            List writes;
                            MongoCollection collection = entry.getKey().get(WriteMongoP.this.connection.client(), WriteMongoP.this.documentType);
                            BulkWriteResult result = collection.bulkWrite(this.clientSession, writes = entry.getValue());
                            if (result.wasAcknowledged()) continue;
                            this.commitRetryTracker.attemptFailed();
                            break;
                        }
                        this.clientSession.commitTransaction();
                        this.commitRetryTracker.reset();
                        success = true;
                    }
                    catch (MongoException e) {
                        this.tryExternalRollback();
                        this.commitRetryTracker.attemptFailed();
                        if (this.commitRetryTracker.shouldTryAgain() && e.hasErrorLabel("TransientTransactionError")) continue;
                        throw e;
                    }
                    catch (IllegalStateException e) {
                        this.tryExternalRollback();
                        this.commitRetryTracker.attemptFailed();
                        if (this.commitRetryTracker.shouldTryAgain()) continue;
                        throw e;
                    }
                }
            }
        }

        private void startTransactionQuietly() {
            block2: {
                try {
                    this.clientSession.startTransaction((TransactionOptions)WriteMongoP.this.transactionOptionsSup.get());
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("already in progress")) break block2;
                    throw ExceptionUtil.sneakyThrow((Throwable)e);
                }
            }
        }

        public void rollback() {
            if (this.transactionId != null) {
                this.tryExternalRollback();
                this.documents.clear();
            }
        }

        private void tryExternalRollback() {
            try {
                this.clientSession.abortTransaction();
            }
            catch (IllegalStateException e) {
                EmptyStatement.ignore((Throwable)e);
            }
        }

        public void release() {
            if (this.clientSession != null) {
                this.clientSession.close();
            }
            WriteMongoP.this.activeTransactions.remove(this.transactionId);
        }
    }

    private static final class MongoCollectionKey {
        @Nonnull
        private final String collectionName;
        @Nonnull
        private final String databaseName;
        private final boolean checkExistenceOnReconnect;

        MongoCollectionKey(boolean checkExistenceOnReconnect, @Nonnull String databaseName, @Nonnull String collectionName) {
            this.checkExistenceOnReconnect = checkExistenceOnReconnect;
            this.collectionName = collectionName;
            this.databaseName = databaseName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MongoCollectionKey that = (MongoCollectionKey)o;
            return this.collectionName.equals(that.collectionName) && this.databaseName.equals(that.databaseName);
        }

        public int hashCode() {
            return Objects.hash(this.collectionName, this.databaseName);
        }

        public String toString() {
            return "MongoCollectionKey{collectionName='" + this.collectionName + "', databaseName='" + this.databaseName + "'}";
        }

        @Nonnull
        public <I> MongoCollection<I> get(MongoClient mongoClient, Class<I> documentType) {
            if (this.checkExistenceOnReconnect) {
                MongoUtilities.checkDatabaseExists(mongoClient, this.databaseName);
            }
            MongoDatabase database = mongoClient.getDatabase(this.databaseName);
            if (this.checkExistenceOnReconnect) {
                MongoUtilities.checkCollectionExists(database, this.collectionName);
            }
            return database.getCollection(this.collectionName, documentType).withCodecRegistry(Mappers.defaultCodecRegistry());
        }
    }

    private static class MongoTransactionId
    implements TwoPhaseSnapshotCommitUtility.TransactionId,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int processorIndex;
        private final String mongoId;
        private final int hashCode;

        MongoTransactionId(long jobId, String jobName, @Nonnull String vertexId, int processorIndex) {
            this.processorIndex = processorIndex;
            String mongoId = "jet.job-" + Util.idToString((long)jobId) + "." + MongoTransactionId.sanitize(jobName) + "." + MongoTransactionId.sanitize(vertexId) + "." + processorIndex;
            this.mongoId = mongoId;
            this.hashCode = Objects.hash(jobId, vertexId, processorIndex);
        }

        MongoTransactionId(Processor.Context context, int processorIndex) {
            this(context.jobId(), context.jobConfig().getName(), context.vertexName(), processorIndex);
        }

        public int index() {
            return this.processorIndex;
        }

        public String toString() {
            return "MongoTransactionId{processorIndex=" + this.processorIndex + ", mongoId='" + this.mongoId + "', hashCode=" + this.hashCode + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MongoTransactionId that = (MongoTransactionId)o;
            return this.processorIndex == that.processorIndex && this.hashCode == that.hashCode && Objects.equals(this.mongoId, that.mongoId);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static String sanitize(String s2) {
            if (s2 == null) {
                return "";
            }
            return s2.replaceAll("[^\\p{Alnum}.\\-_$#/{}\\[\\]]", "_");
        }
    }
}

