/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.impl;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.mongodb.dataconnection.MongoDataConnection;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.retry.IntervalFunction;
import com.hazelcast.jet.retry.RetryStrategies;
import com.hazelcast.jet.retry.RetryStrategy;
import com.hazelcast.jet.retry.impl.RetryTracker;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoSocketException;
import com.mongodb.client.MongoClient;
import java.io.Closeable;
import java.util.function.Consumer;
import org.bson.BsonArray;
import org.bson.BsonString;
import org.bson.BsonValue;

class MongoConnection
implements Closeable {
    private static final RetryStrategy RETRY_STRATEGY = RetryStrategies.custom().intervalFunction(IntervalFunction.exponentialBackoffWithCap((long)100L, (double)2.0, (long)3000L)).maxAttempts(20).build();
    private SupplierEx<? extends MongoClient> clientSupplier;
    private final DataConnectionRef dataConnectionRef;
    private final Consumer<MongoClient> afterConnection;
    private final RetryTracker connectionRetryTracker;
    private final ILogger logger = Logger.getLogger(MongoConnection.class);
    private MongoClient mongoClient;
    private MongoDataConnection dataConnection;
    private Exception lastException;

    MongoConnection(SupplierEx<? extends MongoClient> clientSupplier, DataConnectionRef dataConnectionRef, Consumer<MongoClient> afterConnection) {
        this.clientSupplier = clientSupplier;
        this.dataConnectionRef = dataConnectionRef;
        this.afterConnection = afterConnection;
        this.connectionRetryTracker = new RetryTracker(RETRY_STRATEGY);
    }

    MongoClient client() {
        Preconditions.checkState((boolean)this.reconnectIfNecessary(), (String)"should be connected");
        return this.mongoClient;
    }

    boolean reconnectIfNecessary() {
        if (this.mongoClient != null) {
            return true;
        }
        if (this.connectionRetryTracker.needsToWait()) {
            return false;
        }
        if (this.connectionRetryTracker.shouldTryAgain()) {
            try {
                this.mongoClient = (MongoClient)this.clientSupplier.get();
                this.afterConnection.accept(this.mongoClient);
                this.connectionRetryTracker.reset();
                this.lastException = null;
                return true;
            }
            catch (MongoCommandException e) {
                BsonArray codes = this.codes(e);
                if (codes.contains(new BsonString("NonResumableChangeStreamError"))) {
                    throw new JetException("NonResumableChangeStreamError thrown by Mongo", (Throwable)e);
                }
                this.connectionRetryTracker.attemptFailed();
                this.logger.warning("Could not connect to MongoDB." + this.willRetryMessage(), (Throwable)e);
                this.lastException = e;
                return false;
            }
            catch (MongoClientException | MongoSocketException e) {
                this.lastException = e;
                this.connectionRetryTracker.attemptFailed();
                this.logger.warning("Could not connect to MongoDB due to client/socket error." + this.willRetryMessage(), (Throwable)e);
                return false;
            }
            catch (Exception e) {
                throw new JetException("Cannot connect to MongoDB, seems to be non-transient error: " + e.getMessage(), (Throwable)e);
            }
        }
        throw new JetException("cannot connect to MongoDB", (Throwable)this.lastException);
    }

    private String willRetryMessage() {
        return this.connectionRetryTracker.shouldTryAgain() ? " Operation will be retried in " + this.connectionRetryTracker.getNextWaitTimeMs() + "ms." : "";
    }

    private BsonArray codes(MongoCommandException e) {
        BsonValue errorLabels = e.getResponse().get("errorLabels");
        if (errorLabels != null && errorLabels.isArray()) {
            return errorLabels.asArray();
        }
        return new BsonArray();
    }

    @Override
    public void close() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
            this.mongoClient = null;
        }
        if (this.dataConnection != null) {
            this.dataConnection.release();
            this.dataConnection = null;
        }
    }

    public void assembleSupplier(NodeEngineImpl nodeEngine) {
        if (this.dataConnectionRef != null) {
            this.dataConnection = (MongoDataConnection)nodeEngine.getDataConnectionService().getAndRetainDataConnection(this.dataConnectionRef.getName(), MongoDataConnection.class);
            this.clientSupplier = this.dataConnection::getClient;
        }
    }
}

