/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.jet.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.security.permission.ConnectorPermission;
import com.hazelcast.vector.VectorValues;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.file.Path;
import java.security.Permission;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public final class VectorFiles {
    private VectorFiles() {
    }

    public static FunctionEx<? super Path, ? extends Stream<Map.Entry<Integer, VectorValues>>> fvecsFileFn(final String directory) {
        return new FunctionEx<Path, Stream<Map.Entry<Integer, VectorValues>>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Stream<Map.Entry<Integer, VectorValues>> applyEx(Path path) throws Exception {
                return VectorFiles.mapSequenceFrom(path, VectorFiles::getFloats);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.file(directory, "read"));
            }
        };
    }

    public static FunctionEx<? super Path, ? extends Stream<Map.Entry<Integer, int[]>>> ivecsFileFn(final String directory) {
        return new FunctionEx<Path, Stream<Map.Entry<Integer, int[]>>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Stream<Map.Entry<Integer, int[]>> applyEx(Path path) throws Exception {
                return VectorFiles.mapSequenceFrom(path, VectorFiles::getInts);
            }

            @Override
            public List<Permission> permissions() {
                return Collections.singletonList(ConnectorPermission.file(directory, "read"));
            }
        };
    }

    @Nonnull
    public static <V> Stream<Map.Entry<Integer, V>> mapSequenceFrom(Path path, FunctionEx<DataInputStream, V> itemReader) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(path.toFile())));
        Spliterator<Map.Entry<Integer, V>> spliterator = Spliterators.spliteratorUnknownSize(VectorFiles.mapSequenceFrom(dis, itemReader), 272);
        return StreamSupport.stream(spliterator, false);
    }

    public static <V> Iterator<Map.Entry<Integer, V>> mapSequenceFrom(final DataInputStream dis, final FunctionEx<DataInputStream, V> itemReader) {
        return new Iterator<Map.Entry<Integer, V>>(){
            private boolean closed;
            private int index;

            @Override
            public boolean hasNext() {
                try {
                    if (!this.closed && dis.available() > 0) {
                        return true;
                    }
                    dis.close();
                    this.closed = true;
                    return false;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Map.Entry<Integer, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Map.entry(this.index++, itemReader.apply(dis));
            }
        };
    }

    public static VectorValues getFloats(DataInputStream dis) throws IOException {
        int dimension = Integer.reverseBytes(dis.readInt());
        assert (dimension > 0) : dimension;
        byte[] buffer = new byte[dimension * 4];
        dis.readFully(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN);
        float[] vector = new float[dimension];
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.get(vector);
        return VectorValues.of(vector);
    }

    public static int[] getInts(DataInputStream dis) throws IOException {
        int numNeighbors = Integer.reverseBytes(dis.readInt());
        int[] neighbors = new int[numNeighbors];
        for (int i = 0; i < numNeighbors; ++i) {
            int neighbor;
            neighbors[i] = neighbor = Integer.reverseBytes(dis.readInt());
        }
        return neighbors;
    }
}

