/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.jet;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.vector.VectorCollection;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.jet.impl.WriteVectorCollectionP;
import javax.annotation.Nonnull;

@Beta
public final class VectorSinks {
    private VectorSinks() {
    }

    @Nonnull
    public static <T, K, V> Sink<T> vectorCollection(@Nonnull VectorCollection<K, V> collection, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull FunctionEx<? super T, VectorValues> toVectorsFn) {
        return VectorSinks.vectorCollection(collection.getName(), toKeyFn, toValueFn, toVectorsFn);
    }

    @Nonnull
    public static <T, K, V> Sink<T> vectorCollection(@Nonnull VectorCollection<K, V> collection, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, VectorDocument<? extends V>> toDocumentFn) {
        return VectorSinks.vectorCollection(collection.getName(), toKeyFn, toDocumentFn);
    }

    @Nonnull
    public static <T, K, V> Sink<T> vectorCollection(@Nonnull String collectionName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, ? extends V> toValueFn, @Nonnull FunctionEx<? super T, VectorValues> toVectorsFn) {
        return VectorSinks.vectorCollection(collectionName, toKeyFn, (? super T item) -> VectorDocument.of(toValueFn.apply(item), (VectorValues)toVectorsFn.apply(item)));
    }

    @Nonnull
    public static <T, K, V> Sink<T> vectorCollection(@Nonnull String collectionName, @Nonnull FunctionEx<? super T, ? extends K> toKeyFn, @Nonnull FunctionEx<? super T, VectorDocument<? extends V>> toDocumentFn) {
        return Sinks.fromProcessor("vectorCollectionSink(" + collectionName + ")", ProcessorMetaSupplier.preferLocalParallelismOne(WriteVectorCollectionP.vectorCollectionPutPermission(collectionName), new WriteVectorCollectionP.Supplier<T, K, V>(collectionName, toKeyFn, toDocumentFn)), toKeyFn);
    }
}

