/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.vector.impl.storage.VectorKeysEntry;
import com.hazelcast.vector.impl.storage.VectorMultiKeysEntry;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class VectorOneKeyEntry
implements VectorKeysEntry {
    private volatile Data key;

    public VectorOneKeyEntry(@Nonnull Data key) {
        this.key = key;
    }

    @Override
    public VectorKeysEntry addKey(@Nonnull Data key) {
        if (this.key != null) {
            return VectorMultiKeysEntry.create().addKey(this.key).addKey(key);
        }
        this.key = key;
        return this;
    }

    @Override
    public void deleteKey(@Nonnull Data key) {
        if (key.equals(this.key)) {
            this.key = null;
        }
    }

    @Override
    public boolean isEmptyKeys() {
        return this.key == null;
    }

    @Override
    public int forEachKeyWithLimit(int limit, Consumer<Data> action) {
        Data aKey;
        if (limit == 0 || (aKey = this.key) == null) {
            return 0;
        }
        action.accept(aKey);
        return 1;
    }
}

