/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.config.vector.Metric;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.SearchResult;
import com.hazelcast.shaded.org.jctools.maps.NonBlockingHashMapLong;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.impl.DataSearchResult;
import com.hazelcast.vector.impl.SearchResultsImpl;
import com.hazelcast.vector.impl.storage.AbstractVectorIndex;
import com.hazelcast.vector.impl.storage.ConcurrentModificationPolicy;
import com.hazelcast.vector.impl.storage.ReplicationStateHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class VectorIndexSingleKey
extends AbstractVectorIndex {
    static final long FIXED_HEAP_BYTES_USED = 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES;
    static final long HEAP_BYTES_USED_PER_ENTRY = 8L + 2L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + (long)JVMUtil.OBJECT_HEADER_SIZE + 4L;
    private final NonBlockingHashMapLong<Data> nodeIdToKeyMap = new NonBlockingHashMapLong(1024);
    private Map<Data, Integer> keyToNodeIdMap = new HashMap<Data, Integer>(1024);

    public VectorIndexSingleKey(String indexName, Metric metric, int maxDegree, int efConstruction, int dimensions) {
        super(indexName, metric, maxDegree, efConstruction, dimensions);
    }

    @Override
    protected Integer putInternal(Data key, float[] vector) {
        int nodeId = this.idGenerator.incrementAndGet();
        Integer previousNodeId = this.keyToNodeIdMap.put(key, nodeId);
        if (previousNodeId != null) {
            this.deleteNode(previousNodeId);
        }
        this.nodeIdToKeyMap.put(nodeId, key);
        this.vectorsSupplier.add(nodeId, vector);
        this.indexBuilder.addGraphNode(nodeId, this.vectorsSupplier);
        return previousNodeId;
    }

    @Override
    protected SearchResults<Data, Data> toDataSearchResults(SearchResult searchResult, int limit, ConcurrentModificationPolicy cmPolicy) {
        ArrayList resultsList = new ArrayList();
        for (SearchResult.NodeScore nodeScore : searchResult.getNodes()) {
            Data keyData = this.nodeIdToKeyMap.get(nodeScore.node);
            if (keyData != null) {
                resultsList.add(new DataSearchResult(nodeScore.node, keyData, nodeScore.score));
                continue;
            }
            cmPolicy.action();
        }
        return new SearchResultsImpl<Data, Data>(resultsList);
    }

    @Override
    protected Integer getNodeIdByKey(Data key) {
        return this.keyToNodeIdMap.get(key);
    }

    @Override
    protected boolean hasLiveNodes() {
        return !this.nodeIdToKeyMap.isEmpty();
    }

    @Override
    protected boolean deleteInternal(Data key) {
        Integer node = this.keyToNodeIdMap.remove(key);
        if (node == null) {
            return false;
        }
        this.deleteNode(node);
        return true;
    }

    private void deleteNode(int nodeId) {
        this.indexBuilder.markNodeDeleted(nodeId);
        this.nodeIdToKeyMap.remove(nodeId);
        this.maybeRecreateIndex();
    }

    @Override
    public long heapBytesUsed() {
        long heapBytesUsed = FIXED_HEAP_BYTES_USED + super.heapBytesUsed();
        return heapBytesUsed + (long)this.nodeIdToKeyMap.size() * HEAP_BYTES_USED_PER_ENTRY;
    }

    @Override
    void writeKeyToNodeIdMapping(ObjectDataOutput out, Data key) throws IOException {
        out.writeInt(this.keyToNodeIdMap.get(key));
    }

    @Override
    void resetState(ReplicationStateHolder.CollectionReplicationStateHolder.IndexReplicationStateHolder indexState) {
        super.resetState(indexState);
        assert (this.keyToNodeIdMap.isEmpty()) : "Migration to non empty index";
        this.keyToNodeIdMap = indexState.keyToNodeIdMap;
        assert (this.nodeIdToKeyMap.isEmpty()) : "Migration to non empty index";
        this.keyToNodeIdMap.forEach((key, nodeId) -> this.nodeIdToKeyMap.put(nodeId.intValue(), (Data)key));
    }
}

