/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.config.vector.VectorIndexConfig;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import com.hazelcast.vector.VectorCollectionService;
import com.hazelcast.vector.impl.storage.AbstractVectorIndex;
import com.hazelcast.vector.impl.storage.UpdatableVectorsSource;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import com.hazelcast.vector.impl.storage.VectorIndexFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReplicationStateHolder
implements IdentifiedDataSerializable {
    private transient Map<String, VectorCollectionStorage> storageMap;
    private transient Map<String, CollectionReplicationStateHolder> dataMap;

    public ReplicationStateHolder() {
    }

    public ReplicationStateHolder(Map<String, VectorCollectionStorage> vcStorageMap) {
        this.storageMap = vcStorageMap;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        SerializationUtil.writeMapStringKey(this.storageMap, out, ReplicationStateHolder::writeVectorCollectionStorage);
    }

    private static void writeVectorCollectionStorage(ObjectDataOutput out, VectorCollectionStorage storage) throws IOException {
        out.writeObject(storage.getConfig());
        out.writeInt(storage.getRecordStore().size());
        int indexCount = storage.getVectorIndexes().getSize();
        ArrayList indexOrdinals = new ArrayList(indexCount);
        storage.getVectorIndexes().forEachIndex(indexOrdinals::add);
        out.writeInt(indexCount);
        for (AbstractVectorIndex index : indexOrdinals) {
            out.writeString(index.indexName);
            ReplicationStateHolder.writeIndex(out, index);
        }
        Iterator<Map.Entry<Data, Record<Data>>> entryIt = storage.getRecordStore().mutationTolerantIterator();
        while (entryIt.hasNext()) {
            Map.Entry<Data, Record<Data>> entry = entryIt.next();
            IOUtil.writeData(out, entry.getKey());
            IOUtil.writeData(out, entry.getValue().getValue());
            for (AbstractVectorIndex ordinal : indexOrdinals) {
                ReplicationStateHolder.writeIndexEntry(out, ordinal, entry.getKey());
            }
        }
    }

    private static void writeIndexEntry(ObjectDataOutput out, AbstractVectorIndex index, Data key) throws IOException {
        index.writeKeyToNodeIdMapping(out, key);
    }

    private static void writeIndex(ObjectDataOutput out, AbstractVectorIndex index) throws IOException {
        out.writeInt(index.idGenerator.get());
        index.vectorsSupplier.writeData(out);
        index.indexBuilder.getGraph().save(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.dataMap = SerializationUtil.readMapStringKey(in, i -> {
            CollectionReplicationStateHolder collectionState = new CollectionReplicationStateHolder();
            collectionState.readData((ObjectDataInput)i);
            return collectionState;
        });
    }

    public void apply(VectorCollectionService service, int partitionId) {
        for (Map.Entry<String, CollectionReplicationStateHolder> collectionState : this.dataMap.entrySet()) {
            VectorCollectionStorage storage = service.createStorage(collectionState.getKey(), partitionId);
            storage.resetState(collectionState.getValue());
            service.attachStorage(storage);
        }
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 27;
    }

    public Map<String, VectorCollectionStorage> getStorageMap() {
        return Collections.unmodifiableMap(this.storageMap);
    }

    static class CollectionReplicationStateHolder {
        VectorCollectionConfig config;
        Map<Data, Data> entries;
        List<IndexReplicationStateHolder> indexes;
        private int entryCount;

        CollectionReplicationStateHolder() {
        }

        private void readData(ObjectDataInput in) throws IOException {
            int j;
            this.config = (VectorCollectionConfig)in.readObject();
            this.entryCount = in.readInt();
            int indexCount = in.readInt();
            this.indexes = new ArrayList<IndexReplicationStateHolder>(indexCount);
            for (j = 0; j < indexCount; ++j) {
                String name = in.readString();
                VectorIndexConfig indexConfig = this.config.getVectorIndexConfigs().stream().filter(ic -> Objects.equals(ic.getName(), name)).findFirst().orElseThrow();
                IndexReplicationStateHolder indexState = new IndexReplicationStateHolder(indexConfig);
                indexState.readData(in);
                this.indexes.add(indexState);
            }
            this.entries = new HashMap<Data, Data>(this.entryCount);
            for (j = 0; j < this.entryCount; ++j) {
                Data key = IOUtil.readData(in);
                Data value = IOUtil.readData(in);
                this.entries.put(key, value);
                for (IndexReplicationStateHolder index : this.indexes) {
                    index.readIndexEntry(in, key);
                }
            }
        }

        class IndexReplicationStateHolder {
            VectorIndexConfig indexConfig;
            int idGeneratorState;
            AbstractVectorIndex index;
            UpdatableVectorsSource vectorsSupplier;
            Map<Data, Integer> keyToNodeIdMap;

            IndexReplicationStateHolder(VectorIndexConfig indexConfig) {
                this.indexConfig = indexConfig;
            }

            private void readData(ObjectDataInput in) throws IOException {
                this.index = VectorIndexFactory.create(this.indexConfig);
                this.vectorsSupplier = this.index.vectorsSupplier;
                this.idGeneratorState = in.readInt();
                this.vectorsSupplier.readData(in);
                this.keyToNodeIdMap = new HashMap<Data, Integer>(CollectionReplicationStateHolder.this.entryCount);
                this.index.indexBuilder.load(new RandomAccessReaderAdapter(in));
            }

            private void readIndexEntry(ObjectDataInput in, Data key) throws IOException {
                int nodeId = in.readInt();
                this.keyToNodeIdMap.put(key, nodeId);
            }

            String getName() {
                return this.indexConfig.getName();
            }
        }
    }

    static class RandomAccessReaderAdapter
    implements RandomAccessReader {
        private final ObjectDataInput in;

        RandomAccessReaderAdapter(ObjectDataInput in) {
            this.in = in;
        }

        @Override
        public void seek(long l) throws IOException {
            throw new UnsupportedOperationException("only used with the on-disk graph index");
        }

        @Override
        public int readInt() throws IOException {
            return this.in.readInt();
        }

        @Override
        public void readFully(byte[] bytes) throws IOException {
            this.in.readFully(bytes);
        }

        @Override
        public void readFully(float[] floats) throws IOException {
            throw new UnsupportedOperationException("only used with on-disk graph and quantization");
        }

        @Override
        public void readFully(long[] longs) throws IOException {
            throw new UnsupportedOperationException("only used with binary quantization vectors");
        }

        @Override
        public void read(int[] ints, int offset, int count) throws IOException {
            throw new UnsupportedOperationException("only used with on-disk graph");
        }

        @Override
        public void close() throws IOException {
        }
    }
}

