/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.config.vector.Metric;
import com.hazelcast.internal.memory.Measurable;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.shaded.io.github.jbellis.jvector.annotations.VisibleForTesting;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.GraphIndex;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.GraphIndexBuilder;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.GraphSearcher;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.HazelcastGraphIndexView;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodeSimilarity;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.SearchResult;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.BitSet;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.Bits;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorEncoding;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.vector.IndexMutationDisallowedException;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.impl.storage.ConcurrentModificationPolicy;
import com.hazelcast.vector.impl.storage.ReplicationStateHolder;
import com.hazelcast.vector.impl.storage.UpdatableVectorsSource;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public abstract class AbstractVectorIndex
implements Measurable {
    static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + 6L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + (long)JVMUtil.OBJECT_HEADER_SIZE + 16L;
    protected final AtomicInteger idGenerator;
    volatile UpdatableVectorsSource vectorsSupplier;
    @VisibleForTesting
    GraphIndexBuilder<float[]> indexBuilder;
    final String indexName;
    private final int maxDegree;
    private final int efConstruction;
    private final int dimensions;
    private final VectorSimilarityFunction similarityFunction;
    private volatile SearcherPool searcherPool;
    private final AtomicReference<InternalCompletableFuture<Void>> indexOptimizationFuture = new AtomicReference();

    AbstractVectorIndex(String indexName, Metric metric, int maxDegree, int efConstruction, int dimensions) {
        this.indexName = indexName;
        this.maxDegree = maxDegree;
        this.efConstruction = efConstruction;
        this.dimensions = dimensions;
        this.similarityFunction = this.asVectorSimilarityFunction(metric);
        this.idGenerator = new AtomicInteger();
        this.vectorsSupplier = new UpdatableVectorsSource(dimensions);
        this.indexBuilder = this.createIndexBuilder(this.vectorsSupplier);
        this.searcherPool = this.createSearcherPool(this.indexBuilder);
    }

    protected GraphIndexBuilder<float[]> createIndexBuilder(UpdatableVectorsSource vectorsSource) {
        return new GraphIndexBuilder<float[]>(vectorsSource, VectorEncoding.FLOAT32, this.similarityFunction, this.maxDegree, this.efConstruction, 1.2f, 1.4f);
    }

    private SearcherPool createSearcherPool(GraphIndexBuilder<float[]> indexBuilder) {
        return new SearcherPool(HazelcastGraphIndexView.create(indexBuilder.getGraph()));
    }

    private VectorSimilarityFunction asVectorSimilarityFunction(Metric m) {
        return switch (m) {
            default -> throw new IncompatibleClassChangeError();
            case Metric.DOT -> VectorSimilarityFunction.DOT_PRODUCT;
            case Metric.COSINE -> VectorSimilarityFunction.COSINE;
            case Metric.EUCLIDEAN -> VectorSimilarityFunction.EUCLIDEAN;
        };
    }

    public float[] put(Data key, float[] vector, boolean returnPrevious) {
        this.checkMutatingOperationAllowed();
        this.validateVector(vector);
        UpdatableVectorsSource originalVectorSupplier = this.vectorsSupplier;
        Integer previousVectorId = this.putInternal(key, vector);
        if (returnPrevious && previousVectorId != null) {
            return originalVectorSupplier.vectorValue(previousVectorId);
        }
        return null;
    }

    public void put(Data key, float[] vector) {
        this.checkMutatingOperationAllowed();
        this.validateVector(vector);
        this.putInternal(key, vector);
    }

    public float[] get(Data key) {
        Integer nodeId = this.getNodeIdByKey(key);
        if (nodeId == null) {
            throw new IllegalStateException("The entry with the requested key does not exist.");
        }
        return this.vectorsSupplier.vectorValue(nodeId);
    }

    public boolean delete(Data key) {
        this.checkMutatingOperationAllowed();
        return this.deleteInternal(key);
    }

    public void cleanup() {
        InternalCompletableFuture<Void> optimizationFuture = this.indexOptimizationFuture.get();
        if (optimizationFuture == null) {
            throw new IllegalStateException("The index must be locked for mutation before the optimization process begins.");
        }
        if (optimizationFuture.isDone()) {
            throw new IllegalStateException("Optimization already done, lock is not reusable");
        }
        try {
            ArrayList<Integer> candidateToBeRemoved = new ArrayList<Integer>();
            BitSet deletedNodes = this.getRemovedNodes();
            int i = deletedNodes.nextSetBit(0);
            while (i != Integer.MAX_VALUE) {
                candidateToBeRemoved.add(i);
                i = deletedNodes.nextSetBit(i + 1);
            }
            this.indexBuilder.cleanup();
            candidateToBeRemoved.forEach(this.vectorsSupplier::remove);
            optimizationFuture.complete(null);
        }
        catch (Exception e) {
            optimizationFuture.completeExceptionally(e);
        }
    }

    public SearchResults<Data, Data> search(float[] vector, int topK) {
        return this.search(vector, topK, ConcurrentModificationPolicy.THROW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResults<Data, Data> search(float[] vector, int topK, ConcurrentModificationPolicy cmPolicy) {
        SearchResult searchResult;
        if (topK <= 0) {
            throw new IllegalArgumentException("topK must be > 0");
        }
        NodeSimilarity.ExactScoreFunction scoreFunction = node2 -> {
            float[] vector2 = this.vectorsSupplier.vectorValue(node2);
            if (vector2 == null) {
                cmPolicy.action();
                return Float.NEGATIVE_INFINITY;
            }
            return this.similarityFunction.compare(vector, vector2);
        };
        SearcherPool searcherPoolRef = this.searcherPool;
        GraphSearcher<float[]> searcher = searcherPoolRef.acquire();
        try {
            searchResult = searcher.search(scoreFunction, null, topK, Bits.ALL);
        }
        finally {
            searcherPoolRef.release(searcher);
        }
        return this.toDataSearchResults(searchResult, topK, cmPolicy);
    }

    public void lockIndexMutation() {
        if (!this.indexOptimizationFuture.compareAndSet(null, new InternalCompletableFuture())) {
            throw new IndexMutationDisallowedException("Index optimization process is in progress.");
        }
    }

    public void unlockIndexMutation() {
        InternalCompletableFuture<Void> currentFuture = this.indexOptimizationFuture.get();
        if (currentFuture == null || !this.indexOptimizationFuture.compareAndSet(currentFuture, null)) {
            throw new IllegalStateException("Failed to unlock a collection that was not locked.");
        }
    }

    public void checkMutatingOperationAllowed() {
        if (this.indexOptimizationFuture.get() != null) {
            throw new IndexMutationDisallowedException("Index optimization process is in progress.");
        }
    }

    protected BitSet getRemovedNodes() {
        return this.indexBuilder.getGraph().getDeletedNodes();
    }

    protected abstract boolean deleteInternal(Data var1);

    protected abstract Integer putInternal(Data var1, float[] var2);

    protected abstract SearchResults<Data, Data> toDataSearchResults(SearchResult var1, int var2, ConcurrentModificationPolicy var3);

    protected abstract Integer getNodeIdByKey(Data var1);

    protected abstract boolean hasLiveNodes();

    protected void maybeRecreateIndex() {
        if (!this.hasLiveNodes()) {
            UpdatableVectorsSource updatableVectorsSource = new UpdatableVectorsSource(this.dimensions);
            this.indexBuilder = this.createIndexBuilder(updatableVectorsSource);
            this.searcherPool = this.createSearcherPool(this.indexBuilder);
            this.vectorsSupplier = updatableVectorsSource;
        }
    }

    private void validateVector(float[] vector) {
        if (vector.length != this.dimensions) {
            throw new IllegalArgumentException("Vector length " + vector.length + " different than expected for index " + this.indexName);
        }
    }

    @Override
    public long heapBytesUsed() {
        return FIXED_HEAP_BYTES_USED + this.vectorsSupplier.heapBytesUsed() + this.indexBuilder.getGraph().ramBytesUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareForMigration(VectorCollectionStorage vectorCollectionStorage, NodeEngine nodeEngine) {
        assert (!ThreadUtil.isRunningOnPartitionThread()) : "Preparation should be offloaded";
        assert (nodeEngine.getPartitionService().getPartition(vectorCollectionStorage.getPartitionId()).isMigrating()) : "Partition should be marked as migrating";
        InternalCompletableFuture<Void> optimizeFuture = this.indexOptimizationFuture.get();
        if (optimizeFuture != null) {
            ILogger logger = nodeEngine.getLogger(AbstractVectorIndex.class);
            logger.info("Index optimization in progress, waiting for completion before continuing migration");
            optimizeFuture.joinInternal();
        }
        this.lockIndexMutation();
        try {
            this.cleanup();
        }
        finally {
            this.unlockIndexMutation();
        }
    }

    abstract void writeKeyToNodeIdMapping(ObjectDataOutput var1, Data var2) throws IOException;

    void resetState(ReplicationStateHolder.CollectionReplicationStateHolder.IndexReplicationStateHolder indexState) {
        this.checkMutatingOperationAllowed();
        this.idGenerator.set(indexState.idGeneratorState);
        this.indexBuilder = indexState.index.indexBuilder;
        this.searcherPool = this.createSearcherPool(this.indexBuilder);
        this.vectorsSupplier = indexState.vectorsSupplier;
    }

    private static class SearcherPool {
        private final AtomicReference<GraphSearcher<float[]>> pool;
        private final Supplier<GraphSearcher<float[]>> graphSearcherSupplier = () -> new GraphSearcher.Builder(view).withConcurrentUpdates().build();

        SearcherPool(GraphIndex.View<float[]> view) {
            this.pool = new AtomicReference<GraphSearcher<float[]>>(this.graphSearcherSupplier.get());
        }

        public GraphSearcher<float[]> acquire() {
            GraphSearcher<float[]> pooledSearcher = this.pool.getAndSet(null);
            return pooledSearcher != null ? pooledSearcher : this.graphSearcherSupplier.get();
        }

        public void release(GraphSearcher<float[]> searcher) {
            this.pool.compareAndSet(null, searcher);
        }
    }
}

