/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.impl.operationservice.SelfResponseOperation;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.VectorCollectionService;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.Hints;
import com.hazelcast.vector.impl.ops.SearchMemberResult;
import com.hazelcast.vector.impl.query.QueryResult;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class SearchMemberOperation
extends AbstractNamedOperation
implements IdentifiedDataSerializable,
ReadonlyOperation,
SelfResponseOperation {
    private VectorValues vectors;
    private SearchOptions searchOptions;
    private PartitionIdSet requestedPartitions;
    private transient ManagedExecutorService executor;
    private transient AtomicInteger finishedCounter;
    private transient QueryResult partitionResults;

    public SearchMemberOperation() {
    }

    public SearchMemberOperation(String vectorCollectionName, VectorValues vectors, SearchOptions searchOptions, PartitionIdSet requestedPartitions) {
        super(vectorCollectionName);
        this.vectors = vectors;
        this.searchOptions = searchOptions;
        this.requestedPartitions = requestedPartitions;
    }

    private void submitSearch(int partitionId) {
        VectorCollectionService service = (VectorCollectionService)this.getService();
        VectorCollectionStorage maybeStorage = service.getStorageOrNull(this.getName(), partitionId);
        if (maybeStorage == null) {
            this.getLogger().fine("No longer owner of partition %d or partition is empty", partitionId);
            this.partitionDone(false);
            return;
        }
        this.executor.execute(() -> {
            try {
                this.partitionResults.addResult(partitionId, maybeStorage.search(this.vectors, this.searchOptions));
            }
            catch (Throwable e) {
                this.getLogger().warning("Search failed on partition " + partitionId, e);
            }
            finally {
                this.partitionDone(Thread.currentThread().isInterrupted());
            }
        });
    }

    private void partitionDone(boolean interrupted) {
        if (interrupted) {
            this.getLogger().info("Search finished after member termination, ignoring result");
        } else if (this.finishedCounter.decrementAndGet() == 0) {
            SearchMemberResult response = new SearchMemberResult(this.partitionResults.complete(), this.partitionResults.getSourceIds());
            this.sendResponse(response);
        }
    }

    @Override
    public CallStatus call() throws Exception {
        this.executor = this.getNodeEngine().getExecutionService().getExecutor("hz:query");
        this.finishedCounter = new AtomicInteger(this.requestedPartitions.size());
        int limit = this.getMemberLimit(this.searchOptions);
        this.partitionResults = new QueryResult(this.getNodeEngine().getPartitionService().getPartitionCount(), this.requestedPartitions.size(), limit);
        return new Offload(this){

            @Override
            public void start() {
                SearchMemberOperation.this.requestedPartitions.intIterator().forEachRemaining(SearchMemberOperation.this::submitSearch);
            }
        };
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    private int getMemberLimit(SearchOptions searchOptions) {
        int resultLimit = searchOptions.getLimit();
        Integer maybeMemberLimit = Hints.MEMBER_LIMIT.get(searchOptions);
        if (maybeMemberLimit == null) {
            return resultLimit;
        }
        if (maybeMemberLimit < 0) {
            this.getLogger().warning("Member limit cannot be negative - ignored");
            return resultLimit;
        }
        if (maybeMemberLimit > resultLimit) {
            this.getLogger().warning("Number of neighbours requested from member is greater than requested result size - ignored");
            return resultLimit;
        }
        if (maybeMemberLimit * this.getNodeEngine().getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR) < resultLimit) {
            this.getLogger().warning("Number of neighbours requested from member is not sufficient to generate full requested result");
        }
        return maybeMemberLimit;
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:service:vector";
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.vectors);
        out.writeObject(this.searchOptions);
        out.writeObject(this.requestedPartitions);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.vectors = (VectorValues)in.readObject();
        this.searchOptions = (SearchOptions)in.readObject();
        this.requestedPartitions = (PartitionIdSet)in.readObject();
    }
}

