/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.vector;

import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorUtilSupport;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.VectorizationProvider;
import java.util.Arrays;
import java.util.List;

public final class VectorUtil {
    private static final VectorUtilSupport impl = VectorizationProvider.getInstance().getVectorUtilSupport();

    private VectorUtil() {
    }

    public static float dotProduct(float[] a2, float[] b) {
        if (a2.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a2.length + "!=" + b.length);
        }
        float r = impl.dotProduct(a2, b);
        assert (Float.isFinite(r));
        return r;
    }

    public static float dotProduct(float[] a2, int aoffset, float[] b, int boffset, int length) {
        float r = impl.dotProduct(a2, aoffset, b, boffset, length);
        assert (Float.isFinite(r)) : String.format("dotProduct(%s, %s) = %s", Arrays.toString(a2), Arrays.toString(b), Float.valueOf(r));
        return r;
    }

    public static float cosine(float[] a2, float[] b) {
        if (a2.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a2.length + "!=" + b.length);
        }
        float r = impl.cosine(a2, b);
        assert (Float.isFinite(r)) : String.format("cosine(%s, %s) = %s", Arrays.toString(a2), Arrays.toString(b), Float.valueOf(r));
        return r;
    }

    public static float cosine(byte[] a2, byte[] b) {
        if (a2.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a2.length + "!=" + b.length);
        }
        return impl.cosine(a2, b);
    }

    public static float squareDistance(float[] a2, float[] b) {
        if (a2.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a2.length + "!=" + b.length);
        }
        float r = impl.squareDistance(a2, b);
        assert (Float.isFinite(r)) : String.format("squareDistance(%s, %s) = %s", Arrays.toString(a2), Arrays.toString(b), Float.valueOf(r));
        return r;
    }

    public static float squareDistance(float[] a2, int aoffset, float[] b, int boffset, int length) {
        float r = impl.squareDistance(a2, aoffset, b, boffset, length);
        assert (Float.isFinite(r));
        return r;
    }

    public static int squareDistance(byte[] a2, byte[] b) {
        if (a2.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a2.length + "!=" + b.length);
        }
        return impl.squareDistance(a2, b);
    }

    public static float[] l2normalize(float[] v) {
        VectorUtil.l2normalize(v, true);
        return v;
    }

    public static float[] l2normalize(float[] v, boolean throwOnZero) {
        double squareSum = 0.0;
        int dim = v.length;
        for (float x : v) {
            squareSum += (double)(x * x);
        }
        if (squareSum == 0.0) {
            if (throwOnZero) {
                throw new IllegalArgumentException("Cannot normalize a zero-length vector");
            }
            return v;
        }
        double length = Math.sqrt(squareSum);
        int i = 0;
        while (i < dim) {
            int n = i++;
            v[n] = (float)((double)v[n] / length);
        }
        return v;
    }

    public static void add(float[] u, float[] v) {
        for (int i = 0; i < u.length; ++i) {
            int n = i;
            u[n] = u[n] + v[i];
        }
    }

    public static int dotProduct(byte[] a2, byte[] b) {
        if (a2.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a2.length + "!=" + b.length);
        }
        return impl.dotProduct(a2, b);
    }

    public static float dotProductScore(byte[] a2, byte[] b) {
        float denom = a2.length * 32768;
        return 0.5f + (float)VectorUtil.dotProduct(a2, b) / denom;
    }

    public static float[] checkFinite(float[] v) {
        for (int i = 0; i < v.length; ++i) {
            if (Float.isFinite(v[i])) continue;
            throw new IllegalArgumentException("non-finite value at vector[" + i + "]=" + v[i]);
        }
        return v;
    }

    public static float[] sum(List<float[]> vectors) {
        if (vectors.isEmpty()) {
            throw new IllegalArgumentException("Input list cannot be empty");
        }
        return impl.sum(vectors);
    }

    public static float sum(float[] vector) {
        return impl.sum(vector);
    }

    public static void divInPlace(float[] vector, float divisor) {
        impl.divInPlace(vector, divisor);
    }

    public static void addInPlace(float[] v1, float[] v2) {
        impl.addInPlace(v1, v2);
    }

    public static void subInPlace(float[] v1, float[] v2) {
        impl.subInPlace(v1, v2);
    }

    public static float[] sub(float[] lhs, float[] rhs) {
        return impl.sub(lhs, rhs);
    }

    public static float assembleAndSum(float[] data, int dataBase, byte[] dataOffsets) {
        return impl.assembleAndSum(data, dataBase, dataOffsets);
    }

    public static int hammingDistance(long[] v1, long[] v2) {
        return impl.hammingDistance(v1, v2);
    }
}

