/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.elastic.tree.ComparableComparator;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.query.impl.HDIndexBinaryElasticNestedTreeMap;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Set;

class HDIndexNestedTreeMap<T extends QueryableEntry> {
    private final HDIndexBinaryElasticNestedTreeMap<T> recordMap;
    private final EnterpriseSerializationService ess;

    HDIndexNestedTreeMap(EnterpriseSerializationService ess, MemoryAllocator malloc, MapEntryFactory<T> entryFactory) {
        this.ess = ess;
        this.recordMap = new HDIndexBinaryElasticNestedTreeMap(ess, malloc, new ComparableComparator(ess), entryFactory);
    }

    public MemoryBlock put(Comparable attribute, NativeMemoryData key, MemoryBlock value) {
        Object attributeData = this.ess.toData((Object)attribute, DataType.HEAP);
        return this.recordMap.put((Data)attributeData, key, value);
    }

    public MemoryBlock remove(Comparable attribute, NativeMemoryData key) {
        return this.recordMap.remove((Data)this.ess.toData((Object)attribute, DataType.HEAP), key);
    }

    public Set<T> subMap(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive) {
        Object fromData = this.ess.toData((Object)from, DataType.HEAP);
        Object toData = this.ess.toData((Object)to, DataType.HEAP);
        return this.recordMap.subMap((Data)fromData, fromInclusive, (Data)toData, toInclusive);
    }

    public Set<T> headMap(Comparable toValue, boolean inclusive) {
        Object toValueData = this.ess.toData((Object)toValue, DataType.HEAP);
        return this.recordMap.headMap((Data)toValueData, inclusive);
    }

    public Set<T> tailMap(Comparable fromValue, boolean inclusive) {
        Object fromValueData = this.ess.toData((Object)fromValue, DataType.HEAP);
        return this.recordMap.tailMap((Data)fromValueData, inclusive);
    }

    public Set<T> get(Comparable searchedValue) {
        Object searchedValueData = this.ess.toData((Object)searchedValue, DataType.HEAP);
        return this.recordMap.get((Data)searchedValueData);
    }

    public long size() {
        return this.recordMap.size();
    }

    public void clear() {
        this.recordMap.clear();
    }

    public void dispose() {
        this.recordMap.dispose();
    }
}

