/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.impl.ByteArrayAccessStrategy;
import com.hazelcast.internal.memory.impl.EndiannessUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.TimeStripUtil;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.map.impl.record.DataRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;

public final class TieredStoreRecordWithStats
extends TieredStoreRecord {
    public TieredStoreRecordWithStats(TieredStoreRecordAccessor recordAccessor) {
        super(GlobalMemoryAccessorRegistry.AMEM, recordAccessor);
    }

    @Override
    public int getMetadataSize() {
        return 28;
    }

    int getVersionOffset() {
        return this.getMetadataOffset();
    }

    int getCreationTimeOffset() {
        return this.getMetadataOffset() + 4;
    }

    int getLastAccessTimeOffset() {
        return this.getMetadataOffset() + 8;
    }

    int getLastUpdateTimeOffset() {
        return this.getMetadataOffset() + 12;
    }

    int getHitsOffset() {
        return this.getMetadataOffset() + 16;
    }

    int getLastStoredTimeOffset() {
        return this.getMetadataOffset() + 20;
    }

    int getSequenceOffset() {
        return this.getMetadataOffset() + 24;
    }

    @Override
    public long getSequence() {
        return this.readInt(this.getSequenceOffset());
    }

    @Override
    public void setSequence(long sequence) {
        this.assertMutable();
        this.writeInt(this.getSequenceOffset(), (int)sequence);
    }

    @Override
    public int getVersion() {
        return this.readInt(this.getVersionOffset());
    }

    @Override
    public void setVersion(int version) {
        this.assertMutable();
        this.writeInt(this.getVersionOffset(), version);
    }

    @Override
    public long getCreationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(this.getCreationTimeOffset()));
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.assertMutable();
        this.writeInt(this.getCreationTimeOffset(), TimeStripUtil.stripBaseTime(creationTime));
    }

    @Override
    public long getLastAccessTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(this.getLastAccessTimeOffset()));
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.assertMutable();
        this.writeInt(this.getLastAccessTimeOffset(), TimeStripUtil.stripBaseTime(lastAccessTime));
    }

    @Override
    public long getLastUpdateTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(this.getLastUpdateTimeOffset()));
    }

    @Override
    public void setLastUpdateTime(long lastUpdatedTime) {
        this.assertMutable();
        this.writeInt(this.getLastUpdateTimeOffset(), TimeStripUtil.stripBaseTime(lastUpdatedTime));
    }

    @Override
    public int getHits() {
        return this.readInt(this.getHitsOffset());
    }

    @Override
    public void setHits(int hits) {
        this.assertMutable();
        this.writeInt(this.getHitsOffset(), hits);
    }

    @Override
    public long getLastStoredTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(this.getLastStoredTimeOffset()));
    }

    @Override
    public void setLastStoredTime(long lastStoredTime) {
        this.assertMutable();
        this.writeInt(this.getLastStoredTimeOffset(), TimeStripUtil.stripBaseTime(lastStoredTime));
    }

    @Override
    public RecordReaderWriter getMatchingRecordReaderWriter() {
        return RecordReaderWriter.DATA_RECORD_WITH_STATS_READER_WRITER;
    }

    @Override
    public int getRawCreationTime() {
        return this.readInt(this.getCreationTimeOffset());
    }

    @Override
    public void setRawCreationTime(int time) {
        this.assertMutable();
        this.writeInt(this.getCreationTimeOffset(), time);
    }

    @Override
    public int getRawLastAccessTime() {
        return this.readInt(this.getLastAccessTimeOffset());
    }

    @Override
    public void setRawLastAccessTime(int time) {
        this.assertMutable();
        this.writeInt(this.getLastAccessTimeOffset(), time);
    }

    @Override
    public int getRawLastUpdateTime() {
        return this.readInt(this.getLastUpdateTimeOffset());
    }

    @Override
    public void setRawLastUpdateTime(int time) {
        this.assertMutable();
        this.writeInt(this.getLastUpdateTimeOffset(), time);
    }

    @Override
    public int getRawLastStoredTime() {
        return this.readInt(this.getLastStoredTimeOffset());
    }

    @Override
    public void setRawLastStoredTime(int time) {
        this.assertMutable();
        this.writeInt(this.getLastStoredTimeOffset(), time);
    }

    static Record makeRecordFrom(byte[] recordBytes) {
        Data dataValue = TieredStoreRecordWithStats.getValueFromRecord(recordBytes);
        DataRecordWithStats record = new DataRecordWithStats(dataValue);
        int versionOffset = TieredStoreRecordWithStats.getMetadataOffsetFromRecord(recordBytes);
        int version = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, recordBytes, versionOffset, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        record.setVersion(version);
        int creationTimeOffset = versionOffset + 4;
        int creationTime = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, recordBytes, creationTimeOffset, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        record.setRawCreationTime(creationTime);
        int lastAccessTimeOffset = creationTimeOffset + 4;
        int lastAccessTime = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, recordBytes, lastAccessTimeOffset, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        record.setRawLastAccessTime(lastAccessTime);
        int lastUpdateTimeOffset = lastAccessTimeOffset + 4;
        int lastUpdateTime = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, recordBytes, lastUpdateTimeOffset, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        record.setRawLastUpdateTime(lastUpdateTime);
        int hitsOffset = lastUpdateTimeOffset + 4;
        int hits = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, recordBytes, hitsOffset, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        record.setHits(hits);
        int lastStoredTimeOffset = hitsOffset + 4;
        int lastStoredTime = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, recordBytes, lastStoredTimeOffset, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        record.setRawLastStoredTime(lastStoredTime);
        int sequenceOffset = lastStoredTimeOffset + 4;
        int sequence = EndiannessUtil.readInt(ByteArrayAccessStrategy.INSTANCE, recordBytes, sequenceOffset, GlobalMemoryAccessorRegistry.AMEM.isBigEndian());
        record.setSequence(sequence);
        return record;
    }

    private static int getMetadataOffsetFromRecord(byte[] record) {
        return record.length - 28;
    }

    static Record makeRecordFrom(TieredStoreRecord record0) {
        TieredStoreRecordWithStats record = (TieredStoreRecordWithStats)record0;
        Data dataValue = ToHeapDataConverter.toHeapData(record.getValue());
        DataRecordWithStats onHeapRecord = new DataRecordWithStats(dataValue);
        onHeapRecord.setVersion(record.getVersion());
        onHeapRecord.setRawCreationTime(record.getRawCreationTime());
        onHeapRecord.setRawLastAccessTime(record.getRawLastAccessTime());
        onHeapRecord.setRawLastUpdateTime(record.getRawLastUpdateTime());
        onHeapRecord.setHits(record.getHits());
        onHeapRecord.setRawLastStoredTime(record.getRawLastStoredTime());
        onHeapRecord.setSequence(record.getSequence());
        return onHeapRecord;
    }
}

