/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.hidensity.HiDensityRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.record.Record;

public abstract class HDRecord
extends HiDensityRecord
implements Record<Data> {
    public static final int DEFAULT_VALUE_OFFSET = 0;
    private final HiDensityRecordAccessor recordAccessor;

    public HDRecord(GlobalMemoryAccessor memoryAccessor, HiDensityRecordAccessor recordAccessor) {
        super(memoryAccessor);
        this.recordAccessor = recordAccessor;
    }

    HiDensityRecordAccessor getRecordAccessor() {
        return this.recordAccessor;
    }

    @Override
    public final long getValueAddress() {
        return this.recordAccessor.readValueAddress(this);
    }

    @Override
    public final void setValueAddress(long valueAddress) {
        this.recordAccessor.setValueAddress(this, valueAddress);
    }

    @Override
    public Data getValue() {
        if (this.address == 0L) {
            return null;
        }
        long valueAddress = this.getValueAddress();
        if (valueAddress == 0L) {
            return null;
        }
        return this.recordAccessor.readData(valueAddress);
    }

    @Override
    public final void setValue(Data value) {
        this.recordAccessor.setValue(this, value);
    }

    @Override
    public final void clear() {
        this.zero();
    }

    @Override
    public HDRecord reset(long address) {
        this.setAddress(address);
        this.setSize(this.getSizeInternal());
        return this;
    }

    protected abstract int getSizeInternal();

    @Override
    public long getSequence() {
        return -1L;
    }

    @Override
    public long getCost() {
        return 0L;
    }

    @Override
    public String toString() {
        String className = this.getClass().getSimpleName();
        return this.address() == 0L ? className + "{NULL}" : className + "{version: " + this.getVersion() + ", creationTime: " + this.getCreationTime() + ", lastAccessTime: " + this.getLastAccessTime() + ", lastUpdateTime: " + this.getLastUpdateTime() + ", lastStoredTime: " + this.getLastStoredTime() + ", hits: " + this.getHits() + ", sequence: " + this.getSequence() + ", valueAddress: " + this.getValueAddress() + " }";
    }
}

