/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.monitor.impl.LocalReplicationStatsImpl;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.collection.IntHashSet;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.operation.EnterpriseMapDataSerializerHook;
import com.hazelcast.map.impl.operation.MapReplicationStateHolder;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import com.hazelcast.wan.impl.merkletree.MerkleTreeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;

public class EnterpriseMapReplicationStateHolder
extends MapReplicationStateHolder {
    private ILogger logger = Logger.getLogger(EnterpriseMapReplicationStateHolder.class);

    @Override
    protected void writeDifferentialData(String mapName, RecordStore<Record> recordStore, ObjectDataOutput out) throws IOException {
        int[] diff = (int[])this.merkleTreeDiffByMapName.get(mapName);
        out.writeIntArray(diff);
        List entries = this.collectEntries(recordStore, diff);
        out.writeInt(entries.size() / 2);
        SerializationService ss = EnterpriseMapReplicationStateHolder.getSerializationService(this.operation.getRecordStore(mapName).getMapContainer());
        for (int i = 0; i < entries.size(); i += 2) {
            Data keyData = (Data)entries.get(i);
            Record record = (Record)entries.get(i + 1);
            IOUtil.writeData(out, keyData);
            Records.writeRecord(out, record, ss.toData(record.getValue()));
            Records.writeExpiry(out, recordStore.getExpirySystem().getExpiryMetadata(keyData));
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Differential sync for " + mapName + " / " + this.operation.getPartitionId() + " transferred " + entries.size() / 2 + " records");
        }
        LocalReplicationStatsImpl replicationStats = (LocalReplicationStatsImpl)this.statsByMapName.get(mapName);
        replicationStats.incrementDiffPartitionReplicationCount();
        replicationStats.incrementDiffPartitionReplicationRecordsCount(entries.size() / 2);
    }

    @Override
    protected void initializeRecordStore(String mapName, RecordStore recordStore) {
        super.initializeRecordStore(mapName, recordStore);
        int[] nodeOrders = (int[])this.merkleTreeDiffByMapName.get(mapName);
        if (nodeOrders != null && nodeOrders.length > 0) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Applying differential sync for " + mapName);
            }
            MapContainer mapContainer = recordStore.getMapContainer();
            EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)mapContainer.getMapServiceContext().getPartitionContainer(this.operation.getPartitionId());
            boolean backup = this.operation.getReplicaIndex() != 0;
            MerkleTree merkleTree = partitionContainer.getMerkleTreeOrNull(mapContainer);
            assert (merkleTree != null) : "MerkleTree was unexpectedly null";
            List kvPairs = (List)this.data.get(mapName);
            HashSet keysToRemove = new HashSet();
            this.forEachKeyOfNodes(recordStore, nodeOrders, (k, r) -> {
                if (!kvPairs.contains(k)) {
                    keysToRemove.add(k);
                }
            });
            for (Data k2 : keysToRemove) {
                recordStore.removeReplicatedRecord(k2, backup);
            }
        }
    }

    private List collectEntries(RecordStore<Record> recordStore, int[] diff) {
        MapContainer mapContainer = recordStore.getMapContainer();
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)mapContainer.getMapServiceContext().getPartitionContainer(this.operation.getPartitionId());
        MerkleTree localMerkleTree = partitionContainer.getMerkleTreeOrNull(mapContainer);
        if (localMerkleTree == null || diff == null || diff.length == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(diff.length / 2);
        this.forEachKeyOfNodes(recordStore, diff, (key, record) -> {
            result.add(key);
            result.add(record);
        });
        return result;
    }

    private void forEachKeyOfNodes(RecordStore<Record> recordStore, int[] merkleTreeOrderValuePairs, BiConsumer<Data, Record> consumer) {
        ThreadUtil.assertRunningOnPartitionThread();
        IntHashSet merkleTreeOrderValues = MerkleTreeUtil.setOfNodeOrders(merkleTreeOrderValuePairs);
        int levelOfRequestedNodes = MerkleTreeUtil.getLevelOfNode(merkleTreeOrderValuePairs[0]);
        recordStore.forEach((dataKey, record) -> {
            int keyHash = dataKey.hashCode();
            int currentKeyNodeOrder = MerkleTreeUtil.getLeafOrderForHash(keyHash, levelOfRequestedNodes);
            if (merkleTreeOrderValues.contains(currentKeyNodeOrder)) {
                consumer.accept((Data)dataKey, (Record)record);
            }
        }, this.operation.getReplicaIndex() != 0, true);
    }

    @Override
    public int getFactoryId() {
        return EnterpriseMapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 7;
    }
}

