/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.submitjob.memberside;

import com.hazelcast.internal.util.Sha256Util;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.submitjob.memberside.JobMetaDataParameterObject;
import com.hazelcast.jet.impl.submitjob.memberside.JobMultiPartParameterObject;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public class JobUploadStatus {
    protected static final long EXPIRATION_MINUTES = 2L;
    private static final ILogger LOGGER = Logger.getLogger(JobUploadStatus.class);
    protected Instant lastUpdatedTime;
    private final Clock clock;
    private int currentPart;
    private int totalPart;
    private final JobMetaDataParameterObject jobMetaDataParameterObject;

    public JobUploadStatus(JobMetaDataParameterObject parameterObject) {
        this(parameterObject, Clock.systemUTC());
    }

    protected JobUploadStatus(JobMetaDataParameterObject parameterObject, Clock clock) {
        this.jobMetaDataParameterObject = parameterObject;
        this.clock = clock;
        this.changeLastUpdatedTime();
    }

    public JobMetaDataParameterObject getJobMetaDataParameterObject() {
        return this.jobMetaDataParameterObject;
    }

    public boolean isExpired() {
        Instant now = this.clock.instant();
        Duration between = Duration.between(this.lastUpdatedTime, now);
        long minutes = between.toMinutes();
        return minutes >= 2L;
    }

    public void removeBadSession() {
        JobUploadStatus.cleanup(this.jobMetaDataParameterObject);
    }

    public static void cleanup(JobMetaDataParameterObject jobMetaDataParameterObject) {
        Path jarPath;
        if (jobMetaDataParameterObject.isJarOnClient() && (jarPath = jobMetaDataParameterObject.getJarPath()) != null) {
            try {
                Files.delete(jarPath);
            }
            catch (IOException exception) {
                LOGGER.severe("Could not delete the jar : " + String.valueOf(jarPath), exception);
            }
        }
    }

    public JobMetaDataParameterObject processJobMultipart(JobMultiPartParameterObject parameterObject) throws IOException, NoSuchAlgorithmException {
        this.changeLastUpdatedTime();
        JobUploadStatus.validateReceivedParameters(parameterObject);
        this.validateReceivedPartNumbersAreExpected(parameterObject);
        this.validatePartChecksum(parameterObject);
        this.currentPart = parameterObject.getCurrentPartNumber();
        this.totalPart = parameterObject.getTotalPartNumber();
        Path jarPath = this.jobMetaDataParameterObject.getJarPath();
        try (FileOutputStream outputStream = new FileOutputStream(jarPath.toFile(), true);){
            outputStream.write(parameterObject.getPartData(), 0, parameterObject.getPartSize());
        }
        if (LOGGER.isInfoEnabled()) {
            String message = String.format("Session : %s jarPath: %s PartNumber: %d/%d Total file size : %d bytes", parameterObject.getSessionId(), jarPath, this.currentPart, this.totalPart, Files.size(jarPath));
            LOGGER.info(message);
        }
        JobMetaDataParameterObject result = null;
        if (this.currentPart == this.totalPart) {
            this.validateJarChecksum();
            result = this.jobMetaDataParameterObject;
        }
        return result;
    }

    void createNewTemporaryFile() throws IOException {
        Path jarPath = this.createJarPath();
        File jarFile = jarPath.toFile();
        boolean success = jarFile.setReadable(true, true);
        if (!success) {
            LOGGER.info("setReadable failed on " + String.valueOf(jarFile));
        }
        if (!(success = jarFile.setWritable(true, true))) {
            LOGGER.info("setWritable failed on " + String.valueOf(jarFile));
        }
        if (!(success = jarFile.setExecutable(true, true))) {
            LOGGER.info("setExecutable failed on " + String.valueOf(jarFile));
        }
        this.jobMetaDataParameterObject.setJarPath(jarPath);
    }

    Path createJarPath() throws IOException {
        Path jarPath;
        if (this.jobMetaDataParameterObject.getUploadDirectoryPath() != null) {
            Path path = Paths.get(this.jobMetaDataParameterObject.getUploadDirectoryPath(), new String[0]);
            jarPath = Files.createTempFile(path, this.jobMetaDataParameterObject.getFileName(), ".jar", new FileAttribute[0]);
        } else {
            jarPath = Files.createTempFile(this.jobMetaDataParameterObject.getFileName(), ".jar", new FileAttribute[0]);
        }
        return jarPath;
    }

    private static void validateReceivedParameters(JobMultiPartParameterObject parameterObject) {
        int receivedCurrentPart = parameterObject.getCurrentPartNumber();
        int receivedTotalPart = parameterObject.getTotalPartNumber();
        if (receivedCurrentPart <= 0) {
            String errorMessage = String.format("receivedPart : %d is incorrect", receivedCurrentPart);
            throw new JetException(errorMessage);
        }
        if (receivedTotalPart <= 0) {
            String errorMessage = String.format("receivedTotalPart : %d is incorrect", receivedTotalPart);
            throw new JetException(errorMessage);
        }
        if (receivedCurrentPart > receivedTotalPart) {
            String errorMessage = String.format("receivedPart : %d is bigger than receivedTotalPart : %d ", receivedCurrentPart, receivedTotalPart);
            throw new JetException(errorMessage);
        }
        byte[] partData = parameterObject.getPartData();
        if (partData == null) {
            String errorMessage = "receivedPartData is null";
            throw new JetException(errorMessage);
        }
        if (partData.length == 0) {
            String errorMessage = "receivedPartData size is 0";
            throw new JetException(errorMessage);
        }
        int partSize = parameterObject.getPartSize();
        if (partSize == 0) {
            String errorMessage = "receivedPartSize is 0";
            throw new JetException(errorMessage);
        }
        if (partSize > partData.length) {
            String errorMessage = String.format("receivedPartSize: %d is bigger than receivedPartLength : %d ", partSize, partData.length);
            throw new JetException(errorMessage);
        }
        if (Objects.isNull(parameterObject.getSha256Hex())) {
            String errorMessage = "Sha256Hex of part is null";
            throw new JetException(errorMessage);
        }
    }

    private void validateReceivedPartNumbersAreExpected(JobMultiPartParameterObject parameterObject) {
        int receivedCurrentPart = parameterObject.getCurrentPartNumber();
        int receivedTotalPart = parameterObject.getTotalPartNumber();
        if (this.currentPart >= receivedCurrentPart) {
            String errorMessage = String.format("Received an old order part. currentPart : %d receivedPart : %d", this.currentPart, receivedCurrentPart);
            throw new JetException(errorMessage);
        }
        if (this.currentPart + 1 != receivedCurrentPart) {
            String errorMessage = String.format("Received an out of order part. currentPart : %d receivedPart : %d", this.currentPart, receivedCurrentPart);
            throw new JetException(errorMessage);
        }
        if (this.totalPart != 0 && this.totalPart != receivedTotalPart) {
            String errorMessage = String.format("Received a different totalPart. totalPart : %d receivedTotalPart : %d", this.totalPart, receivedTotalPart);
            throw new JetException(errorMessage);
        }
    }

    private void validatePartChecksum(JobMultiPartParameterObject parameterObject) throws NoSuchAlgorithmException {
        String receivedSha256Hex;
        String calculatedSha256Hex = Sha256Util.calculateSha256Hex(parameterObject.getPartData(), parameterObject.getPartSize());
        if (!calculatedSha256Hex.equals(receivedSha256Hex = parameterObject.getSha256Hex())) {
            String errorMessage = String.format("Checksum is different!. Calculated SHA256 : %s. Received SHA256 : %s", calculatedSha256Hex, receivedSha256Hex);
            throw new JetException(errorMessage);
        }
    }

    private void validateJarChecksum() throws IOException, NoSuchAlgorithmException {
        String receivedSha256Hex;
        String calculatedSha256Hex = Sha256Util.calculateSha256Hex(this.jobMetaDataParameterObject.getJarPath());
        if (!calculatedSha256Hex.equals(receivedSha256Hex = this.jobMetaDataParameterObject.getSha256Hex())) {
            String errorMessage = String.format("Checksum is different!. Calculated SHA256 : %s. Received SHA256 : %s", calculatedSha256Hex, receivedSha256Hex);
            throw new JetException(errorMessage);
        }
    }

    protected void changeLastUpdatedTime() {
        this.lastUpdatedTime = this.clock.instant();
    }
}

