/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobCoordinationService;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.SelfResponseOperation;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public abstract class AsyncOperation
extends Operation
implements SelfResponseOperation,
IdentifiedDataSerializable {
    @Override
    public void beforeRun() {
        JetServiceBackend service = this.getJetServiceBackend();
        service.getLiveOperationRegistry().register(this);
    }

    @Override
    public final void run() {
        CompletableFuture<?> future;
        try {
            future = this.doRun();
        }
        catch (Exception e) {
            this.logError(e);
            this.doSendResponse(e);
            return;
        }
        future.whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.getLogger(), (r, f) -> {
            if (f != null) {
                Throwable peeledFailure = com.hazelcast.jet.impl.util.ExceptionUtil.peel(f);
                if (!com.hazelcast.jet.impl.util.ExceptionUtil.isTechnicalCancellationException(f)) {
                    this.logError(peeledFailure);
                }
                this.doSendResponse(peeledFailure);
            } else {
                this.doSendResponse(r);
            }
        }));
    }

    protected abstract CompletableFuture<?> doRun() throws Exception;

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendResponse(Object value) {
        try {
            JetServiceBackend service = this.getJetServiceBackend();
            service.getLiveOperationRegistry().deregister(this);
        }
        finally {
            try {
                this.sendResponse(value);
            }
            catch (Exception e) {
                Throwable ex = com.hazelcast.jet.impl.util.ExceptionUtil.peel(e);
                if (value instanceof Throwable) {
                    Throwable throwable = (Throwable)value;
                    if (ex instanceof HazelcastSerializationException) {
                        this.sendResponse(new JetException(ExceptionUtil.toString(throwable)));
                    }
                }
                throw e;
            }
        }
    }

    protected JetServiceBackend getJetServiceBackend() {
        Util.checkJetIsEnabled(this.getNodeEngine());
        assert (this.getServiceName().equals("hz:impl:jetService")) : "Service is not Jet Service";
        return (JetServiceBackend)this.getService();
    }

    protected JobCoordinationService getJobCoordinationService() {
        return this.getJetServiceBackend().getJobCoordinationService();
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        return com.hazelcast.jet.impl.util.ExceptionUtil.isTopologyException(throwable) ? ExceptionAction.THROW_EXCEPTION : super.onInvocationException(throwable);
    }

    @Override
    public final int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }
}

