/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembershipManager;
import com.hazelcast.internal.cluster.impl.operations.TriggerMemberListPublishOp;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.internal.util.counters.Counter;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.impl.JobClassLoaderService;
import com.hazelcast.jet.impl.JobMetricsUtil;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.deployment.JetDelegatingClassLoader;
import com.hazelcast.jet.impl.exception.ExecutionNotFoundException;
import com.hazelcast.jet.impl.exception.JobTerminateRequestedException;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.TaskletExecutionService;
import com.hazelcast.jet.impl.execution.init.ExecutionPlan;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import com.hazelcast.jet.impl.operation.CheckLightJobsOperation;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobExecutionService
implements DynamicMetricsProvider {
    private static final long UNINITIALIZED_CONTEXT_MAX_AGE_NS = TimeUnit.MINUTES.toNanos(5L);
    private static final long FAILED_EXECUTION_EXPIRY_NS = TimeUnit.SECONDS.toNanos(5L);
    private static final CompletableFuture<?>[] EMPTY_COMPLETABLE_FUTURE_ARRAY = new CompletableFuture[0];
    private final Object mutex = new Object();
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final TaskletExecutionService taskletExecutionService;
    private final JobClassLoaderService jobClassloaderService;
    private final Set<Long> executionContextJobIds = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<Long, ExecutionContext> executionContexts = new ConcurrentHashMap<Long, ExecutionContext>();
    private final ConcurrentMap<Long, Long> failedJobs = new ConcurrentHashMap<Long, Long>();
    @Probe(name="jobs.executionStarted")
    private final Counter executionStarted = MwCounter.newMwCounter();
    @Probe(name="jobs.executionCompleted")
    private final Counter executionCompleted = MwCounter.newMwCounter();
    private final Function<? super Long, ? extends ExecutionContext> newLightJobExecutionContextFunction;
    private final ScheduledFuture<?> lightExecutionsCheckerFuture;

    JobExecutionService(NodeEngineImpl nodeEngine, TaskletExecutionService taskletExecutionService, JobClassLoaderService jobClassloaderService) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
        this.taskletExecutionService = taskletExecutionService;
        this.jobClassloaderService = jobClassloaderService;
        this.newLightJobExecutionContextFunction = execId -> this.failedJobs.containsKey(execId) ? null : new ExecutionContext(nodeEngine, (long)execId, (long)execId, true);
        MetricsRegistry registry = nodeEngine.getMetricsRegistry();
        MetricDescriptor descriptor = registry.newMetricDescriptor().withTag("module", "jet");
        registry.registerStaticMetrics(descriptor, this);
        this.lightExecutionsCheckerFuture = nodeEngine.getExecutionService().scheduleWithRepetition(this::checkExecutions, 0L, 1L, TimeUnit.SECONDS);
    }

    public Long getExecutionIdForJobId(long jobId) {
        return this.executionContexts.values().stream().filter(ec -> ec.jobId() == jobId).findAny().map(ExecutionContext::executionId).orElse(null);
    }

    public ExecutionContext getExecutionContext(long executionId) {
        return (ExecutionContext)this.executionContexts.get(executionId);
    }

    @Nullable
    public ExecutionContext getOrCreateExecutionContext(long executionId) {
        return this.executionContexts.computeIfAbsent(executionId, this.newLightJobExecutionContextFunction);
    }

    public Collection<ExecutionContext> getExecutionContexts() {
        return this.executionContexts.values();
    }

    public ConcurrentMap<Long, Long> getFailedJobs() {
        return this.failedJobs;
    }

    Map<ExecutionContext.SenderReceiverKey, SenderTasklet> getSenderMap(long executionId) {
        ExecutionContext ctx = (ExecutionContext)this.executionContexts.get(executionId);
        return ctx != null ? ctx.senderMap() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lightExecutionsCheckerFuture.cancel(false);
        Object object = this.mutex;
        synchronized (object) {
            this.cancelAllExecutions("Node is shutting down");
        }
    }

    public void reset() {
        this.cancelAllExecutions("reset");
    }

    public void cancelAllExecutions(String reason) {
        Collection contexts = this.executionContexts.values();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(contexts.size());
        for (ExecutionContext exeCtx : contexts) {
            this.logger.fine("Completing %s locally. Reason: %s", exeCtx.jobNameAndExecutionId(), reason);
            futures.add(this.terminateExecution0(exeCtx, null, new CancellationException()));
        }
        CompletableFuture.allOf(futures.toArray(EMPTY_COMPLETABLE_FUTURE_ARRAY)).join();
    }

    void onMemberRemoved(Member member) {
        Address address = member.getAddress();
        CompletableFuture[] terminationFutures = (CompletableFuture[])this.executionContexts.values().stream().filter(exeCtx -> exeCtx.coordinator() != null && (exeCtx.coordinator().equals(address) || exeCtx.hasParticipant(address))).map(exeCtx -> {
            this.logger.fine("Completing %s locally. Reason: Member %s left the cluster", exeCtx.jobNameAndExecutionId(), address);
            return this.terminateExecution0((ExecutionContext)exeCtx, null, new MemberLeftException(member));
        }).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(terminationFutures).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RawJobMetrics> runLightJob(long jobId, long executionId, Address coordinator, int coordinatorMemberListVersion, Set<MemberInfo> participants, ExecutionPlan plan) {
        ExecutionContext execCtx;
        assert (executionId == jobId) : "executionId(" + com.hazelcast.jet.Util.idToString(executionId) + ") != jobId(" + com.hazelcast.jet.Util.idToString(jobId) + ")";
        this.verifyClusterInformation(jobId, executionId, coordinator, coordinatorMemberListVersion, participants);
        this.failIfNotRunning();
        Object object = this.mutex;
        synchronized (object) {
            this.addExecutionContextJobId(jobId, executionId, coordinator);
            execCtx = this.executionContexts.computeIfAbsent(executionId, x -> new ExecutionContext(this.nodeEngine, jobId, executionId, true));
        }
        Set<Address> addresses = participants.stream().map(MemberInfo::getAddress).collect(Collectors.toSet());
        return ((CompletableFuture)((CompletableFuture)execCtx.initialize(coordinator, addresses, plan).whenComplete((r, e) -> {
            if (e != null) {
                this.completeExecution(execCtx, new CancellationException()).join();
            }
        })).thenAccept(r -> {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Execution plan for light job ID=" + com.hazelcast.jet.Util.idToString(jobId) + ", jobName=" + (String)(execCtx.jobName() != null ? "'" + execCtx.jobName() + "'" : "null") + ", executionId=" + com.hazelcast.jet.Util.idToString(executionId) + " initialized, will start the execution");
            }
        })).thenCompose(r -> this.beginExecution0(execCtx, false));
    }

    public CompletableFuture<Void> initExecution(long jobId, long executionId, Address coordinator, int coordinatorMemberListVersion, Set<MemberInfo> participants, ExecutionPlan plan) {
        ExecutionContext execCtx = this.addExecutionContext(jobId, executionId, coordinator, coordinatorMemberListVersion, participants);
        Set addresses = participants.stream().map(MemberInfo::getAddress).collect(Collectors.toSet());
        JetDelegatingClassLoader jobCl = this.jobClassloaderService.getClassLoader(jobId);
        return Util.doWithClassLoader((ClassLoader)jobCl, () -> execCtx.initialize(coordinator, addresses, plan)).thenAccept(r -> this.logger.info("Execution plan for jobId=" + com.hazelcast.jet.Util.idToString(jobId) + ", jobName=" + (String)(execCtx.jobName() != null ? "'" + execCtx.jobName() + "'" : "null") + ", executionId=" + com.hazelcast.jet.Util.idToString(executionId) + " initialized"));
    }

    private void addExecutionContextJobId(long jobId, long executionId, Address coordinator) {
        if (!this.executionContextJobIds.add(jobId)) {
            ExecutionContext current = (ExecutionContext)this.executionContexts.get(executionId);
            if (current != null) {
                throw new IllegalStateException(String.format("Execution context for %s for coordinator %s already exists for coordinator %s", current.jobNameAndExecutionId(), coordinator, current.coordinator()));
            }
            if (this.logger.isFineEnabled()) {
                this.executionContexts.values().stream().filter(e -> e.jobId() == jobId).forEach(e -> this.logger.fine(String.format("Execution context for job %s for coordinator %s already exists with local execution %s for coordinator %s", com.hazelcast.jet.Util.idToString(jobId), coordinator, com.hazelcast.jet.Util.idToString(e.executionId()), e.coordinator())));
            }
            throw new RetryableHazelcastException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionContext addExecutionContext(long jobId, long executionId, Address coordinator, int coordinatorMemberListVersion, Set<MemberInfo> participants) {
        ExecutionContext oldContext;
        ExecutionContext execCtx;
        try {
            this.assertIsMaster(jobId, executionId, coordinator);
            this.verifyClusterInformation(jobId, executionId, coordinator, coordinatorMemberListVersion, participants);
            this.failIfNotRunning();
            Object object = this.mutex;
            synchronized (object) {
                this.addExecutionContextJobId(jobId, executionId, coordinator);
                execCtx = new ExecutionContext(this.nodeEngine, jobId, executionId, false);
                oldContext = this.executionContexts.put(executionId, execCtx);
            }
        }
        catch (Throwable t) {
            this.jobClassloaderService.tryRemoveClassloadersForJob(jobId, JobClassLoaderService.JobPhase.EXECUTION);
            throw t;
        }
        if (oldContext != null) {
            throw new RuntimeException("Duplicate ExecutionContext for execution " + com.hazelcast.jet.Util.idToString(executionId));
        }
        return execCtx;
    }

    private void assertIsMaster(long jobId, long executionId, Address coordinator) {
        Address masterAddress = this.nodeEngine.getMasterAddress();
        if (!coordinator.equals(masterAddress)) {
            this.failIfNotRunning();
            throw new IllegalStateException(String.format("Coordinator %s cannot initialize %s. Reason: it is not the master, the master is %s", coordinator, Util.jobIdAndExecutionId(jobId, executionId), masterAddress));
        }
    }

    private void verifyClusterInformation(long jobId, long executionId, Address coordinator, int coordinatorMemberListVersion, Set<MemberInfo> participants) {
        Address masterAddress = this.nodeEngine.getMasterAddress();
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.nodeEngine.getClusterService();
        MembershipManager membershipManager = clusterService.getMembershipManager();
        int localMemberListVersion = membershipManager.getMemberListVersion();
        Address thisAddress = this.nodeEngine.getThisAddress();
        if (coordinatorMemberListVersion > localMemberListVersion) {
            if (masterAddress == null) {
                throw new RetryableHazelcastException(String.format("Cannot initialize %s for coordinator %s, local member list version %s, coordinator member list version %s. And also, since the master address is not known to this member, cannot request a new member list from master.", Util.jobIdAndExecutionId(jobId, executionId), coordinator, localMemberListVersion, coordinatorMemberListVersion));
            }
            assert (!masterAddress.equals(thisAddress)) : String.format("Local node: %s is master but InitOperation has coordinator member list version: %s larger than  local member list version: %s", thisAddress, coordinatorMemberListVersion, localMemberListVersion);
            this.nodeEngine.getOperationService().send(new TriggerMemberListPublishOp(), masterAddress);
            throw new RetryableHazelcastException(String.format("Cannot initialize %s for coordinator %s, local member list version %s, coordinator member list version %s", Util.jobIdAndExecutionId(jobId, executionId), coordinator, localMemberListVersion, coordinatorMemberListVersion));
        }
        boolean isLocalMemberParticipant = false;
        for (MemberInfo participant : participants) {
            if (participant.getAddress().equals(thisAddress)) {
                isLocalMemberParticipant = true;
            }
            if (membershipManager.getMember(participant.getAddress(), participant.getUuid()) != null) continue;
            throw new TopologyChangedException(String.format("Cannot initialize %s for coordinator %s: participant %s not found in local member list. Local member list version: %s, coordinator member list version: %s", Util.jobIdAndExecutionId(jobId, executionId), coordinator, participant, localMemberListVersion, coordinatorMemberListVersion));
        }
        if (!isLocalMemberParticipant) {
            throw new IllegalArgumentException(String.format("Cannot initialize %s since member %s is not in participants: %s", Util.jobIdAndExecutionId(jobId, executionId), thisAddress, participants));
        }
    }

    private void failIfNotRunning() {
        if (!this.nodeEngine.isRunning()) {
            throw new HazelcastInstanceNotActiveException();
        }
    }

    @Nonnull
    public ExecutionContext assertExecutionContext(Address callerAddress, long jobId, long executionId, String callerOpName) {
        Address masterAddress = this.nodeEngine.getMasterAddress();
        if (!callerAddress.equals(masterAddress)) {
            this.failIfNotRunning();
            throw new IllegalStateException(String.format("Caller %s cannot do '%s' for %s: it is not the master, the master is %s", callerAddress, callerOpName, Util.jobIdAndExecutionId(jobId, executionId), masterAddress));
        }
        this.failIfNotRunning();
        ExecutionContext executionContext = (ExecutionContext)this.executionContexts.get(executionId);
        if (executionContext == null) {
            throw new ExecutionNotFoundException(String.format("%s not found for coordinator %s for '%s'", Util.jobIdAndExecutionId(jobId, executionId), callerAddress, callerOpName));
        }
        if (!executionContext.coordinator().equals(callerAddress) || executionContext.jobId() != jobId) {
            throw new IllegalStateException(String.format("%s, originally from coordinator %s, cannot do '%s' by coordinator %s and execution %s", executionContext.jobNameAndExecutionId(), executionContext.coordinator(), callerOpName, callerAddress, com.hazelcast.jet.Util.idToString(executionId)));
        }
        return executionContext;
    }

    public CompletableFuture<Void> completeExecution(@Nonnull ExecutionContext executionContext, Throwable error) {
        ExecutionContext removed = (ExecutionContext)this.executionContexts.remove(executionContext.executionId());
        if (removed != null) {
            if (error != null) {
                this.failedJobs.put(executionContext.executionId(), System.nanoTime() + FAILED_EXECUTION_EXPIRY_NS);
            }
            JetDelegatingClassLoader jobClassLoader = this.jobClassloaderService.getClassLoader(executionContext.jobId());
            return Util.doWithClassLoader((ClassLoader)jobClassLoader, () -> executionContext.completeExecution(error)).whenComplete(com.hazelcast.internal.util.ExceptionUtil.withTryCatch(this.logger, (ignored, t) -> {
                if (!executionContext.isLightJob()) {
                    this.jobClassloaderService.tryRemoveClassloadersForJob(executionContext.jobId(), JobClassLoaderService.JobPhase.EXECUTION);
                }
                this.executionCompleted.inc();
                this.executionContextJobIds.remove(executionContext.jobId());
                this.logger.fine("Completed execution of " + executionContext.jobNameAndExecutionId());
            }));
        }
        return CompletableFuture.completedFuture(null);
    }

    public void updateMetrics(@Nonnull Long executionId, RawJobMetrics metrics) {
        ExecutionContext executionContext = (ExecutionContext)this.executionContexts.get(executionId);
        if (executionContext != null) {
            executionContext.setMetrics(metrics);
        }
    }

    public CompletableFuture<RawJobMetrics> beginExecution(Address coordinator, long jobId, long executionId, boolean collectMetrics) {
        ExecutionContext execCtx = this.assertExecutionContext(coordinator, jobId, executionId, "StartExecutionOperation");
        assert (!execCtx.isLightJob()) : "StartExecutionOperation received for a light job " + com.hazelcast.jet.Util.idToString(jobId);
        this.logger.info("Start execution of " + execCtx.jobNameAndExecutionId() + " from coordinator " + String.valueOf(coordinator));
        return this.beginExecution0(execCtx, collectMetrics);
    }

    public CompletableFuture<RawJobMetrics> beginExecution0(ExecutionContext execCtx, boolean collectMetrics) {
        this.executionStarted.inc();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)execCtx.beginExecution(this.taskletExecutionService).thenApply(r -> {
            RawJobMetrics terminalMetrics;
            if (collectMetrics) {
                try (JobMetricsCollector metricsRenderer = new JobMetricsCollector(this.nodeEngine.getLocalMember(), this.logger);){
                    this.nodeEngine.getMetricsRegistry().collectDynamicMetrics(metricsRenderer, Collections.singleton(execCtx));
                    terminalMetrics = metricsRenderer.getMetrics();
                }
            } else {
                terminalMetrics = null;
            }
            return terminalMetrics;
        })).handleAsync((metrics, e) -> this.completeExecution(execCtx, ExceptionUtil.peel(e)).thenApply(ignored -> {
            if (e == null) {
                return metrics;
            }
            throw com.hazelcast.internal.util.ExceptionUtil.sneakyThrow(e);
        }), (Executor)this.nodeEngine.getExecutionService().getExecutor("hz:async"))).thenCompose(stage -> stage)).whenComplete((metrics, e) -> {
            if (ExceptionUtil.isOrHasCause(e, CancellationException.class)) {
                this.logger.fine("Execution of " + execCtx.jobNameAndExecutionId() + " was cancelled");
            } else if (e != null) {
                this.logger.fine("Execution of " + execCtx.jobNameAndExecutionId() + " completed with failure", (Throwable)e);
            } else {
                this.logger.fine("Execution of " + execCtx.jobNameAndExecutionId() + " completed");
            }
        });
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        try {
            descriptor.withTag("module", "jet");
            this.executionContexts.forEach((id, ctx) -> ctx.provideDynamicMetrics(descriptor.copy(), context));
        }
        catch (Throwable t) {
            this.logger.warning("Dynamic metric collection failed", t);
            throw t;
        }
    }

    private void checkExecutions() {
        try {
            long now = System.nanoTime();
            long uninitializedContextThreshold = now - UNINITIALIZED_CONTEXT_MAX_AGE_NS;
            HashMap<Address, List> executionsPerMember = new HashMap<Address, List>();
            ArrayList<CompletableFuture<Void>> terminateFutures = new ArrayList<CompletableFuture<Void>>();
            for (ExecutionContext executionContext : this.executionContexts.values()) {
                if (!executionContext.isLightJob()) continue;
                Address coordinator = executionContext.coordinator();
                if (coordinator != null) {
                    executionsPerMember.computeIfAbsent(coordinator, k -> new ArrayList()).add(executionContext.executionId());
                    continue;
                }
                if (executionContext.getCreatedOn() > uninitializedContextThreshold) continue;
                this.logger.fine("Terminating light job %s because it wasn't initialized during %d seconds", com.hazelcast.jet.Util.idToString(executionContext.executionId()), TimeUnit.NANOSECONDS.toSeconds(UNINITIALIZED_CONTEXT_MAX_AGE_NS));
                terminateFutures.add(this.terminateExecution0(executionContext, TerminationMode.CANCEL_FORCEFUL, new CancellationException()));
            }
            if (!terminateFutures.isEmpty()) {
                CompletableFuture.allOf(terminateFutures.toArray(EMPTY_COMPLETABLE_FUTURE_ARRAY)).join();
            }
            for (Map.Entry entry : executionsPerMember.entrySet()) {
                long[] executionIds = ((List)entry.getValue()).stream().mapToLong(Long::longValue).toArray();
                CheckLightJobsOperation op = new CheckLightJobsOperation(executionIds);
                InvocationFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)op, (Address)entry.getKey()).invoke();
                future.whenComplete((r, t) -> {
                    if (ExceptionUtil.isOrHasCause(t, TargetNotMemberException.class)) {
                        r = executionIds;
                    } else if (t != null) {
                        this.logger.warning("Failed to check light job state with coordinator " + String.valueOf(en.getKey()) + ": " + String.valueOf(t), (Throwable)t);
                        return;
                    }
                    assert (r != null);
                    for (long executionId : r) {
                        ExecutionContext execCtx = (ExecutionContext)this.executionContexts.get(executionId);
                        if (execCtx == null) continue;
                        this.logger.fine("Terminating light job " + com.hazelcast.jet.Util.idToString(executionId) + " because the coordinator doesn't know it");
                        this.terminateExecution0(execCtx, TerminationMode.CANCEL_FORCEFUL, new CancellationException());
                    }
                });
            }
            this.failedJobs.values().removeIf(expiryTime -> expiryTime < now);
        }
        catch (Throwable e) {
            this.logger.severe("Failed to query live light executions: " + String.valueOf(e), e);
        }
    }

    public CompletableFuture<Void> terminateExecution(long jobId, long executionId, Address callerAddress, TerminationMode mode) {
        Address masterAddress;
        this.failIfNotRunning();
        ExecutionContext executionContext = (ExecutionContext)this.executionContexts.get(executionId);
        if (executionContext == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (!executionContext.isLightJob() && !callerAddress.equals(masterAddress = this.nodeEngine.getMasterAddress())) {
            this.failIfNotRunning();
            throw new IllegalStateException(String.format("Caller %s cannot do '%s' for terminateExecution: it is not the master, the master is %s", callerAddress, Util.jobIdAndExecutionId(jobId, executionId), masterAddress));
        }
        Address coordinator = executionContext.coordinator();
        if (coordinator == null) {
            assert (executionContext.isLightJob()) : "null coordinator for non-light job";
        } else if (!coordinator.equals(callerAddress)) {
            throw new IllegalStateException(String.format("%s, originally from coordinator %s, cannot do 'terminateExecution' by coordinator %s and execution %s", executionContext.jobNameAndExecutionId(), coordinator, callerAddress, com.hazelcast.jet.Util.idToString(executionId)));
        }
        RuntimeException cause = mode == null ? new CancellationException() : new JobTerminateRequestedException(mode);
        return this.terminateExecution0(executionContext, mode, cause);
    }

    public CompletableFuture<Void> terminateExecution0(ExecutionContext executionContext, TerminationMode mode, Throwable cause) {
        if (!executionContext.terminateExecution(mode, cause)) {
            this.logger.fine(executionContext.jobNameAndExecutionId() + " calling completeExecution because execution terminated before it started");
            return this.completeExecution(executionContext, cause);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void waitAllExecutionsTerminated() {
        for (ExecutionContext ctx : this.executionContexts.values()) {
            try {
                ctx.getExecutionFuture().join();
            }
            catch (Throwable throwable) {}
        }
    }

    private static class JobMetricsCollector
    implements MetricsCollector,
    AutoCloseable {
        private final MetricsCompressor compressor;
        private final ILogger logger;
        private final UnaryOperator<MetricDescriptor> addPrefixFn;

        JobMetricsCollector(@Nonnull Member member, @Nonnull ILogger logger) {
            Objects.requireNonNull(member, "member");
            this.logger = Objects.requireNonNull(logger, "logger");
            this.addPrefixFn = JobMetricsUtil.addMemberPrefixFn(member);
            this.compressor = new MetricsCompressor();
        }

        @Override
        public void collectLong(MetricDescriptor descriptor, long value) {
            this.compressor.addLong((MetricDescriptor)this.addPrefixFn.apply(descriptor), value);
        }

        @Override
        public void collectDouble(MetricDescriptor descriptor, double value) {
            this.compressor.addDouble((MetricDescriptor)this.addPrefixFn.apply(descriptor), value);
        }

        @Override
        public void collectException(MetricDescriptor descriptor, Exception e) {
            this.logger.warning("Exception when rendering job metrics: " + String.valueOf(e), e);
        }

        @Override
        public void collectNoValue(MetricDescriptor descriptor) {
        }

        @Nonnull
        public RawJobMetrics getMetrics() {
            return RawJobMetrics.of(this.compressor.getBlobAndClose());
        }

        @Override
        public void close() {
            this.compressor.close();
        }
    }
}

