/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.ProcessorClassLoaderTLHolder;
import com.hazelcast.jet.impl.deployment.ChildFirstClassLoader;
import com.hazelcast.jet.impl.deployment.JetClassLoader;
import com.hazelcast.jet.impl.deployment.JetDelegatingClassLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.ClusterProperty;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class JobClassLoaderService {
    private final ConcurrentHashMap<Long, JobClassLoaders> classLoaders = new ConcurrentHashMap();
    private final ILogger logger;
    private final NodeEngine nodeEngine;
    private final JobRepository jobRepository;

    public JobClassLoaderService(@Nonnull NodeEngine nodeEngine, @Nonnull JobRepository jobRepository) {
        this.logger = nodeEngine.getLogger(this.getClass());
        this.nodeEngine = nodeEngine;
        this.jobRepository = jobRepository;
    }

    public Map<Long, JobClassLoaders> getClassLoaders() {
        return Collections.unmodifiableMap(this.classLoaders);
    }

    public ClassLoader getOrCreateClassLoader(JobConfig config, long jobId, JobPhase phase) {
        JetConfig jetConfig = this.nodeEngine.getConfig().getJetConfig();
        JobClassLoaders jobClassLoaders = this.classLoaders.compute(jobId, (k, current) -> {
            JobClassLoaders result = current;
            if (current == null) {
                result = this.createJobClassLoaders(config, jobId, jetConfig);
            }
            result.recordPhase(phase);
            return result;
        });
        jobClassLoaders.recordPhase(phase);
        return jobClassLoaders.jobClassLoader();
    }

    private JobClassLoaders createJobClassLoaders(JobConfig config, long jobId, JetConfig jetConfig) {
        return AccessController.doPrivileged(() -> {
            this.logger.fine("Creating job classLoader for job " + Util.idToString(jobId));
            ClassLoader parent = this.parentClassLoader(config);
            JetDelegatingClassLoader jobClassLoader = !jetConfig.isResourceUploadEnabled() ? new JetDelegatingClassLoader(parent) : new JetClassLoader(this.nodeEngine.getLogger(JetClassLoader.class), parent, config.getName(), jobId, this.jobRepository);
            Map<String, ClassLoader> processorCls = this.createProcessorClassLoaders(jobId, config, jobClassLoader);
            return new JobClassLoaders(jobClassLoader, processorCls);
        });
    }

    private ClassLoader parentClassLoader(JobConfig config) {
        return config != null && config.getClassLoaderFactory() != null ? config.getClassLoaderFactory().getJobClassLoader() : this.nodeEngine.getConfigClassLoader();
    }

    private Map<String, ClassLoader> createProcessorClassLoaders(long jobId, JobConfig jobConfig, ClassLoader parent) {
        this.logger.fine("Create processor classloader map for job " + Util.idToString(jobId));
        String customLibDir = this.nodeEngine.getProperties().getString(ClusterProperty.PROCESSOR_CUSTOM_LIB_DIR);
        HashMap<String, ChildFirstClassLoader> classLoaderMap = new HashMap<String, ChildFirstClassLoader>();
        for (Map.Entry<String, List<String>> entry : jobConfig.getCustomClassPaths().entrySet()) {
            List<URL> list = entry.getValue().stream().map(jar -> {
                try {
                    assert (Files.exists(Paths.get(customLibDir, new String[0]), new LinkOption[0])) : "Directory " + customLibDir + " does not exist";
                    Path path = Paths.get(customLibDir, jar);
                    return path.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new JetException(e);
                }
            }).collect(Collectors.toList());
            URL[] urls = list.toArray(new URL[0]);
            classLoaderMap.put(entry.getKey(), new ChildFirstClassLoader(urls, parent));
        }
        return Collections.unmodifiableMap(classLoaderMap);
    }

    public void prepareProcessorClassLoaders(long jobId) {
        ProcessorClassLoaderTLHolder.putAll(this.getProcessorClassLoaders(jobId));
    }

    private Map<String, ClassLoader> getProcessorClassLoaders(long jobId) {
        return this.classLoaders.get(jobId).processorCls();
    }

    public void clearProcessorClassLoaders() {
        ProcessorClassLoaderTLHolder.remove();
    }

    public ClassLoader getProcessorClassLoader(long jobId, String vertexName) {
        JobClassLoaders jobClassLoaders = this.classLoaders.get(jobId);
        if (jobClassLoaders != null) {
            ClassLoader classLoader = jobClassLoaders.processorCl(vertexName);
            return classLoader == null ? this.getClassLoader(jobId) : classLoader;
        }
        throw new HazelcastException("JobClassLoaders for jobId=" + Util.idToString(jobId) + " requested, but it does not exists");
    }

    public void tryRemoveClassloadersForJob(long jobId, JobPhase phase) {
        this.logger.finest("Try remove classloaders for jobId=%s, phase=%s", Util.idToString(jobId), (Object)phase);
        this.classLoaders.compute(jobId, (k, jobClassLoaders) -> {
            if (jobClassLoaders == null) {
                this.logger.warning("JobClassLoaders for jobId=" + Util.idToString(jobId) + " already removed");
                return null;
            }
            int phaseCount = jobClassLoaders.removePhase(phase);
            if (phaseCount == 0) {
                this.logger.finest("JobClassLoaders phaseCount = 0, removing classloaders for jobId=%s", Util.idToString(jobId));
                Map<String, ClassLoader> processorCls = jobClassLoaders.processorCls();
                if (processorCls != null) {
                    for (ClassLoader cl : processorCls.values()) {
                        try {
                            ((ChildFirstClassLoader)cl).close();
                        }
                        catch (IOException e) {
                            this.logger.warning("Exception when closing processor classloader", e);
                        }
                    }
                }
                JetDelegatingClassLoader jobClassLoader = jobClassLoaders.jobClassLoader();
                jobClassLoader.shutdown();
                this.logger.fine("Finish JobClassLoaders phaseCount = 0, removing classloaders for jobId=%s", Util.idToString(jobId));
                return null;
            }
            this.logger.finest("JobClassLoaders refCount > 0, NOT removing classloaders for jobId=%s", Util.idToString(jobId));
            return jobClassLoaders;
        });
    }

    public JetDelegatingClassLoader getClassLoader(long jobId) {
        JobClassLoaders jobClassLoaders = this.classLoaders.get(jobId);
        return jobClassLoaders == null ? null : jobClassLoaders.jobClassLoader;
    }

    public static enum JobPhase {
        COORDINATOR,
        EXECUTION;

    }

    private static class JobClassLoaders {
        private final JetDelegatingClassLoader jobClassLoader;
        private final Map<String, ClassLoader> processorCls;
        private final EnumSet<JobPhase> phases = EnumSet.noneOf(JobPhase.class);

        JobClassLoaders(@Nonnull JetDelegatingClassLoader jobClassLoader, @Nonnull Map<String, ClassLoader> processorCls) {
            this.jobClassLoader = jobClassLoader;
            this.processorCls = Collections.unmodifiableMap(processorCls);
        }

        public JetDelegatingClassLoader jobClassLoader() {
            return this.jobClassLoader;
        }

        public Map<String, ClassLoader> processorCls() {
            return this.processorCls;
        }

        public ClassLoader processorCl(String key) {
            return this.processorCls.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recordPhase(JobPhase phase) {
            JobClassLoaders jobClassLoaders = this;
            synchronized (jobClassLoaders) {
                this.phases.add(phase);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int removePhase(JobPhase phase) {
            JobClassLoaders jobClassLoaders = this;
            synchronized (jobClassLoaders) {
                this.phases.remove((Object)phase);
                return this.phases.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            JobClassLoaders jobClassLoaders = this;
            synchronized (jobClassLoaders) {
                return "JobClassLoaders{phases=" + String.valueOf(this.phases) + "}";
            }
        }
    }
}

