/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.LocalMemberResetException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.JobStatusListener;
import com.hazelcast.jet.config.DeltaJobConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.exception.CancellationByUserException;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.NonCompletableFuture;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public abstract class AbstractJobProxy<C, M>
implements Job {
    private static final long TERMINATE_RETRY_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final String NOT_LOADED = new String("NOT_LOADED");
    protected final M lightJobCoordinator;
    protected final Subject subject;
    protected final ILogger logger;
    private final long jobId;
    private volatile String name = NOT_LOADED;
    private final C container;
    private final NonCompletableFuture future;
    private final AtomicBoolean joinedJob = new AtomicBoolean();
    private final BiConsumer<Void, Throwable> joinJobCallback;
    private final Supplier<Long> submissionTimeSup = Util.memoizeConcurrent(this::doGetJobSubmissionTime);
    private final boolean submittingInstance;

    AbstractJobProxy(C container, long jobId, M lightJobCoordinator) {
        this.jobId = jobId;
        this.container = container;
        this.lightJobCoordinator = lightJobCoordinator;
        this.logger = this.loggingService().getLogger(AbstractJobProxy.class);
        this.future = new NonCompletableFuture();
        this.joinJobCallback = new JoinJobCallback();
        this.submittingInstance = false;
        this.subject = null;
    }

    AbstractJobProxy(C container, long jobId, boolean isLightJob, @Nonnull Object jobDefinition, @Nonnull JobConfig config, @Nullable Subject subject) {
        this.jobId = jobId;
        this.container = container;
        this.lightJobCoordinator = isLightJob ? this.findLightJobCoordinator() : null;
        this.logger = this.loggingService().getLogger(Job.class);
        this.submittingInstance = true;
        this.subject = subject;
        try {
            NonCompletableFuture submitFuture = this.doSubmitJob(jobDefinition, config);
            this.joinedJob.set(true);
            if (isLightJob) {
                this.future = submitFuture;
                this.joinJobCallback = null;
            } else {
                submitFuture.join();
                this.future = new NonCompletableFuture();
                this.joinJobCallback = new JoinJobCallback();
                this.doInvokeJoinJob();
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public long getId() {
        return this.jobId;
    }

    @Override
    @Nullable
    public String getName() {
        if (this.isLightJob()) {
            return null;
        }
        if (this.name == NOT_LOADED) {
            return this.getConfig().getName();
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public JobConfig getConfig() {
        AbstractJobProxy abstractJobProxy = this;
        synchronized (abstractJobProxy) {
            JobConfig config = this.doGetJobConfig();
            if (config == null) {
                throw new NullPointerException("Supplier returned null");
            }
            this.name = config.getName();
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobConfig updateConfig(@Nonnull DeltaJobConfig deltaConfig) {
        this.checkNotLightJob("updateConfig");
        AbstractJobProxy abstractJobProxy = this;
        synchronized (abstractJobProxy) {
            JobConfig config = this.doUpdateJobConfig(deltaConfig);
            this.name = config.getName();
            return config;
        }
    }

    private String idAndName() {
        return this.getIdString() + " (name " + (String)(this.name != NOT_LOADED ? "'" + (this.name != null ? this.name : "") + "'" : "??") + ")";
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> getFuture() {
        if (this.joinedJob.compareAndSet(false, true)) {
            this.doInvokeJoinJob();
        }
        return this.future;
    }

    @Override
    @Nonnull
    public final JobStatus getStatus() {
        if (this.isLightJob()) {
            CompletableFuture<Void> f = this.getFuture();
            if (!f.isDone()) {
                return JobStatus.RUNNING;
            }
            return f.isCompletedExceptionally() ? JobStatus.FAILED : JobStatus.COMPLETED;
        }
        return this.getStatus0();
    }

    protected abstract JobStatus getStatus0();

    @Override
    public final boolean isUserCancelled() {
        if (this.isLightJob()) {
            CompletableFuture<Void> f = this.getFuture();
            if (!f.isDone()) {
                throw new IllegalStateException("Job not finished");
            }
            if (!f.isCancelled()) {
                return false;
            }
            try {
                f.getNow(null);
                throw new AssertionError((Object)"Future changed state");
            }
            catch (CancellationByUserException byUser) {
                return true;
            }
            catch (CancellationException e) {
                return false;
            }
        }
        return this.isUserCancelled0();
    }

    protected abstract boolean isUserCancelled0();

    @Override
    public long getSubmissionTime() {
        return this.submissionTimeSup.get();
    }

    @Override
    public void cancel() {
        this.terminate(TerminationMode.CANCEL_FORCEFUL);
    }

    @Override
    public void restart() {
        this.terminate(TerminationMode.RESTART_GRACEFUL);
    }

    public void restart(boolean graceful) {
        this.terminate(graceful ? TerminationMode.RESTART_GRACEFUL : TerminationMode.RESTART_FORCEFUL);
    }

    @Override
    public void suspend() {
        this.terminate(TerminationMode.SUSPEND_GRACEFUL);
    }

    @Override
    public JobStateSnapshot exportSnapshot(String name) {
        return this.doExportSnapshot(name, false);
    }

    @Override
    public JobStateSnapshot cancelAndExportSnapshot(String name) {
        return this.doExportSnapshot(name, true);
    }

    private void terminate(TerminationMode mode) {
        if (mode != TerminationMode.CANCEL_FORCEFUL) {
            this.checkNotLightJob(mode.toString());
        }
        this.logger.fine("Sending " + String.valueOf((Object)mode) + " request for job " + this.idAndName());
        block4: while (true) {
            try {
                while (true) {
                    try {
                        this.invokeTerminateJob(mode).get();
                        break block4;
                    }
                    catch (ExecutionException e) {
                        if (!(e.getCause() instanceof JobNotFoundException) || !this.isLightJob()) {
                            throw e;
                        }
                        if (this.submittingInstance) {
                            assert (this.joinedJob.get()) : "not joined";
                            if (this.getFuture().isDone()) {
                                return;
                            }
                        } else {
                            return;
                        }
                        LockSupport.parkNanos(TERMINATE_RETRY_DELAY_NS);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (!this.isRestartable(e)) {
                    throw ExceptionUtil.rethrow(e);
                }
                this.logger.fine("Re-sending " + String.valueOf((Object)mode) + " request for job " + this.idAndName());
                continue;
            }
            break;
        }
    }

    @Override
    public UUID addStatusListener(@Nonnull JobStatusListener listener) {
        try {
            return this.doAddStatusListener(listener);
        }
        catch (JobNotFoundException ignored) {
            throw AbstractJobProxy.cannotAddStatusListener(this.future.isCompletedExceptionally() ? JobStatus.FAILED : JobStatus.COMPLETED);
        }
    }

    public String toString() {
        return "Job{id=" + this.getIdString() + ", name=" + this.getName() + "}";
    }

    @Override
    public boolean isLightJob() {
        return this.lightJobCoordinator != null;
    }

    protected abstract M findLightJobCoordinator();

    protected abstract CompletableFuture<Void> invokeSubmitJob(Object var1, JobConfig var2);

    protected abstract CompletableFuture<Void> invokeJoinJob();

    protected abstract CompletableFuture<Void> invokeTerminateJob(TerminationMode var1);

    protected abstract long doGetJobSubmissionTime();

    protected abstract JobConfig doGetJobConfig();

    protected abstract JobConfig doUpdateJobConfig(@Nonnull DeltaJobConfig var1);

    protected abstract JobStateSnapshot doExportSnapshot(String var1, boolean var2);

    protected abstract UUID doAddStatusListener(@Nonnull JobStatusListener var1);

    protected M coordinatorId() {
        return this.lightJobCoordinator != null ? this.lightJobCoordinator : this.masterId();
    }

    @Nonnull
    protected abstract M masterId();

    protected abstract SerializationService serializationService();

    protected abstract LoggingService loggingService();

    protected abstract boolean isRunning();

    protected C container() {
        return this.container;
    }

    private NonCompletableFuture doSubmitJob(Object jobDefinition, JobConfig config) {
        NonCompletableFuture submitFuture = new NonCompletableFuture();
        SubmitJobCallback callback = new SubmitJobCallback(submitFuture, jobDefinition, config);
        this.invokeSubmitJob(jobDefinition, config).whenCompleteAsync((BiConsumer)callback);
        return submitFuture;
    }

    private boolean isRestartable(Throwable t) {
        if (this.isLightJob()) {
            return false;
        }
        return t instanceof MemberLeftException || t instanceof TargetDisconnectedException || t instanceof TargetNotMemberException || t instanceof HazelcastInstanceNotActiveException && this.isRunning();
    }

    private void doInvokeJoinJob() {
        ((CompletableFuture)this.invokeJoinJob().whenComplete((BiConsumer)com.hazelcast.internal.util.ExceptionUtil.withTryCatch(this.logger, (r, t) -> {
            if (this.isLightJob() && t instanceof JobNotFoundException) {
                throw new IllegalStateException("job already completed");
            }
        }))).whenCompleteAsync(com.hazelcast.internal.util.ExceptionUtil.withTryCatch(this.logger, this.joinJobCallback));
    }

    protected void checkNotLightJob(String msg) {
        if (this.isLightJob()) {
            throw new UnsupportedOperationException("not supported for light jobs: " + msg);
        }
    }

    public static IllegalStateException cannotAddStatusListener(JobStatus status) {
        return new IllegalStateException("Cannot add status listener to a " + String.valueOf((Object)status) + " job");
    }

    private class JoinJobCallback
    extends CallbackBase {
        JoinJobCallback() {
            super(AbstractJobProxy.this.future);
        }

        @Override
        protected void retryActionInt(Throwable t) {
            AbstractJobProxy.this.logger.fine("Rejoining to job " + AbstractJobProxy.this.idAndName() + " after " + t.getClass().getSimpleName(), t);
            AbstractJobProxy.this.doInvokeJoinJob();
        }

        @Override
        protected String operationName() {
            return "Join";
        }
    }

    private class SubmitJobCallback
    extends CallbackBase {
        private final Object jobDefinition;
        private final JobConfig config;

        SubmitJobCallback(NonCompletableFuture future, Object jobDefinition, JobConfig config) {
            super(future);
            this.jobDefinition = jobDefinition;
            this.config = config;
        }

        @Override
        protected void retryActionInt(Throwable t) {
            AbstractJobProxy.this.logger.fine("Resubmitting job " + AbstractJobProxy.this.idAndName() + " after " + t.getClass().getSimpleName());
            AbstractJobProxy.this.invokeSubmitJob(this.jobDefinition, this.config).whenCompleteAsync((BiConsumer)this);
        }

        @Override
        protected String operationName() {
            return "Submit";
        }
    }

    private abstract class CallbackBase
    implements BiConsumer<Void, Throwable> {
        private final NonCompletableFuture future;

        protected CallbackBase(NonCompletableFuture future) {
            this.future = future;
        }

        @Override
        public final void accept(Void aVoid, Throwable t) {
            if (t != null) {
                Throwable ex = ExceptionUtil.peel(t);
                if (ex instanceof LocalMemberResetException) {
                    String msg = this.operationName() + " failed for job " + AbstractJobProxy.this.idAndName() + " because the cluster is performing split-brain merge";
                    AbstractJobProxy.this.logger.warning(msg, ex);
                    this.future.internalCompleteExceptionally(new CancellationException(msg));
                } else if (!AbstractJobProxy.this.isRestartable(ex)) {
                    this.future.internalCompleteExceptionally(ex);
                } else {
                    try {
                        this.retryAction(ex);
                    }
                    catch (Exception e) {
                        this.future.internalCompleteExceptionally(ExceptionUtil.peel(e));
                    }
                }
            } else {
                this.future.internalComplete();
            }
        }

        private void retryAction(Throwable t) {
            try {
                AbstractJobProxy.this.masterId();
            }
            catch (IllegalStateException e) {
                String msg = this.operationName() + " failed for job " + AbstractJobProxy.this.idAndName() + " because the cluster is performing split-brain merge and the coordinator is not known";
                AbstractJobProxy.this.logger.warning(msg, t);
                this.future.internalCompleteExceptionally(new CancellationException(msg));
                return;
            }
            this.retryActionInt(t);
        }

        protected abstract void retryActionInt(Throwable var1);

        protected abstract String operationName();
    }
}

