/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public final class DirectoryLock {
    public static final String FILE_NAME = "lock";
    private final File dir;
    private final FileChannel channel;
    private final FileLock lock;
    private final ILogger logger;

    private DirectoryLock(File dir, FileChannel channel, FileLock lock, ILogger logger) {
        this.dir = dir;
        this.channel = channel;
        this.lock = lock;
        this.logger = logger;
    }

    public File getDir() {
        return this.dir;
    }

    FileLock getLock() {
        return this.lock;
    }

    public void release() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Releasing lock on " + this.lockFile().getAbsolutePath());
        }
        try {
            this.lock.release();
        }
        catch (ClosedChannelException e) {
            EmptyStatement.ignore(e);
        }
        catch (IOException e) {
            this.logger.severe("Problem while releasing the lock on " + String.valueOf(this.lockFile()), e);
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            this.logger.severe("Problem while closing the channel " + String.valueOf(this.lockFile()), e);
        }
    }

    private File lockFile() {
        return new File(this.dir, FILE_NAME);
    }

    public static DirectoryLock lockForDirectory(File dir, ILogger logger) {
        File lockFile = new File(dir, FILE_NAME);
        FileChannel channel = DirectoryLock.openChannel(lockFile);
        FileLock lock = DirectoryLock.acquireLock(lockFile, channel);
        if (logger.isFineEnabled()) {
            logger.fine("Acquired lock on " + lockFile.getAbsolutePath());
        }
        return new DirectoryLock(dir, channel, lock, logger);
    }

    private static FileChannel openChannel(File lockFile) {
        try {
            return new RandomAccessFile(lockFile, "rw").getChannel();
        }
        catch (IOException e) {
            throw new HazelcastException("Cannot create lock file " + lockFile.getAbsolutePath(), e);
        }
    }

    private static FileLock acquireLock(File lockFile, FileChannel channel) {
        FileLock fileLock = null;
        try {
            fileLock = channel.tryLock();
            if (fileLock == null) {
                throw new HazelcastException("Cannot acquire lock on " + lockFile.getAbsolutePath() + ". Directory is already being used by another member.");
            }
            FileLock fileLock2 = fileLock;
            return fileLock2;
        }
        catch (OverlappingFileLockException e) {
            throw new HazelcastException("Cannot acquire lock on " + lockFile.getAbsolutePath() + ". Directory is already being used by another member.", e);
        }
        catch (IOException e) {
            throw new HazelcastException("Unknown failure while acquiring lock on " + lockFile.getAbsolutePath(), e);
        }
        finally {
            if (fileLock == null) {
                IOUtil.closeResource(channel);
            }
        }
    }
}

