/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogMessagePrologueFunction;
import com.hazelcast.internal.tstore.hybridlog.impl.PageInfoFormatterFunction;
import com.hazelcast.internal.tstore.hybridlog.impl.PageMetadata;
import com.hazelcast.internal.tstore.hybridlog.impl.PageState;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;

class PageStateMachine {
    private static final Runnable NOP_UNDO_ACTION = () -> {};
    private final ILogger logger = Logger.getLogger(PageStateMachine.class);
    private final HybridLogMessagePrologueFunction logPrologueFn;
    private final PageInfoFormatterFunction pageInfoFormatterFn;
    private final boolean logPinTransitions = Boolean.getBoolean("hazelcast.tstore.hlog.log.pin.transitions");
    private final boolean fineLogLevelEnabled;

    PageStateMachine(HybridLogMessagePrologueFunction logPrologueFn) {
        this(logPrologueFn, (page, pageMetadata) -> Integer.toString(page));
    }

    PageStateMachine(HybridLogMessagePrologueFunction logPrologueFn, PageInfoFormatterFunction pageInfoFormatterFunction) {
        this.logPrologueFn = logPrologueFn;
        this.pageInfoFormatterFn = pageInfoFormatterFunction;
        this.fineLogLevelEnabled = this.logger.isFineEnabled();
    }

    boolean assign(int page, PageMetadata pageMetadata, Action prepareAction, Runnable undoAction) {
        if (!this.tryChangePageState(page, pageMetadata, PageState.PREPARING)) {
            return false;
        }
        try {
            if (!prepareAction.run()) {
                this.undo(pageMetadata, PageState.NOT_BACKED, undoAction);
                return false;
            }
            this.changePageState(page, pageMetadata, PageState.PREPARING, PageState.READY);
        }
        catch (Exception ex) {
            this.undo(pageMetadata, PageState.NOT_BACKED, undoAction);
            throw ex;
        }
        return true;
    }

    boolean activate(PageMetadata pageMetadata) {
        int page = pageMetadata.page();
        if (!this.tryChangePageState(page, pageMetadata, PageState.ACTIVATING)) {
            return false;
        }
        try {
            this.changePageState(page, pageMetadata, PageState.ACTIVATING, PageState.ACTIVE);
        }
        catch (Exception ex) {
            this.undo(pageMetadata, PageState.READY, NOP_UNDO_ACTION);
            throw ex;
        }
        return true;
    }

    boolean readonly(PageMetadata pageMetadata) {
        return this.tryChangePageState(pageMetadata.page(), pageMetadata, PageState.READONLY, true);
    }

    void flush(PageMetadata pageMetadata) {
        this.changePageState(pageMetadata.page(), pageMetadata, PageState.READONLY, PageState.FLUSHING);
    }

    void flushed(PageMetadata pageMetadata) {
        this.changePageState(pageMetadata.page(), pageMetadata, PageState.FLUSHING, PageState.FLUSHED);
    }

    boolean releasable(PageMetadata pageMetadata) {
        return this.releasable(pageMetadata, PageStateTransitionObserver.NOP_TRANSITION_OBSERVER);
    }

    boolean releasable(PageMetadata pageMetadata, PageStateTransitionObserver transitionObserver) {
        PageState targetState;
        PageState sourceState;
        PageState targetSyncState;
        int page = pageMetadata.page();
        do {
            sourceState = pageMetadata.state();
            switch (sourceState) {
                case FLUSHED: {
                    targetSyncState = PageState.MARKING_RELEASABLE;
                    targetState = PageState.RELEASABLE;
                    break;
                }
                case PINNED_FLUSHED: {
                    targetSyncState = PageState.PINNED_MARKING_DETACHABLE;
                    targetState = PageState.PINNED_DETACHABLE;
                    break;
                }
                case DETACHED: {
                    targetSyncState = PageState.MARKING_RELEASABLE_DETACHED;
                    targetState = PageState.RELEASABLE_DETACHED;
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (!this.tryChangePageState(page, pageMetadata, targetSyncState, false, transitionObserver));
        try {
            this.changePageState(page, pageMetadata, targetSyncState, targetState, transitionObserver);
        }
        catch (Exception ex) {
            this.undo(pageMetadata, sourceState, NOP_UNDO_ACTION);
            throw ex;
        }
        return true;
    }

    boolean release(PageMetadata pageMetadata, Runnable releaseAction) {
        return this.release(pageMetadata, releaseAction, PageStateTransitionObserver.NOP_TRANSITION_OBSERVER);
    }

    boolean release(PageMetadata pageMetadata, Runnable releaseAction, PageStateTransitionObserver transitionObserver) {
        PageState targetState;
        PageState targetSyncState;
        int page = pageMetadata.page();
        do {
            PageState sourceState = pageMetadata.state();
            switch (sourceState) {
                case RELEASABLE: {
                    targetSyncState = PageState.RELEASING;
                    targetState = PageState.NOT_BACKED;
                    break;
                }
                case PINNED_DETACHABLE: {
                    targetSyncState = PageState.PINNED_DETACHING;
                    targetState = PageState.PINNED_DETACHED;
                    break;
                }
                case DETACHABLE: {
                    targetSyncState = PageState.DETACHING;
                    targetState = PageState.DETACHED;
                    break;
                }
                case RELEASABLE_DETACHED: {
                    targetSyncState = PageState.RELEASING_DETACHED;
                    targetState = PageState.NOT_BACKED;
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (!this.tryChangePageState(page, pageMetadata, targetSyncState, false, transitionObserver));
        try {
            releaseAction.run();
            this.changePageState(page, pageMetadata, targetSyncState, targetState, transitionObserver);
        }
        catch (Exception ex) {
            this.undo(pageMetadata, PageState.NOT_BACKED, NOP_UNDO_ACTION);
            throw ex;
        }
        return true;
    }

    PinSuccessState pinPageForUpdate(PageMetadata pageMetadata) {
        PageState currentPageState = pageMetadata.state();
        if (currentPageState == PageState.PINNED_FOR_UPDATE) {
            return PinSuccessState.STAY_PINNED;
        }
        return this.tryChangePageState(pageMetadata.page(), pageMetadata, PageState.PINNED_FOR_UPDATE) ? PinSuccessState.PINNED : PinSuccessState.UNSUCCESSFUL;
    }

    PinSuccessState pinPage(PageMetadata pageMetadata) {
        return this.pinPage(pageMetadata, PageStateTransitionObserver.NOP_TRANSITION_OBSERVER);
    }

    PinSuccessState pinPage(PageMetadata pageMetadata, PageStateTransitionObserver transitionObserver) {
        PageState pinVariantPageState;
        PageState currentPageState;
        int page = pageMetadata.page();
        do {
            currentPageState = pageMetadata.state();
            pinVariantPageState = currentPageState.pinVariantState();
        } while (currentPageState.isSyncState() || !currentPageState.isPinnedState() && pinVariantPageState != null && !this.tryChangePageState(page, pageMetadata, pinVariantPageState, transitionObserver));
        if (currentPageState.isPinnedState()) {
            return PinSuccessState.STAY_PINNED;
        }
        return pinVariantPageState != null ? PinSuccessState.PINNED : PinSuccessState.UNSUCCESSFUL;
    }

    boolean unpinPage(PageMetadata pageMetadata) {
        return this.unpinPage(pageMetadata, PageStateTransitionObserver.NOP_TRANSITION_OBSERVER);
    }

    boolean unpinPage(PageMetadata pageMetadata, PageStateTransitionObserver transitionObserver) {
        PageState pinVariantState;
        PageState currentPageState;
        int page = pageMetadata.page();
        do {
            currentPageState = pageMetadata.state();
            pinVariantState = currentPageState.pinVariantState();
        } while (currentPageState.isPinnedState() && pinVariantState != null && !this.tryChangePageState(page, pageMetadata, pinVariantState, transitionObserver));
        return !currentPageState.isPinnedState() || pinVariantState != null;
    }

    void demoteForUpdatePin(PageMetadata pageMetadata) {
        this.tryChangePageState(pageMetadata.page(), pageMetadata, PageState.PINNED_ACTIVE);
    }

    private void undo(PageMetadata pageMetadata, PageState fallbackState, Runnable undoAction) {
        undoAction.run();
        pageMetadata.forceSetState(fallbackState);
    }

    private void changePageState(int page, PageMetadata pageMetadata, PageState sourceState, PageState targetState) {
        this.changePageState(page, pageMetadata, sourceState, targetState, PageStateTransitionObserver.NOP_TRANSITION_OBSERVER);
    }

    private void changePageState(int page, PageMetadata pageMetadata, PageState sourceState, PageState targetState, PageStateTransitionObserver transitionObserver) {
        PageState currentState;
        boolean firstIteration = true;
        do {
            currentState = pageMetadata.state();
            sourceState = this.chooseTargetVariantState(currentState, sourceState);
            if (currentState.isSyncState() && currentState != sourceState) {
                if (!firstIteration) continue;
                firstIteration = false;
                Thread.yield();
                continue;
            }
            targetState = this.chooseTargetVariantState(currentState, targetState);
            PageState[] allowedPreviousStates = targetState.allowedPreviousStates();
            boolean validStateChange = false;
            for (int i = 0; i < allowedPreviousStates.length && !validStateChange; ++i) {
                validStateChange = currentState == allowedPreviousStates[i];
            }
            if (validStateChange) continue;
            this.throwOnInvalidStateChange(page, pageMetadata, currentState, targetState);
        } while (sourceState != currentState || !pageMetadata.casState(sourceState, targetState));
        this.logPageStateTransition(page, pageMetadata, currentState, targetState);
        transitionObserver.onTransition(currentState, targetState);
    }

    private boolean tryChangePageState(int page, PageMetadata pageMetadata, PageState targetState) {
        return this.tryChangePageState(page, pageMetadata, targetState, false, PageStateTransitionObserver.NOP_TRANSITION_OBSERVER);
    }

    private boolean tryChangePageState(int page, PageMetadata pageMetadata, PageState targetState, PageStateTransitionObserver transitionObserver) {
        return this.tryChangePageState(page, pageMetadata, targetState, false, transitionObserver);
    }

    private boolean tryChangePageState(int page, PageMetadata pageMetadata, PageState targetState, boolean followPinnedPath) {
        return this.tryChangePageState(page, pageMetadata, targetState, followPinnedPath, PageStateTransitionObserver.NOP_TRANSITION_OBSERVER);
    }

    private boolean tryChangePageState(int page, PageMetadata pageMetadata, PageState targetState, boolean followPinnedPath, PageStateTransitionObserver transitionObserver) {
        PageState currentState;
        boolean retry;
        do {
            if ((currentState = pageMetadata.state()).isPinnedState() && followPinnedPath && !targetState.isPinnedState() && targetState.pinVariantState() != null) {
                targetState = targetState.pinVariantState();
            }
            retry = false;
            if (currentState == targetState) {
                return false;
            }
            if (currentState.isSyncState()) {
                Thread.yield();
                retry = true;
                continue;
            }
            PageState[] allowedPreviousStates = targetState.allowedPreviousStates();
            boolean validStateChange = false;
            for (int i = 0; i < allowedPreviousStates.length && !validStateChange; ++i) {
                validStateChange = currentState == allowedPreviousStates[i];
            }
            if (validStateChange) continue;
            return false;
        } while (retry || !pageMetadata.casState(currentState, targetState));
        this.logPageStateTransition(page, pageMetadata, currentState, targetState);
        transitionObserver.onTransition(currentState, targetState);
        return true;
    }

    private PageState chooseTargetVariantState(PageState currentState, PageState targetState) {
        if (currentState.isPinnedState() && targetState.isPinnedState() || !currentState.isPinnedState() && !targetState.isPinnedState()) {
            return targetState;
        }
        return targetState.pinVariantState();
    }

    void throwOnInvalidStateChange(int page, PageMetadata pageMetadata, PageState currentState, PageState targetState) {
        throw new IllegalStateException(this.logPrologueFn.prologue() + " - State transition " + currentState.name() + " -> " + targetState.name() + " for " + this.pageInfoFormatterFn.formatPageInfo(page, pageMetadata) + " is not valid");
    }

    private void logPageStateTransition(int page, PageMetadata pageMetadata, PageState sourceState, PageState targetState) {
        if (this.fineLogLevelEnabled && (sourceState.isPinnedState() == targetState.isPinnedState() || this.logPinTransitions)) {
            this.logger.fine(this.logPrologueFn.prologue() + " - Changed state for " + this.pageInfoFormatterFn.formatPageInfo(page, pageMetadata) + ": " + String.valueOf((Object)sourceState) + " -> " + String.valueOf((Object)targetState));
        }
    }

    @FunctionalInterface
    static interface Action {
        public boolean run();
    }

    @FunctionalInterface
    static interface PageStateTransitionObserver {
        public static final PageStateTransitionObserver NOP_TRANSITION_OBSERVER = (oldState, newState) -> {};

        public void onTransition(PageState var1, PageState var2);
    }

    static enum PinSuccessState {
        PINNED(true),
        STAY_PINNED(true),
        UNSUCCESSFUL(false);

        private final boolean endsInPinnedPage;

        private PinSuccessState(boolean endsInPinnedPage) {
            this.endsInPinnedPage = endsInPinnedPage;
        }

        boolean endsInPinnedPage() {
            return this.endsInPinnedPage;
        }
    }
}

