/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;

public final class PageHeaderSupport {
    public static final int PAGE_HEADER_SIZE = 8;

    private PageHeaderSupport() {
    }

    static void resetHighestAllocatedOffset(long pageHeadAddress) {
        GlobalMemoryAccessorRegistry.AMEM.putIntVolatile(pageHeadAddress, 0);
    }

    static void updateHighestAllocation(long pageHeadAddress, int highestAllocatedOffset) {
        TStoreUtil.monotonicUpdateNativeInt(pageHeadAddress, highestAllocatedOffset);
    }

    static int readLastAllocatedOffset(long pageHeadAddress) {
        return GlobalMemoryAccessorRegistry.AMEM.getIntVolatile(pageHeadAddress);
    }
}

