/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.tstore.hybridlog.HybridLogDirectAccessor;

abstract class BaseHybridLogDirectAccessor
implements HybridLogDirectAccessor {
    protected static final int UNKNOWN_SLOT_SIZE = -1;

    BaseHybridLogDirectAccessor() {
    }

    @Override
    public int getInt(long slotLogicalAddress, long physicalAddress) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, 4);
        return GlobalMemoryAccessorRegistry.AMEM.getInt(physicalAddress);
    }

    @Override
    public void putInt(long slotLogicalAddress, long physicalAddress, int value) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, 4);
        GlobalMemoryAccessorRegistry.AMEM.putInt(physicalAddress, value);
    }

    @Override
    public long getLong(long slotLogicalAddress, long physicalAddress) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, 8);
        return GlobalMemoryAccessorRegistry.AMEM.getLong(physicalAddress);
    }

    @Override
    public void putLong(long slotLogicalAddress, long physicalAddress, long value) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, 8);
        GlobalMemoryAccessorRegistry.AMEM.putLong(physicalAddress, value);
    }

    @Override
    public long getLongVolatile(long slotLogicalAddress, long physicalAddress) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, 8);
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(physicalAddress);
    }

    @Override
    public void putLongVolatile(long slotLogicalAddress, long physicalAddress, long value) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, 8);
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(physicalAddress, value);
    }

    @Override
    public boolean casLong(long slotLogicalAddress, long physicalAddress, long expectedValue, long valueToSet) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, 8);
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(physicalAddress, expectedValue, valueToSet);
    }

    @Override
    public void copyFromByteArray(long slotLogicalAddress, long physicalAddress, byte[] source, int offset, int length) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, length);
        GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray(source, offset, physicalAddress, length);
    }

    @Override
    public void copyFromMemory(long slotLogicalAddress, long physicalAddress, long sourcePhysicalMemoryAddress, int length) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, 8);
        GlobalMemoryAccessorRegistry.AMEM.copyMemory(sourcePhysicalMemoryAddress, physicalAddress, length);
    }

    @Override
    public void verifyAccess(long slotLogicalAddress, long physicalAddress) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, 1);
    }

    @Override
    public void verifyAccess(long slotLogicalAddress, long physicalAddress, int bytesAccessed) {
        assert (this.verifyAccessInternal(slotLogicalAddress, physicalAddress, bytesAccessed, -1));
    }

    @Override
    public void verifyAccess(long slotLogicalAddress, long physicalAddress, int bytesAccessed, int slotSize) {
        this.verifyAccess(slotLogicalAddress, physicalAddress, bytesAccessed, slotSize);
    }

    protected abstract boolean verifyAccessInternal(long var1, long var3, int var5, int var6);
}

