/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.PinType;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.map.impl.record.TieredStoreRecord;

public class AddressRemapperImpl
implements AddressRemapper<TieredStoreRecord> {
    private final HybridLog hybridLog;
    private final Index index;
    private final boolean compaction;

    public AddressRemapperImpl(HybridLog hybridLog, Index index, boolean compaction) {
        this.hybridLog = hybridLog;
        this.index = index;
        this.compaction = compaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long remap(TieredStoreRecord record, long oldLogicalAddress, long newLogicalAddressCandidate, int threadIndex) {
        Data key = record.getKey();
        assert (this.hybridLog.isMutable(newLogicalAddressCandidate));
        boolean pinned = this.hybridLog.pinAddress(newLogicalAddressCandidate, PinType.WRITE);
        if (!pinned) {
            return -1L;
        }
        try {
            long result = this.index.remap(threadIndex, key, oldLogicalAddress, newLogicalAddressCandidate);
            assert (result != -2L);
            assert (result != 0L || this.compaction);
            if (result == -1L) {
                long l = -1L;
                return l;
            }
            assert (result >= 0L);
            long l = result;
            return l;
        }
        finally {
            this.hybridLog.unpinAddress(newLogicalAddressCandidate, PinType.WRITE);
        }
    }
}

