/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import com.hazelcast.internal.tstore.device.ImmutableOperation;
import com.hazelcast.internal.tstore.device.RecordAccessor;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import java.io.IOException;
import java.io.RandomAccessFile;

final class ReadRecordOperation
extends ImmutableOperation {
    private final long logicalAddress;
    private final RecordAccessor recordAccessor;

    ReadRecordOperation(int storeId, Device device, long logicalAddress, RecordAccessor recordAccessor) {
        super(device);
        this.logicalAddress = logicalAddress;
        this.recordAccessor = recordAccessor;
    }

    LocalStorageDevice getDevice() {
        return (LocalStorageDevice)this.device;
    }

    @Override
    public byte[] run(byte[] context) {
        return ReadRecordOperation.run0(this.getDevice(), context, this.logicalAddress, this.recordAccessor);
    }

    static byte[] run0(LocalStorageDevice device, byte[] context, long logicalAddress, RecordAccessor recordAccessor) {
        long filePos = device.getLogFileOffsetFromLogicalAddress(logicalAddress);
        HybridLogFileHandlePool handlePool = device.getHandlePool();
        int deviceId = device.getDeviceId();
        HybridLogFileHandleProvider hybridLogHandleProvider = device.getHandleProvider();
        int fileNo = device.segmentNoOf(logicalAddress);
        HybridLogFileHandle handle = handlePool.getHandle(deviceId, fileNo, hybridLogHandleProvider);
        byte[] buf = context;
        RandomAccessFile raf = handle.getRaf();
        String fileName = handle.getAbsoluteFileName();
        try {
            int recordLength;
            raf.seek(filePos);
            int bytes = raf.read(buf);
            filePos += (long)bytes;
            int headerSize = recordAccessor.headerSize();
            if (bytes < headerSize) {
                ReadRecordOperation.throwReadExpectationException(device, recordAccessor, logicalAddress, filePos, fileName, bytes, headerSize);
            }
            if ((recordLength = recordAccessor.length(buf)) == buf.length) {
                byte[] byArray = buf;
                return byArray;
            }
            byte[] record = new byte[recordLength];
            int copy = Math.min(buf.length, recordLength);
            System.arraycopy(buf, 0, record, 0, copy);
            if (buf.length >= recordLength) {
                byte[] byArray = record;
                return byArray;
            }
            int rest = recordLength - copy;
            bytes = raf.read(record, copy, rest);
            if (bytes < rest) {
                ReadRecordOperation.throwReadExpectationException(device, recordAccessor, logicalAddress, filePos, fileName, bytes, rest);
            }
            byte[] byArray = record;
            return byArray;
        }
        catch (IOException ioe) {
            throw new DeviceException(ioe);
        }
        finally {
            handlePool.releaseHandle(handle);
        }
    }

    private static void throwReadExpectationException(LocalStorageDevice device, RecordAccessor recordAccessor, long logicalAddress, long filePos, String fileName, int bytes, int headerSize) {
        String formattedSafeHeadAddress;
        String formattedLogicalAddress;
        String hybridLogId;
        Boolean isInMemory;
        long maxLogFileSizeInBytes = device.getMaxLogFileSizeInBytes();
        if (recordAccessor instanceof TieredStoreRecordAccessor) {
            TieredStoreRecordAccessor accessor = (TieredStoreRecordAccessor)((Object)recordAccessor);
            HybridLog hybridLog = accessor.getHybridLog();
            isInMemory = hybridLog.isInMemory(logicalAddress);
            if (hybridLog instanceof HybridLogImpl) {
                HybridLogImpl log = (HybridLogImpl)hybridLog;
                hybridLogId = log.getId();
                formattedLogicalAddress = log.prettyFormat(logicalAddress);
                formattedSafeHeadAddress = log.prettyFormat(log.safeHeadAddress());
            } else {
                hybridLogId = "N/A";
                formattedLogicalAddress = Long.toString(logicalAddress);
                formattedSafeHeadAddress = "N/A";
            }
        } else {
            hybridLogId = "N/A";
            formattedLogicalAddress = Long.toString(logicalAddress);
            formattedSafeHeadAddress = "N/A";
            isInMemory = null;
        }
        throw new DeviceException(String.format("Cannot read the expected amount of bytes from device `%s` from file '%s' at offset %d for logical address %s of `hlog:%s`. Expected to read at least %d bytes, but read only %d bytes. Address is in memory: %b, safeHeadAddress: %s, maxLogFileSizeInBytes: %d", device.deviceName(), fileName, filePos, formattedLogicalAddress, hybridLogId, headerSize, bytes, isInMemory, formattedSafeHeadAddress, maxLogFileSizeInBytes));
    }

    @Override
    public int getReadLength() {
        return -1;
    }

    @Override
    public String toString() {
        return "ReadRecordOperation(" + this.device.deviceName() + this.logicalAddress + ")";
    }
}

