/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.compaction.AbstractLogBasedCompactor;
import com.hazelcast.internal.tstore.compaction.CompactionManager;
import com.hazelcast.internal.tstore.compaction.IncrementalCompactor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImpl;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.spi.properties.HazelcastProperties;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LogBasedHLogCompactor
extends AbstractLogBasedCompactor
implements IncrementalCompactor {
    protected static final int EPOCH_REFRESH_MASK_SHIFT = 4;
    protected static final int EPOCH_REFRESH_MASK = 15;
    private final State state;
    private final Epoch epoch;
    private final CompactionManager compactionManager;

    public LogBasedHLogCompactor(CompactionManager compactionManager, TieredStoreRecordAccessor recordAccessor, HybridLogImpl hybridLog, Index index, State state, Epoch epoch, int segmentNo, HazelcastProperties properties) {
        super(recordAccessor, hybridLog, index, segmentNo, properties);
        this.compactionManager = compactionManager;
        this.state = state;
        this.epoch = epoch;
        this.onCompactionQueued();
    }

    @Override
    public void compact(boolean timeOut) {
        Throwable throwable = null;
        long startCompactionNanos = System.nanoTime();
        this.onCompactionStart();
        long startSN = this.compactionManager.addActiveCompactor(this);
        try {
            this.threadIndex = this.epoch.register();
            this.state.register(this.threadIndex);
            this.assertCompactionDoesNotHappenInMemoryRegion();
            int counter = 0;
            while (this.logIterator.hasNext()) {
                this.failIfInterrupted();
                this.compact((TieredStoreRecord)this.logIterator.next());
                if ((++counter & 0xF) != 0) continue;
                this.refreshEpochAndState();
            }
            this.compactionManager.addFinishedCompactor(this);
        }
        catch (Throwable ex) {
            throwable = ex;
            this.deregister();
            throw ex;
        }
        finally {
            this.compactionManager.removeActiveCompactor(startSN);
            this.compactionManager.truncateSegmentsSafely();
            this.state.unregister(this.threadIndex);
            this.epoch.unregister(this.threadIndex);
            this.logIterator.close();
            this.deregister();
            this.metrics.addCompactionDuration(System.nanoTime() - startCompactionNanos);
            if (throwable != null) {
                this.onCompactionFinish(throwable);
            } else {
                this.onCompactionFinish(null);
            }
        }
    }

    @Override
    public void doTriggerSegmentsDeletion() {
        this.epoch.bump(this.threadIndex, (threadIdx, actionEpoch) -> this.device.truncateAsync(this.segmentNo));
    }

    @Override
    protected void refreshEpochAndState() {
        this.epoch.refresh(this.threadIndex);
        this.state.refresh(this.threadIndex);
    }
}

