/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.cluster.impl.MemberHandshake;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.SendMemberHandshakeTask;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.internal.server.tcp.TcpServerConnectionManager;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;

public final class TcpServerControl {
    private final TcpServerConnectionManager connectionManager;
    private final ServerContext serverContext;
    private final ILogger logger;
    private final boolean unifiedEndpointManager;
    private final Set<ProtocolType> supportedProtocolTypes;
    private final int expectedPlaneCount;

    public TcpServerControl(TcpServerConnectionManager connectionManager, ServerContext serverContext, ILogger logger, Set<ProtocolType> supportedProtocolTypes) {
        this.connectionManager = connectionManager;
        this.serverContext = serverContext;
        this.logger = logger;
        this.supportedProtocolTypes = supportedProtocolTypes;
        this.unifiedEndpointManager = connectionManager.getEndpointQualifier() == null;
        this.expectedPlaneCount = serverContext.properties().getInteger(ClusterProperty.CHANNEL_COUNT);
    }

    public void process(Packet packet) {
        MemberHandshake handshake = (MemberHandshake)this.serverContext.getSerializationService().toObject(packet);
        TcpServerConnection connection = (TcpServerConnection)packet.getConn();
        if (!connection.setHandshake()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection " + String.valueOf(connection) + " handshake is already completed, ignoring incoming " + String.valueOf(handshake));
            }
            return;
        }
        if (handshake.getPlaneCount() != this.expectedPlaneCount) {
            connection.close("The connection handshake has incorrect number of planes. Expected " + this.expectedPlaneCount + " found " + handshake.getPlaneCount(), null);
            return;
        }
        connection.setPlaneIndex(handshake.getPlaneIndex());
        this.process(connection, handshake);
    }

    private synchronized void process(TcpServerConnection connection, MemberHandshake handshake) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Handshake " + String.valueOf(connection) + ", complete message is " + String.valueOf(handshake));
        }
        Map<ProtocolType, Collection<Address>> remoteAddressesPerProtocolType = handshake.getLocalAddresses();
        ArrayList<Address> allAliases = new ArrayList<Address>();
        if (this.supportedProtocolTypes.contains((Object)ProtocolType.MEMBER)) {
            Collection<Address> collection;
            Collection<Address> memberAddresses = remoteAddressesPerProtocolType.remove((Object)ProtocolType.MEMBER);
            if (memberAddresses != null) {
                allAliases.addAll(memberAddresses);
            }
            if (!connection.isAcceptorSide() && (collection = remoteAddressesPerProtocolType.remove((Object)ProtocolType.WAN)) != null) {
                allAliases.addAll(collection);
            }
        }
        for (Map.Entry entry : remoteAddressesPerProtocolType.entrySet()) {
            if (!this.supportedProtocolTypes.contains(entry.getKey())) continue;
            allAliases.addAll((Collection)entry.getValue());
        }
        assert (this.connectionManager.getEndpointQualifier() != EndpointQualifier.MEMBER || connection.getConnectionType().equals("MEMBER")) : "When handling MEMBER connections, connection type must be already set";
        boolean isMemberConnection = connection.getConnectionType().equals("MEMBER") && (this.connectionManager.getEndpointQualifier() == EndpointQualifier.MEMBER || this.unifiedEndpointManager);
        boolean bl = !handshake.isReply();
        Address remoteEndpoint = null;
        if (isMemberConnection) {
            if (bl) {
                allAliases.add(new Address(connection.getRemoteSocketAddress()));
            }
        } else {
            remoteEndpoint = new Address(connection.getRemoteSocketAddress());
        }
        this.process0(connection, remoteEndpoint, allAliases, handshake);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"})
    private synchronized void process0(TcpServerConnection connection, Address remoteEndpointAddress, Collection<Address> remoteAddressAliases, MemberHandshake handshake) {
        UUID remoteUuid = handshake.getUuid();
        Address primaryAddress = remoteEndpointAddress;
        if (primaryAddress == null) {
            if (remoteAddressAliases == null) {
                throw new IllegalStateException("Remote endpoint and remote address aliases cannot be both null");
            }
            primaryAddress = remoteAddressAliases.iterator().next();
        }
        Address targetAddress = connection.getRemoteAddress();
        connection.setRemoteAddress(primaryAddress);
        this.serverContext.onSuccessfulConnection(primaryAddress);
        if (handshake.isReply()) {
            new SendMemberHandshakeTask(this.logger, this.serverContext, connection, primaryAddress, false, handshake.getPlaneIndex(), handshake.getPlaneCount()).run();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Registering connection " + String.valueOf(connection) + " to address " + String.valueOf(primaryAddress) + " planeIndex:" + handshake.getPlaneIndex());
        }
        this.connectionManager.register(primaryAddress, targetAddress, remoteAddressAliases, remoteUuid, connection, handshake.getPlaneIndex());
    }
}

