/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.internal.networking.ChannelOption;
import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class TLSDecoder
extends InboundHandler<ByteBuffer, ByteBuffer> {
    private final SSLEngine sslEngine;
    private final SSLSession sslSession;
    private ByteBuffer appBuffer;

    public TLSDecoder(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.sslSession = sslEngine.getSession();
    }

    @Override
    public void handlerAdded() {
        int socketReceiveBuffer = this.channel.options().getOption(ChannelOption.SO_RCVBUF);
        int packetBufferSize = this.sslEngine.getSession().getPacketBufferSize();
        this.initSrcBuffer(Math.max(socketReceiveBuffer, packetBufferSize));
        this.appBuffer = IOUtil.newByteBuffer(this.sslSession.getApplicationBufferSize(), this.channel.options().getOption(ChannelOption.DIRECT_BUF));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public HandlerStatus onRead() throws Exception {
        if (!this.drainAppBuffer()) {
            return HandlerStatus.DIRTY;
        }
        ((ByteBuffer)this.src).flip();
        try {
            block16: while (true) {
                try {
                    unwrapResult = this.sslEngine.unwrap((ByteBuffer)this.src, this.appBuffer);
                }
                catch (SSLException e) {
                    throw new SSLException(IOUtil.toDebugString("src", (ByteBuffer)this.src) + " " + IOUtil.toDebugString("app", this.appBuffer) + " " + IOUtil.toDebugString("dst", (ByteBuffer)this.dst), e);
                }
                switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[unwrapResult.getStatus().ordinal()]) {
                    case 1: {
                        if (this.appBuffer.capacity() >= this.sslSession.getApplicationBufferSize()) {
                            var2_3 = HandlerStatus.DIRTY;
                            return var2_3;
                        }
                        this.appBuffer = this.newAppBuffer();
                        continue block16;
                    }
                    case 2: {
                        var2_4 = HandlerStatus.CLEAN;
                        return var2_4;
                    }
                    case 3: {
                        if (!this.drainAppBuffer()) {
                            var2_5 = HandlerStatus.DIRTY;
                            return var2_5;
                        }
                        if (((ByteBuffer)this.src).remaining() == 0) ** break;
                        continue block16;
                        var2_6 = HandlerStatus.CLEAN;
                        return var2_6;
                    }
                    case 4: {
                        var2_7 = HandlerStatus.CLEAN;
                        return var2_7;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)this.src);
        }
    }

    protected ByteBuffer appBuffer() {
        return this.appBuffer;
    }

    private ByteBuffer newAppBuffer() {
        return IOUtil.newByteBuffer(this.sslSession.getApplicationBufferSize(), this.channel.options().getOption(ChannelOption.DIRECT_BUF));
    }

    private boolean drainAppBuffer() {
        this.appBuffer.flip();
        int available = this.appBuffer.remaining();
        if (((ByteBuffer)this.dst).remaining() < available) {
            int oldLimit = this.appBuffer.limit();
            this.appBuffer.limit(this.appBuffer.position() + ((ByteBuffer)this.dst).remaining());
            ((ByteBuffer)this.dst).put(this.appBuffer);
            this.appBuffer.limit(oldLimit);
        } else {
            ((ByteBuffer)this.dst).put(this.appBuffer);
        }
        if (this.appBuffer.hasRemaining()) {
            IOUtil.compactOrClear(this.appBuffer);
            return false;
        }
        this.appBuffer.clear();
        return true;
    }
}

