/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.config.EndpointConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.ssl.AbstractMultiSocketTLSChannelInitializer;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.MemberProtocolEncoder;
import com.hazelcast.internal.server.tcp.SingleProtocolDecoder;
import com.hazelcast.internal.server.tcp.SingleProtocolEncoder;
import java.util.concurrent.Executor;

public class MemberTLSChannelInitializer
extends AbstractMultiSocketTLSChannelInitializer {
    public MemberTLSChannelInitializer(EndpointConfig endpointConfig, Executor tlsExecutor, ServerContext serverContext) {
        super(endpointConfig, tlsExecutor, serverContext);
    }

    @Override
    protected void initPipeline(Channel channel) {
        OutboundHandler outboundHandler;
        SingleProtocolEncoder protocolEncoder;
        ServerConnection connection = (ServerConnection)channel.attributeMap().get(ServerConnection.class);
        OutboundHandler[] outboundHandlers = this.serverContext.createOutboundHandlers(EndpointQualifier.MEMBER, connection);
        InboundHandler[] inboundHandlers = this.serverContext.createInboundHandlers(EndpointQualifier.MEMBER, connection);
        if (channel.isClientMode()) {
            protocolEncoder = new SingleProtocolEncoder(outboundHandlers);
            outboundHandler = new MemberProtocolEncoder(protocolEncoder);
        } else {
            outboundHandler = protocolEncoder = new SingleProtocolEncoder(new MemberProtocolEncoder(outboundHandlers));
        }
        SingleProtocolDecoder protocolDecoder = new SingleProtocolDecoder(ProtocolType.MEMBER, inboundHandlers, protocolEncoder);
        channel.outboundPipeline().addLast(outboundHandler);
        channel.inboundPipeline().addLast(protocolDecoder);
    }
}

