/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.client.impl.protocol.util.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.util.ClientMessageEncoder;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.nio.ssl.AbstractMultiSocketTLSChannelInitializer;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.SingleProtocolDecoder;
import com.hazelcast.internal.server.tcp.SingleProtocolEncoder;
import java.util.concurrent.Executor;

public class ClientTLSChannelInitializer
extends AbstractMultiSocketTLSChannelInitializer {
    public ClientTLSChannelInitializer(EndpointConfig endpointConfig, Executor tlsExecutor, ServerContext serverContext) {
        super(endpointConfig, tlsExecutor, serverContext);
    }

    @Override
    protected void initPipeline(Channel channel) {
        ServerConnection connection = (ServerConnection)channel.attributeMap().get(ServerConnection.class);
        SingleProtocolEncoder protocolEncoder = new SingleProtocolEncoder(new ClientMessageEncoder());
        SingleProtocolDecoder protocolDecoder = new SingleProtocolDecoder(ProtocolType.CLIENT, new ClientMessageDecoder(connection, this.serverContext.getClientEngine(), this.serverContext.properties()), protocolEncoder);
        channel.outboundPipeline().addLast(protocolEncoder);
        channel.inboundPipeline().addLast(protocolDecoder);
    }
}

