/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.nio.ssl.ReleaseReferenceCounted;
import com.hazelcast.internal.nio.ssl.SSLEngineFactoryAdaptor;
import com.hazelcast.internal.nio.ssl.SSLEngineFactorySupport;
import com.hazelcast.internal.nio.ssl.TLSExecutor;
import com.hazelcast.internal.nio.ssl.TLSHandshakeDecoder;
import com.hazelcast.internal.nio.ssl.TLSHandshakeEncoder;
import com.hazelcast.internal.util.OpenSSLUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.nio.ssl.SSLEngineFactory;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public abstract class AbstractTLSChannelInitializer
implements ChannelInitializer {
    private final ILogger logger = Logger.getLogger(AbstractTLSChannelInitializer.class);
    private final SSLConfig sslConfig;
    private final SSLEngineFactory sslEngineFactory;
    private final String mutualAuthentication;
    private final TLSExecutor tlsExecutor;
    private final boolean validateIdentity;
    private final boolean forceCertValidation;

    public AbstractTLSChannelInitializer(SSLConfig sslConfig, Executor tlsExecutor) {
        this.sslConfig = sslConfig;
        this.sslEngineFactory = this.loadSSLEngineFactory();
        this.tlsExecutor = new TLSExecutor(tlsExecutor);
        this.mutualAuthentication = SSLEngineFactorySupport.getProperty(sslConfig.getProperties(), "mutualAuthentication");
        this.validateIdentity = Boolean.parseBoolean(SSLEngineFactorySupport.getProperty(sslConfig.getProperties(), "validateIdentity"));
        this.forceCertValidation = Boolean.parseBoolean(SSLEngineFactorySupport.getProperty(sslConfig.getProperties(), "forceCertValidation"));
    }

    private SSLEngineFactory loadSSLEngineFactory() {
        Object implementation = this.sslConfig.getFactoryImplementation();
        try {
            String factoryClassName = this.sslConfig.getFactoryClassName();
            if (implementation == null && factoryClassName != null) {
                implementation = Class.forName(factoryClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (implementation == null) {
                implementation = this.loadDefaultImplementation();
            }
            if (implementation instanceof SSLContextFactory) {
                SSLContextFactory factory = (SSLContextFactory)implementation;
                implementation = new SSLEngineFactoryAdaptor(factory);
            }
            SSLEngineFactory sslEngineFactory = (SSLEngineFactory)implementation;
            sslEngineFactory.init(this.sslConfig.getProperties(), this.forClient());
            return sslEngineFactory;
        }
        catch (HazelcastException e) {
            throw e;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new InvalidConfigurationException("Error while loading SSL engine for: " + this.getClass().getSimpleName(), e);
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    private Object loadDefaultImplementation() {
        this.logger.info("Default TLS implementation used: " + BasicSSLContextFactory.class.getName());
        return new BasicSSLContextFactory();
    }

    protected abstract boolean forClient();

    @Override
    public final void initChannel(Channel channel) throws Exception {
        this.configChannel(channel);
        ConcurrentMap attributeMap = channel.attributeMap();
        Address peerAddress = (Address)attributeMap.get(Address.class);
        SSLEngine sslEngine = this.sslEngineFactory.create(channel.isClientMode(), peerAddress);
        if (OpenSSLUtil.isOpenSSLAvailable() && sslEngine instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)sslEngine;
            channel.addCloseListener(new ReleaseReferenceCounted(rc));
        }
        if (this.validateIdentity && peerAddress != null) {
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParams);
        }
        if (this.forceCertValidation) {
            attributeMap.put("forceCertValidation", Boolean.TRUE);
        }
        if ("REQUIRED".equals(this.mutualAuthentication)) {
            sslEngine.setNeedClientAuth(true);
        } else if ("OPTIONAL".equals(this.mutualAuthentication)) {
            sslEngine.setWantClientAuth(true);
        }
        sslEngine.beginHandshake();
        channel.inboundPipeline().addLast(new TLSHandshakeDecoder(sslEngine, this.tlsExecutor, attributeMap));
        this.initPipeline(channel);
        channel.outboundPipeline().addLast(new TLSHandshakeEncoder(sslEngine, this.tlsExecutor, attributeMap));
    }

    protected abstract void initPipeline(Channel var1);

    protected abstract void configChannel(Channel var1);
}

