/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.namespace;

import com.hazelcast.function.ThrowingRunnable;
import com.hazelcast.internal.namespace.impl.NamespaceThreadLocalContext;
import com.hazelcast.internal.namespace.impl.NodeEngineThreadLocalContext;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class NamespaceUtil {
    private NamespaceUtil() {
    }

    public static void setupNamespace(@Nullable String namespace) {
        NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContext();
        NamespaceUtil.setupNamespace(engine, namespace);
    }

    public static void cleanupNamespace(@Nullable String namespace) {
        NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContext();
        NamespaceUtil.cleanupNamespace(engine, namespace);
    }

    public static void setupNamespace(NodeEngine engine, @Nullable String namespace) {
        engine.getNamespaceService().setupNamespace(namespace);
    }

    public static void cleanupNamespace(NodeEngine engine, @Nullable String namespace) {
        engine.getNamespaceService().cleanupNamespace(namespace);
    }

    public static void runWithNamespace(@Nullable String namespace, ThrowingRunnable runnable) {
        NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContext();
        NamespaceUtil.runWithNamespace(engine, namespace, runnable);
    }

    public static void runWithNamespace(NodeEngine engine, @Nullable String namespace, ThrowingRunnable runnable) {
        engine.getNamespaceService().runWithNamespace(namespace, runnable);
    }

    public static void runWithNamespace(NodeEngine engine, @Nullable String namespace, Runnable runnable) {
        NamespaceUtil.runWithNamespace(engine, namespace, ThrowingRunnable.wrap(runnable));
    }

    public static <V> V callWithNamespace(@Nullable String namespace, Callable<V> callable) {
        NodeEngine engine = NodeEngineThreadLocalContext.getNodeEngineThreadLocalContext();
        return NamespaceUtil.callWithNamespace(engine, namespace, callable);
    }

    public static <V> V callWithNamespace(NodeEngine engine, @Nullable String namespace, Callable<V> callable) {
        return engine.getNamespaceService().callWithNamespace(namespace, callable);
    }

    public static <V> V callWithOwnClassLoader(Object userCodeObject, Callable<V> callable) {
        return NamespaceUtil.callWithClassLoader(userCodeObject.getClass().getClassLoader(), callable);
    }

    public static void runWithOwnClassLoader(Object userCodeObject, Runnable runnable) {
        NamespaceUtil.runWithClassLoader(userCodeObject.getClass().getClassLoader(), runnable);
    }

    public static <V> V callWithClassLoader(ClassLoader loader, Callable<V> callable) {
        if (loader == null) {
            try {
                return callable.call();
            }
            catch (Exception ex) {
                throw ExceptionUtil.sneakyThrow(ex);
            }
        }
        NamespaceThreadLocalContext.onStartNsAware(loader);
        try {
            V ex = callable.call();
            return ex;
        }
        catch (Exception exception) {
            throw ExceptionUtil.sneakyThrow(exception);
        }
        finally {
            NamespaceThreadLocalContext.onCompleteNsAware(loader);
        }
    }

    public static void runWithClassLoader(ClassLoader loader, Runnable runnable) {
        if (loader == null) {
            runnable.run();
            return;
        }
        NamespaceThreadLocalContext.onStartNsAware(loader);
        try {
            runnable.run();
        }
        catch (Exception exception) {
            throw ExceptionUtil.sneakyThrow(exception);
        }
        finally {
            NamespaceThreadLocalContext.onCompleteNsAware(loader);
        }
    }

    public static ClassLoader getClassLoaderForNamespace(NodeEngine engine, @Nullable String namespace) {
        ClassLoader loader = engine.getNamespaceService().getClassLoaderForNamespace(namespace);
        return loader != null ? loader : NamespaceUtil.getDefaultClassloader(engine);
    }

    public static ClassLoader getClassLoaderForNamespace(NodeEngine engine, @Nullable String namespace, ClassLoader defaultLoader) {
        ClassLoader loader = engine.getNamespaceService().getClassLoaderForNamespace(namespace);
        return loader != null ? loader : defaultLoader;
    }

    public static ClassLoader getDefaultClassloader(NodeEngine engine) {
        ClassLoader loader = engine.getNamespaceService().getClassLoaderForNamespace(null);
        return loader != null ? loader : engine.getConfigClassLoader();
    }
}

