/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.locksupport.operations;

import com.hazelcast.internal.locksupport.LockResourceImpl;
import com.hazelcast.internal.locksupport.LockStoreImpl;
import com.hazelcast.internal.locksupport.operations.UnlockOperation;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Notifier;
import com.hazelcast.spi.impl.operationservice.SplitBrainProtectionCheckAwareOperation;
import java.io.IOException;
import java.util.UUID;

public class LocalLockCleanupOperation
extends UnlockOperation
implements Notifier,
BackupAwareOperation,
SplitBrainProtectionCheckAwareOperation {
    private final UUID uuid;

    public LocalLockCleanupOperation() {
        this.uuid = UuidUtil.newUnsecureUUID();
    }

    public LocalLockCleanupOperation(ObjectNamespace namespace, Data key, UUID uuid) {
        super(namespace, key, -1L, true);
        this.uuid = uuid;
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        LockResourceImpl lock = lockStore.getLock(this.key);
        if (this.uuid.equals(lock.getOwner())) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Unlocking lock owned by UUID: " + String.valueOf(this.uuid) + ", thread ID: " + lock.getThreadId() + ", count: " + lock.getLockCount());
            }
            this.response = lockStore.forceUnlock(this.key);
        }
    }

    @Override
    public boolean shouldBackup() {
        NodeEngine nodeEngine = this.getNodeEngine();
        IPartitionService partitionService = nodeEngine.getPartitionService();
        IPartition partition = partitionService.getPartition(this.getPartitionId());
        return partition.isLocal() && Boolean.TRUE.equals(this.response);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException("LocalLockCleanupOperation is local only.");
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException("LocalLockCleanupOperation is local only.");
    }

    @Override
    public int getClassId() {
        throw new UnsupportedOperationException("LocalLockCleanupOperation is local only.");
    }

    @Override
    public boolean shouldCheckSplitBrainProtection() {
        return false;
    }
}

