/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.chunk;

import com.hazelcast.internal.hotrestart.KeyHandle;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.WriteThroughTombChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.Record;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import java.util.Arrays;

public final class StableTombChunk
extends StableChunk {
    private Long2ObjectHashMap<KeyHandle> filePosToKeyHandle;

    StableTombChunk(WriteThroughTombChunk from) {
        super(from);
    }

    public StableTombChunk(long seq, RecordMap records, int liveRecordCount, long size, long garbage) {
        super(seq, records, liveRecordCount, size, garbage, false);
    }

    @Override
    public String base() {
        return "tombstone";
    }

    @Override
    public void retire(KeyHandle kh, Record r, boolean mayIncrementGarbageCount) {
        if (this.filePosToKeyHandle != null) {
            this.filePosToKeyHandle.remove(r.filePosition());
        }
        super.retire(kh, r, mayIncrementGarbageCount);
    }

    @Override
    public void needsDismissing(boolean needsDismissing) {
    }

    public int[] initFilePosToKeyHandle() {
        int[] filePositions = new int[this.liveRecordCount];
        this.filePosToKeyHandle = new Long2ObjectHashMap(this.liveRecordCount);
        int i = 0;
        RecordMap.Cursor cursor = this.records.cursor();
        while (cursor.advance()) {
            Record r = cursor.asRecord();
            if (!r.isAlive()) continue;
            this.filePosToKeyHandle.put(r.filePosition(), cursor.toKeyHandle());
            filePositions[i++] = r.filePosition();
        }
        assert (i == this.liveRecordCount) : String.format("found %d live records, but liveRecordCount == %d", i, this.liveRecordCount);
        Arrays.sort(filePositions);
        return filePositions;
    }

    public KeyHandle getLiveKeyHandle(long filePos) {
        return this.filePosToKeyHandle.get(filePos);
    }

    public void disposeFilePosToKeyHandle() {
        this.filePosToKeyHandle = null;
    }

    public double updateBenefitToCost() {
        this.benefitToCost = StableTombChunk.benefitToCost(this.garbage, this.size());
        return this.benefitToCost;
    }

    public static double benefitToCost(long garbage, long size) {
        if (size == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        double g = (double)garbage / (double)size;
        return g / (1.0 - g);
    }
}

