/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.encryption;

import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.impl.di.Inject;
import com.hazelcast.internal.hotrestart.impl.di.Name;
import com.hazelcast.internal.hotrestart.impl.encryption.HotRestartCipherBuilder;
import com.hazelcast.internal.hotrestart.impl.encryption.HotRestartCipherInputStream;
import com.hazelcast.internal.hotrestart.impl.encryption.HotRestartStoreEncryptionConfig;
import com.hazelcast.internal.hotrestart.impl.encryption.InitialKeysSupplier;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.logging.ILogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class EncryptionManager {
    public static final String KEY_FILE_NAME = "key.bin";
    public static final String IV_FILE_NAME = "iv.bin";
    private static final int KEY_HASH_SIZE = 32;
    private static final int FILE_RENAME_TIMEOUT_SECONDS = 15;
    private final File homeDir;
    private final int keySize;
    private final HotRestartCipherBuilder cipherBuilder;
    private final ILogger logger;
    private byte[] storeKey;
    private volatile byte[] masterKey;

    @Inject
    public EncryptionManager(ILogger logger, @Nonnull @Name(value="homeDir") File homeDir, @Nonnull HotRestartStoreEncryptionConfig encryptionConfig) {
        Objects.requireNonNull(homeDir, "homeDir cannot be null!");
        Objects.requireNonNull(encryptionConfig, "encryptionConfig cannot be null!");
        this.logger = logger;
        HotRestartCipherBuilder configCipherBuilder = encryptionConfig.cipherBuilder();
        this.homeDir = homeDir;
        this.cipherBuilder = configCipherBuilder;
        this.keySize = encryptionConfig.keySize();
        this.initialize(encryptionConfig.initialKeysSupplier());
    }

    public boolean isEncryptionEnabled() {
        return this.cipherBuilder != null;
    }

    private void initialize(InitialKeysSupplier initialKeysSupplier) {
        if (this.isEncryptionEnabled()) {
            List initialKeys;
            List list = initialKeys = initialKeysSupplier == null ? null : (List)initialKeysSupplier.get();
            if (initialKeys == null || initialKeys.isEmpty()) {
                throw new HotRestartException("No master encryption key available");
            }
            this.masterKey = (byte[])initialKeys.get(0);
            this.checkKey(this.masterKey);
            this.storeKey = this.readKeyFile(initialKeys, this.masterKey);
            if (this.storeKey == null) {
                try {
                    this.storeKey = this.cipherBuilder.generateKey(this.keySize);
                }
                catch (Throwable e) {
                    throw new HotRestartException("Unable to generate encryption key", e);
                }
                this.logger.fine("New key will be stored.");
                this.writeKeyFile(this.storeKey);
                this.logger.info("Written key file: " + String.valueOf(this.getKeyFile()));
            }
        }
    }

    private byte[] readKeyFile(List<byte[]> masterKeys, byte[] currentMasterKey) {
        File keyFile = this.getKeyFile();
        if (!keyFile.exists()) {
            return null;
        }
        BufferedInputStream in = null;
        byte[] key = null;
        boolean reencrypt = false;
        try {
            in = new BufferedInputStream(new FileInputStream(keyFile));
            byte[] keyHashBytes = EncryptionManager.readKeyHashBytes(in);
            for (byte[] masterKeyBytes : masterKeys) {
                byte[] masterKeyHashBytes = EncryptionManager.computeKeyHash(masterKeyBytes);
                if (!Arrays.equals(keyHashBytes, masterKeyHashBytes)) continue;
                key = this.readEncryptionKey(in, masterKeyBytes);
                reencrypt = !Arrays.equals(masterKeyBytes, currentMasterKey);
                break;
            }
            if (key == null) {
                throw new HotRestartException("Cannot find master encryption key for key hash: " + EncryptionManager.keyHashToString(keyHashBytes));
            }
        }
        catch (IOException e) {
            try {
                throw new HotRestartException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(in);
                throw throwable;
            }
        }
        IOUtil.closeResource(in);
        if (reencrypt) {
            this.logger.fine("Master key rotation is detected during EncryptionManager initialization.");
            this.writeKeyFile(key);
            this.logger.info("Re-encrypted key file: " + String.valueOf(keyFile));
        }
        return key;
    }

    private byte[] readEncryptionKey(InputStream in, byte[] masterKeyBytes) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            Cipher cipher = this.createCipher(false, masterKeyBytes, this.getIvFile());
            CipherInputStream cin = new CipherInputStream(in, cipher);
            IOUtil.drainTo(cin, bytes);
        }
        catch (Exception e) {
            throw new HotRestartException("Failed to decrypt proxy encryption key", e);
        }
        if (this.keySize > 0 && bytes.size() * 8 != this.keySize) {
            throw new HotRestartException("Encryption key has length: " + bytes.size() * 8 + ", expected: " + this.keySize);
        }
        return bytes.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="The DataOutputStream not closed intentionally (so that the wrapped stream does not get closed)")
    private void writeKeyFile(byte[] data) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Initiated writing the key file. Data bytes sum: " + EncryptionManager.sum(data));
        }
        EncryptionManager encryptionManager = this;
        synchronized (encryptionManager) {
            File tmp = new File(this.homeDir, "key.bin.tmp");
            File tmpIV = new File(this.homeDir, "iv.bin.tmp");
            BufferedOutputStream out = null;
            BufferedOutputStream outIV = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(tmp));
                outIV = new BufferedOutputStream(new FileOutputStream(tmpIV));
                byte[] masterKeyOut = this.masterKey;
                byte[] masterKeyHashBytes = EncryptionManager.computeKeyHash(masterKeyOut);
                String base64EncodedKeyHash = Base64.getEncoder().encodeToString(masterKeyHashBytes);
                DataOutputStream dout = new DataOutputStream(out);
                DataOutputStream doutIV = new DataOutputStream(outIV);
                byte[] iv = this.cipherBuilder.generateIV();
                doutIV.write(iv);
                doutIV.flush();
                dout.writeUTF(base64EncodedKeyHash);
                dout.flush();
                Cipher cipher = this.cipherBuilder.create(true, masterKeyOut, iv);
                CipherOutputStream cout = new CipherOutputStream(out, cipher);
                cout.write(data);
                cout.close();
            }
            catch (Exception e) {
                try {
                    throw new HotRestartException(e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(out);
                    IOUtil.closeResource(outIV);
                    throw throwable;
                }
            }
            IOUtil.closeResource(out);
            IOUtil.closeResource(outIV);
            IOUtil.moveWithTimeout(tmp.toPath(), this.getKeyFile().toPath(), Duration.ofSeconds(15L));
            IOUtil.moveWithTimeout(tmpIV.toPath(), this.getIvFile().toPath(), Duration.ofSeconds(15L));
        }
        this.logger.fine("Writing the key file finished.");
    }

    private static int sum(byte[] data) {
        int i = 0;
        for (byte b : data) {
            i += b;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(File targetDir) {
        if (this.isEncryptionEnabled()) {
            EncryptionManager encryptionManager = this;
            synchronized (encryptionManager) {
                IOUtil.copy(this.getKeyFile(), targetDir);
                IOUtil.copy(this.getIvFile(), targetDir);
                this.backupIVs(targetDir, "value");
                this.backupIVs(targetDir, "tombstone");
            }
        }
    }

    private void backupIVs(File targetDir, String valOrTomb) {
        String[] files = new File(this.homeDir.getPath(), valOrTomb).list();
        File targetValOrTombDir = new File(targetDir, valOrTomb);
        if (!targetValOrTombDir.mkdir()) {
            this.logger.warning("Target directory was not created: " + targetValOrTombDir.getAbsolutePath());
        }
        for (String f : files) {
            File ivFile = new File(this.homeDir, valOrTomb + "/" + f + "/iv.bin");
            if (!ivFile.exists()) continue;
            File fileTargetDir = new File(targetValOrTombDir, f);
            if (!fileTargetDir.mkdir()) {
                this.logger.warning("Target directory was not created: " + fileTargetDir.getAbsolutePath());
            }
            IOUtil.copy(ivFile, fileTargetDir);
        }
    }

    File getKeyFile() {
        return new File(this.homeDir, KEY_FILE_NAME);
    }

    File getIvFile() {
        return new File(this.homeDir, IV_FILE_NAME);
    }

    public void rotateMasterKey(byte[] key) {
        if (this.isEncryptionEnabled()) {
            this.logger.fine("Master key is being rotated.");
            this.masterKey = Arrays.copyOf(key, key.length);
            this.writeKeyFile(this.storeKey);
            this.logger.info("Re-encrypted key file: " + String.valueOf(this.getKeyFile()));
        }
    }

    private void checkKey(byte[] keyBytes) {
        this.createCipher(true, keyBytes, this.getIvFile());
        this.createCipher(false, keyBytes, this.getIvFile());
    }

    private static String keyHashToString(byte[] keyHashBytes) {
        return String.format("%x", new BigInteger(1, keyHashBytes));
    }

    public Cipher newWriteCipher(String parentPath) {
        if (!this.isEncryptionEnabled()) {
            return null;
        }
        return this.createCipher(true, this.storeKey, new File(parentPath, IV_FILE_NAME));
    }

    private Cipher newReadCipher(String parentPath) {
        return this.createCipher(false, this.storeKey, new File(parentPath, IV_FILE_NAME));
    }

    Cipher createCipher(boolean createWriter, byte[] keyBytes, File ivFile) {
        Cipher cipher = this.cipherBuilder.create(createWriter, keyBytes, ivFile);
        this.logger.fine("Cipher is created with randomIVEnabled = " + this.cipherBuilder.getRandomIVEnabled());
        return cipher;
    }

    public static byte[] computeKeyHash(byte[] keyBytes) {
        byte[] keyHashBytes = new byte[32];
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(keyBytes);
            digest.digest(keyHashBytes, 0, keyHashBytes.length);
        }
        catch (GeneralSecurityException e) {
            throw new HotRestartException(e);
        }
        return keyHashBytes;
    }

    public InputStream wrap(InputStream is, String fileParentPath) {
        if (!this.isEncryptionEnabled()) {
            return is;
        }
        Cipher cipher = this.newReadCipher(fileParentPath);
        return new HotRestartCipherInputStream(is, cipher);
    }

    private static byte[] readKeyHashBytes(InputStream in) {
        DataInputStream din = new DataInputStream(in);
        try {
            String base64EncodedKeyHash = din.readUTF();
            return Base64.getDecoder().decode(base64EncodedKeyHash);
        }
        catch (Exception e) {
            throw new HotRestartException(e);
        }
    }

    public boolean isEffectivelyEmpty(File file) {
        boolean bl;
        block10: {
            long length = file.length();
            if (length == 0L) {
                return true;
            }
            if (!this.isEncryptionEnabled()) {
                return false;
            }
            InputStream in = this.wrap(new FileInputStream(file), file.getParent());
            try {
                boolean bl2 = bl = in.read() == -1;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }
}

