/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.internal.hotrestart.cluster.AbstractMetadataWriter;
import com.hazelcast.internal.hotrestart.cluster.ClusterStateWriter;
import com.hazelcast.internal.hotrestart.cluster.ClusterVersionWriter;
import com.hazelcast.internal.hotrestart.cluster.CompactSchemaWriter;
import com.hazelcast.internal.hotrestart.cluster.MemberListWriter;
import com.hazelcast.internal.hotrestart.cluster.PartitionTableWriter;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.concurrent.MPSCQueue;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.version.Version;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class ClusterMetadataWriterLoop
implements Runnable {
    private static final long SLOW_PERSISTENCE_THRESHOLD_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private final ILogger logger;
    private final MPSCQueue<Runnable> taskQueue = new MPSCQueue(null);
    private final MemberListHandler memberListHandler;
    private final PartitionTableHandler partitionTableHandler;
    private final ClusterStateHandler clusterStateHandler;
    private final ClusterVersionHandler clusterVersionHandler;
    private final CompactSchemaHandler compactSchemaHandler;
    private final Thread thread;
    private boolean stop;

    ClusterMetadataWriterLoop(File homeDir, Supplier<Member> localMemberSupplier, Supplier<String> threadNameSupplier, Function<Class<?>, ILogger> loggerSupplier) {
        ClusterMetadataWriterLoop.mkdir(homeDir);
        this.logger = loggerSupplier.apply(this.getClass());
        this.memberListHandler = new MemberListHandler(new MemberListWriter(homeDir, localMemberSupplier));
        this.partitionTableHandler = new PartitionTableHandler(new PartitionTableWriter(homeDir));
        this.clusterStateHandler = new ClusterStateHandler(new ClusterStateWriter(homeDir));
        this.clusterVersionHandler = new ClusterVersionHandler(new ClusterVersionWriter(homeDir));
        this.compactSchemaHandler = new CompactSchemaHandler(new CompactSchemaWriter(homeDir));
        this.thread = new Thread((Runnable)this, this.createMetadataPersistenceThreadName(threadNameSupplier.get()));
        this.taskQueue.setConsumerThread(this.thread);
    }

    String createMetadataPersistenceThreadName(String name) {
        return ThreadUtil.createThreadName(name, "cluster-metadata-persistence-thread");
    }

    private static void mkdir(File homeDir) {
        if (!homeDir.exists() && !homeDir.mkdirs()) {
            throw new HotRestartException("Cannot create Hot Restart cluster metadata directory: " + homeDir.getAbsolutePath());
        }
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Runnable task = this.taskQueue.take();
                task.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.severe(e);
                break;
            }
            catch (Throwable e) {
                this.logger.severe(e);
            }
        }
    }

    void start() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Starting metadata writer thread.");
        }
        this.thread.start();
    }

    void stop(boolean awaitPendingTasks) {
        if (!awaitPendingTasks) {
            this.taskQueue.clear();
        }
        this.taskQueue.offer(new StopTask());
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRestartException("Interrupted while waiting for the metadata persistence thread to stop", e);
        }
    }

    void writeMembers(Collection<Member> members) {
        this.memberListHandler.set(members);
        this.taskQueue.offer(this.memberListHandler);
    }

    void writePartitionTable(PartitionTableView partitionTable) {
        this.partitionTableHandler.set(partitionTable);
        this.taskQueue.offer(this.partitionTableHandler);
    }

    void writeClusterState(ClusterState state) {
        this.clusterStateHandler.set(state);
        this.taskQueue.offer(this.clusterStateHandler);
    }

    void writeClusterVersion(Version clusterVersion) {
        this.clusterVersionHandler.set(clusterVersion);
        this.taskQueue.offer(this.clusterVersionHandler);
    }

    void writeCompactSchemas(Collection<Schema> schemas, InternalCompletableFuture<Void> future) {
        this.compactSchemaHandler.enqueueNewPersistenceFuture(future);
        this.compactSchemaHandler.set(schemas);
        this.taskQueue.offer(this.compactSchemaHandler);
    }

    <T> Optional<Throwable> persist(AbstractMetadataWriter<T> writer, T value, String type) {
        try {
            long startTimeNanos = System.nanoTime();
            writer.write(value);
            long durationNanos = System.nanoTime() - startTimeNanos;
            if (durationNanos > SLOW_PERSISTENCE_THRESHOLD_NANOS) {
                long durationMillis = TimeUnit.NANOSECONDS.toMillis(durationNanos);
                this.logger.warning("Slow disk IO! " + type + " persistence took " + durationMillis + " ms.");
            }
            return Optional.empty();
        }
        catch (IOException e) {
            this.logger.severe("While persisting " + type, e);
            return Optional.of(e);
        }
    }

    private final class MemberListHandler
    extends StatefulTask<Collection<Member>> {
        private final MemberListWriter writer;

        private MemberListHandler(MemberListWriter writer) {
            this.writer = writer;
        }

        @Override
        public void run() {
            Collection members = (Collection)this.getAndReset();
            if (members == null) {
                return;
            }
            if (ClusterMetadataWriterLoop.this.logger.isFineEnabled()) {
                ClusterMetadataWriterLoop.this.logger.fine("Persisting " + members.size() + " (active & passive) members -> " + String.valueOf(members));
            }
            ClusterMetadataWriterLoop.this.persist(this.writer, members, "Member List");
        }
    }

    private final class PartitionTableHandler
    extends StatefulTask<PartitionTableView> {
        private final AbstractMetadataWriter<PartitionTableView> writer;

        private PartitionTableHandler(AbstractMetadataWriter<PartitionTableView> writer) {
            this.writer = writer;
        }

        @Override
        public void run() {
            PartitionTableView partitionTable = (PartitionTableView)this.getAndReset();
            if (partitionTable == null) {
                return;
            }
            if (ClusterMetadataWriterLoop.this.logger.isFinestEnabled()) {
                ClusterMetadataWriterLoop.this.logger.finest("Persisting partition table with stamp: " + partitionTable.stamp());
            }
            ClusterMetadataWriterLoop.this.persist(this.writer, partitionTable, "Partition Table");
        }
    }

    private final class ClusterStateHandler
    extends StatefulTask<ClusterState> {
        private final ClusterStateWriter writer;

        private ClusterStateHandler(ClusterStateWriter writer) {
            this.writer = writer;
        }

        @Override
        public void run() {
            ClusterState state = (ClusterState)((Object)this.getAndReset());
            if (state == null) {
                return;
            }
            if (ClusterMetadataWriterLoop.this.logger.isFineEnabled()) {
                ClusterMetadataWriterLoop.this.logger.fine("Persisting cluster state: " + String.valueOf((Object)state));
            }
            ClusterMetadataWriterLoop.this.persist(this.writer, state, "Cluster State");
        }
    }

    private final class ClusterVersionHandler
    extends StatefulTask<Version> {
        private final ClusterVersionWriter writer;

        private ClusterVersionHandler(ClusterVersionWriter writer) {
            this.writer = writer;
        }

        @Override
        public void run() {
            Version version = (Version)this.getAndReset();
            if (version == null) {
                return;
            }
            if (ClusterMetadataWriterLoop.this.logger.isFineEnabled()) {
                ClusterMetadataWriterLoop.this.logger.fine("Persisting cluster version: " + String.valueOf(version));
            }
            ClusterMetadataWriterLoop.this.persist(this.writer, version, "Cluster Version");
        }
    }

    private final class CompactSchemaHandler
    extends StatefulTask<Collection<Schema>> {
        private final CompactSchemaWriter writer;
        private final ConcurrentLinkedQueue<InternalCompletableFuture<Void>> persistenceFutures = new ConcurrentLinkedQueue();
        private Throwable lastPersistenceResult;

        private CompactSchemaHandler(CompactSchemaWriter writer) {
            this.writer = writer;
        }

        public void enqueueNewPersistenceFuture(InternalCompletableFuture<Void> future) {
            this.persistenceFutures.add(future);
        }

        @Override
        public void run() {
            Collection schemas = (Collection)this.getAndReset();
            if (schemas == null) {
                this.completeNextFuture(this.lastPersistenceResult);
                return;
            }
            if (ClusterMetadataWriterLoop.this.logger.isFineEnabled()) {
                ClusterMetadataWriterLoop.this.logger.fine("Persisting " + schemas.size() + " schemas -> " + String.valueOf(schemas));
            }
            try {
                Optional<Throwable> result = ClusterMetadataWriterLoop.this.persist(this.writer, schemas, "Compact schema");
                if (result.isPresent()) {
                    this.completeNextFuture(result.get());
                } else {
                    this.completeNextFuture(null);
                }
            }
            catch (Throwable t) {
                this.completeNextFuture(t);
                throw ExceptionUtil.rethrow(t);
            }
        }

        private void completeNextFuture(@Nullable Throwable t) {
            this.lastPersistenceResult = t;
            InternalCompletableFuture<Void> future = this.persistenceFutures.poll();
            assert (future != null);
            if (t == null) {
                future.complete(null);
            } else {
                future.completeExceptionally(t);
            }
        }
    }

    private final class StopTask
    implements Runnable {
        private StopTask() {
        }

        @Override
        public void run() {
            if (ClusterMetadataWriterLoop.this.logger.isFineEnabled()) {
                ClusterMetadataWriterLoop.this.logger.fine("Stopping metadata writer thread.");
            }
            ClusterMetadataWriterLoop.this.stop = true;
        }
    }

    private static abstract class StatefulTask<T>
    implements Runnable {
        private final AtomicReference<T> state = new AtomicReference();

        private StatefulTask() {
        }

        final void set(T value) {
            this.state.set(value);
        }

        final T getAndReset() {
            return this.state.getAndSet(null);
        }
    }
}

