/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hidensity.impl;

import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.TStoreException;
import com.hazelcast.internal.tstore.compaction.ToHumanReadable;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.TieredStoreChunkAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.TieredStoreSlotAccessor;
import java.util.Map;
import java.util.function.Supplier;

public class TieredStoreRecordProcessor
implements HiDensityRecordProcessor<TieredStoreRecord> {
    public static final AddressRemapper<TieredStoreRecord> NOP_REMAPPER = (record, oldLogicalAddress, newLogicalAddress, threadIndex) -> newLogicalAddress;
    private final EnterpriseSerializationService serializationService;
    private final TieredStoreRecordAccessor recordAccessor;
    private final Epoch epoch;
    private int maxAcceptedNewRecordSize;

    public TieredStoreRecordProcessor(EnterpriseSerializationService serializationService, TieredStoreRecordAccessor recordAccessor, Epoch epoch) {
        this.serializationService = serializationService;
        this.recordAccessor = recordAccessor;
        this.epoch = epoch;
        HybridLog hybridLog = recordAccessor.getHybridLog();
        int maxHybridLogRecordSize = hybridLog.getMaxSupportedRecordSizeInBytes();
        int halfMaxSize = maxHybridLogRecordSize / 2;
        this.maxAcceptedNewRecordSize = TieredStoreRecordProcessor.adjustMaxRecordSize(halfMaxSize);
    }

    public void adjustMaxAcceptedRecordSize() {
        int newMaxRecordSize = this.maxAcceptedNewRecordSize / 2;
        if (newMaxRecordSize <= 40) {
            throw new TStoreException(String.format("The maximum supported record size: %s is too low", ToHumanReadable.bytesToString(newMaxRecordSize)));
        }
        this.maxAcceptedNewRecordSize = TieredStoreRecordProcessor.adjustMaxRecordSize(newMaxRecordSize);
    }

    private static int adjustMaxRecordSize(int maxRecordSize) {
        int paddedNewMaxSize;
        int diff = (paddedNewMaxSize = TStoreUtil.padTo8Bytes(maxRecordSize)) - maxRecordSize;
        return paddedNewMaxSize - (diff == 0 ? 0 : 8);
    }

    public EnterpriseSerializationService getSerializationService() {
        return this.serializationService;
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    public TieredStoreRecord newPreparedRecord(int recordSize, int threadIndex) {
        this.checkMaxSupportedRecordSize(recordSize);
        HybridLog hybridLog = this.getHybridLog();
        TieredStoreRecord record = this.newRecord();
        long logicalAddress = hybridLog.allocate(recordSize);
        long physicalAddress = hybridLog.asPhysicalAddress(logicalAddress, threadIndex);
        record.reset(physicalAddress, logicalAddress, recordSize);
        return record;
    }

    private void checkMaxSupportedRecordSize(int recordSize) {
        if (recordSize > this.maxAcceptedNewRecordSize) {
            throw new TStoreException(String.format("The requested tiered storage record (combined key + value) size: %s is bigger than the maximum size: %s. Increase hybrid log page size to store bigger values.", ToHumanReadable.bytesToString(recordSize), ToHumanReadable.bytesToString(this.maxAcceptedNewRecordSize)));
        }
    }

    public TieredStoreRecord readRecordForReadOnly(long recordLogicalAddress, AddressRemapper<TieredStoreRecord> addressUpdater, int threadIndex) {
        return this.readRecord(recordLogicalAddress, addressUpdater, false, threadIndex);
    }

    public TieredStoreRecord readRecordForUpdate(long recordLogicalAddress, AddressRemapper<TieredStoreRecord> addressUpdater, int threadIndex) {
        return this.readRecord(recordLogicalAddress, addressUpdater, true, threadIndex);
    }

    private TieredStoreRecord readRecord(long recordLogicalAddress, AddressRemapper<TieredStoreRecord> addressUpdater, boolean forUpdate, int threadIndex) {
        long newReadRecordLogicalAddress;
        TieredStoreRecord readRecord;
        HybridLog hybridLog = this.recordAccessor.getHybridLog();
        TieredStoreSlotAccessor slotAccessor = this.recordAccessor.getTieredStoreSlotAccessor();
        boolean createdNewCopy = forUpdate && !hybridLog.isMutable(recordLogicalAddress) || !hybridLog.isInMemory(recordLogicalAddress, threadIndex);
        TieredStoreRecord tieredStoreRecord = readRecord = forUpdate ? hybridLog.readRecordForUpdate(recordLogicalAddress, slotAccessor, NOP_REMAPPER) : hybridLog.readRecordForReadOnly(recordLogicalAddress, slotAccessor, NOP_REMAPPER);
        if (readRecord == Index.RETRY_RECORD) {
            return Index.RETRY_RECORD;
        }
        if (createdNewCopy) {
            this.recordAccessor.setDummy(readRecord, threadIndex);
        }
        if ((newReadRecordLogicalAddress = readRecord.getLogicalAddress()) == recordLogicalAddress) {
            return readRecord;
        }
        long remappedRecordLogicalAddress = addressUpdater.remap(readRecord, recordLogicalAddress, newReadRecordLogicalAddress, threadIndex);
        if (newReadRecordLogicalAddress != remappedRecordLogicalAddress) {
            return Index.RETRY_RECORD;
        }
        assert (hybridLog.isInMemory(newReadRecordLogicalAddress, threadIndex));
        assert (!forUpdate || this.isMutable(newReadRecordLogicalAddress));
        return readRecord;
    }

    public byte[] readRecordFromDevice(long recordLogicalAddress) {
        assert (!this.getHybridLog().isInMemory(recordLogicalAddress));
        TieredStoreSlotAccessor slotAccessor = this.recordAccessor.getTieredStoreSlotAccessor();
        return this.getHybridLog().readRecordFromDevice(recordLogicalAddress, slotAccessor);
    }

    public Data readRecordValueFromDevice(long recordLogicalAddress, int valueOffset, byte[] buf) {
        assert (!this.getHybridLog().isInMemory(recordLogicalAddress));
        TieredStoreChunkAccessor chunkAccessor = this.recordAccessor.getTieredStoreChunkAccessor();
        byte[] payload = this.getHybridLog().readChunk(recordLogicalAddress + (long)valueOffset, buf, chunkAccessor);
        return new HeapData(payload);
    }

    public Data readRecordValueFromDevice(long recordLogicalAddress, Data key, byte[] buf) {
        assert (!this.getHybridLog().isInMemory(recordLogicalAddress));
        int valueOffset = 16 + key.totalSize();
        return this.readRecordValueFromDevice(recordLogicalAddress, valueOffset, buf);
    }

    public int recordSize(Data key, Data dataValue, int metadataSize) {
        return this.recordAccessor.recordSize(key, dataValue, metadataSize);
    }

    @Override
    public boolean isEqual(long address, TieredStoreRecord value) {
        return this.recordAccessor.isEqual(address, value);
    }

    @Override
    public boolean isEqual(long address1, long address2) {
        return this.recordAccessor.isEqual(address1, address2);
    }

    @Override
    public TieredStoreRecord read(long address) {
        return (TieredStoreRecord)this.recordAccessor.read(address);
    }

    @Override
    public long dispose(long address) {
        return this.recordAccessor.dispose(address);
    }

    @Override
    public long dispose(TieredStoreRecord block) {
        return this.recordAccessor.dispose(block);
    }

    @Override
    public TieredStoreRecord newRecord() {
        return (TieredStoreRecord)this.recordAccessor.newRecord();
    }

    public Map.Entry<Data, Record<Data>> newEntry(byte[] record) {
        return this.recordAccessor.newEntry(record);
    }

    public Map.Entry<Data, Record<Data>> newEntry(TieredStoreRecord record) {
        return this.recordAccessor.newEntry(record);
    }

    public Data newKey(byte[] record) {
        return this.recordAccessor.newKey(record);
    }

    @Override
    public NativeMemoryData readData(long valueAddress) {
        return this.recordAccessor.readData(valueAddress);
    }

    @Override
    public Object readValue(TieredStoreRecord record) {
        return this.recordAccessor.readValue(record);
    }

    @Override
    public long readValueAddress(TieredStoreRecord record) {
        return this.recordAccessor.readValueAddress(record);
    }

    @Override
    public void setValueAddress(TieredStoreRecord record, long address) {
        this.recordAccessor.setValueAddress(record, address);
    }

    @Override
    public void setValue(TieredStoreRecord record, Data value) {
        this.recordAccessor.setValue(record, value);
    }

    @Override
    public long disposeValue(TieredStoreRecord record) {
        return this.recordAccessor.disposeValue(record);
    }

    @Override
    public long disposeData(NativeMemoryData data) {
        return this.recordAccessor.disposeData(data);
    }

    @Override
    public long disposeData(long address) {
        return this.recordAccessor.disposeData(address);
    }

    @Override
    public Data toData(Object obj, DataType dataType) {
        if (dataType == DataType.NATIVE) {
            return this.serializationService.toNativeData(obj, this.serializationService.getMemoryManager());
        }
        return this.serializationService.toData(obj, dataType);
    }

    @Override
    public Object toObject(Object data) {
        return this.serializationService.toObject(data, this.serializationService.getMemoryManager());
    }

    @Override
    public Data convertData(Data data, DataType dataType) {
        if (dataType == DataType.NATIVE) {
            return this.serializationService.convertToNativeData(data, this.serializationService.getMemoryManager());
        }
        return this.serializationService.convertData(data, dataType);
    }

    @Override
    public void disposeData(Data data) {
        throw new UnsupportedOperationException("Dispose is not supported for the hybrid log");
    }

    @Override
    public long allocate(long size) {
        HybridLog hybridLog = this.recordAccessor.getHybridLog();
        long logicalAddress = hybridLog.allocate(size);
        int currentThreadIndex = this.epoch.getCurrentThreadIndex();
        return hybridLog.asPhysicalAddress(logicalAddress, currentThreadIndex);
    }

    @Override
    public void free(long address, long size) {
        throw new UnsupportedOperationException("Free is not supported for the hybrid log");
    }

    @Override
    public void addDeferredDispose(MemoryBlock memoryBlock) {
        throw new UnsupportedOperationException("Tiered store record is disposed on compaction");
    }

    @Override
    public void disposeDeferredBlocks() {
        throw new UnsupportedOperationException("Tiered store record is disposed on compaction");
    }

    @Override
    public long getSize(MemoryBlock memoryBlock) {
        return this.recordAccessor.getSize(memoryBlock);
    }

    @Override
    public long getSize(long address, long expectedSize) {
        return this.recordAccessor.getSize(address, expectedSize);
    }

    @Override
    public MemoryAllocator unwrapMemoryAllocator() {
        throw new UnsupportedOperationException("Hybrid log has no wrapped memory allocator");
    }

    @Override
    public long getUsedMemory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long increaseUsedMemory(long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long decreaseUsedMemory(long size) {
        throw new UnsupportedOperationException();
    }

    public boolean isInMemory(TieredStoreRecord record) {
        return this.recordAccessor.isInMemory(record);
    }

    public boolean isInMemory(TieredStoreRecord record, int threadIndex) {
        return this.recordAccessor.isInMemory(record, threadIndex);
    }

    public boolean isMutable(long logicalRecord) {
        return this.getHybridLog().isMutable(logicalRecord);
    }

    public boolean isMutable(long logicalRecord, int threadIndex) {
        return this.getHybridLog().isMutable(logicalRecord, threadIndex);
    }

    public HybridLog getHybridLog() {
        return this.recordAccessor.getHybridLog();
    }

    public Supplier<HybridLog> getHybridLogSupplier() {
        return this.recordAccessor.getHybridLogSupplier();
    }

    public TieredStoreRecordAccessor getRecordAccessor() {
        return this.recordAccessor;
    }
}

