/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.map;

import com.hazelcast.internal.elastic.SlottableIterator;
import com.hazelcast.internal.elastic.map.BehmMemoryBlockProcessor;
import com.hazelcast.internal.elastic.map.BehmSlotAccessor;
import com.hazelcast.internal.elastic.map.BehmSlotAccessorFactory;
import com.hazelcast.internal.elastic.map.ElasticMap;
import com.hazelcast.internal.memory.GlobalMemoryAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.memory.MemoryBlockAccessor;
import com.hazelcast.internal.memory.MemoryBlockProcessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.hashslot.impl.CapacityUtil;
import com.hazelcast.memory.NativeOutOfMemoryError;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.function.IntConsumer;

public class BinaryElasticHashMap<V extends MemoryBlock>
implements ElasticMap<Data, V> {
    public static final int HEADER_LENGTH_IN_BYTES = 36;
    protected final MemoryBlockProcessor<V> memoryBlockProcessor;
    protected BehmSlotAccessor accessor;
    protected int perturbation;
    private final BehmSlotAccessorFactory accessorFactory;
    private int allocatedSlotCount;
    private int assignedSlotCount;
    private final float loadFactor;
    private int resizeAt;
    private final MemoryAllocator malloc;
    private Random random;
    private int modCount;

    public BinaryElasticHashMap(EnterpriseSerializationService serializationService, BehmSlotAccessorFactory behmSlotAccessorFactory, MemoryBlockAccessor<V> memoryBlockAccessor, MemoryAllocator malloc) {
        this(16, serializationService, behmSlotAccessorFactory, memoryBlockAccessor, malloc);
    }

    public BinaryElasticHashMap(int initialCapacity, EnterpriseSerializationService serializationService, BehmSlotAccessorFactory behmSlotAccessorFactory, MemoryBlockAccessor<V> memoryBlockAccessor, MemoryAllocator malloc) {
        this(initialCapacity, 0.6f, serializationService, behmSlotAccessorFactory, memoryBlockAccessor, malloc);
    }

    public BinaryElasticHashMap(int initialCapacity, float loadFactor, EnterpriseSerializationService serializationService, BehmSlotAccessorFactory behmSlotAccessorFactory, MemoryBlockAccessor<V> memoryBlockAccessor, MemoryAllocator malloc) {
        this(initialCapacity, loadFactor, behmSlotAccessorFactory, new BehmMemoryBlockProcessor<V>(serializationService, memoryBlockAccessor, malloc));
    }

    public BinaryElasticHashMap(int initialCapacity, BehmSlotAccessorFactory behmSlotAccessorFactory, MemoryBlockProcessor<V> memoryBlockProcessor) {
        this(initialCapacity, 0.6f, behmSlotAccessorFactory, memoryBlockProcessor);
    }

    public BinaryElasticHashMap(int initialCapacity, float loadFactor, BehmSlotAccessorFactory behmSlotAccessorFactory, MemoryBlockProcessor<V> memoryBlockProcessor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.memoryBlockProcessor = memoryBlockProcessor;
        this.malloc = memoryBlockProcessor.unwrapMemoryAllocator();
        this.accessorFactory = behmSlotAccessorFactory;
        this.allocateBuffer(CapacityUtil.roundCapacity(initialCapacity));
    }

    private BinaryElasticHashMap(int allocatedSlotCount, int assignedSlotCount, float loadFactor, int resizeAt, int perturbation, long baseAddress, long size, MemoryBlockAccessor<V> memoryBlockAccessor, MemoryAllocator malloc, EnterpriseSerializationService ess, BehmSlotAccessorFactory behmSlotAccessorFactory) {
        this.allocatedSlotCount = allocatedSlotCount;
        this.assignedSlotCount = assignedSlotCount;
        this.loadFactor = loadFactor;
        this.resizeAt = resizeAt;
        this.perturbation = perturbation;
        this.malloc = malloc;
        this.memoryBlockProcessor = new BehmMemoryBlockProcessor<V>(ess, memoryBlockAccessor, malloc);
        this.accessorFactory = behmSlotAccessorFactory;
        this.accessor = this.accessorFactory.create(malloc, baseAddress, size);
    }

    private BinaryElasticHashMap(int allocatedSlotCount, int assignedSlotCount, float loadFactor, int resizeAt, int perturbation, long baseAddress, long size, MemoryAllocator malloc, EnterpriseSerializationService ess, BehmSlotAccessorFactory behmSlotAccessorFactory, MemoryBlockAccessor memoryBlockAccessor) {
        this(allocatedSlotCount, assignedSlotCount, loadFactor, resizeAt, perturbation, baseAddress, size, memoryBlockAccessor, malloc, ess, behmSlotAccessorFactory);
    }

    private Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    private void allocateBuffer(int capacity) {
        try {
            this.accessor = this.accessorFactory.create(this.malloc, 0L, 0L).allocate(capacity);
        }
        catch (NativeOutOfMemoryError e) {
            throw this.onOome(e);
        }
        this.allocatedSlotCount = capacity;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = HashUtil.computePerturbationValue(capacity);
    }

    protected NativeOutOfMemoryError onOome(NativeOutOfMemoryError e) {
        return e;
    }

    @Override
    public V put(Data key, V value) {
        this.ensureMemory();
        assert (this.assignedSlotCount < this.allocatedSlotCount);
        int mask = this.allocatedSlotCount - 1;
        int slot = BehmSlotAccessor.rehash(key, this.perturbation) & mask;
        while (this.accessor.isAssigned(slot)) {
            long keyAddr = this.accessor.getKey(slot);
            if (NativeMemoryDataUtil.equals(keyAddr, key)) {
                long oldValue = this.accessor.getValue(slot);
                this.accessor.setValue(slot, value);
                return this.readV(oldValue);
            }
            slot = slot + 1 & mask;
        }
        NativeMemoryData memKey = (NativeMemoryData)this.memoryBlockProcessor.convertData(key, DataType.NATIVE);
        assert (memKey.address() != 0L) : "Null key!";
        if (this.assignedSlotCount == this.resizeAt) {
            try {
                this.expandAndPut(memKey.address(), value, slot);
            }
            catch (Throwable error) {
                if (memKey != key) {
                    this.memoryBlockProcessor.disposeData(memKey);
                }
                throw ExceptionUtil.rethrow(error);
            }
        } else {
            ++this.assignedSlotCount;
            this.accessor.setKey(slot, memKey.address());
            this.accessor.setValue(slot, value);
        }
        ++this.modCount;
        return null;
    }

    @Override
    public boolean set(Data key, V value) {
        V old = this.put(key, value);
        if (old != null && ((MemoryBlock)old).address() != ((MemoryBlock)value).address()) {
            this.memoryBlockProcessor.dispose(old);
        }
        return old == null;
    }

    @Override
    public V putIfAbsent(Data key, V value) {
        Object current = this.get(key);
        if (current == null) {
            this.set(key, value);
            return null;
        }
        return (V)current;
    }

    @Override
    public void putAll(Map<? extends Data, ? extends V> map) {
        for (Map.Entry<Data, V> entry : map.entrySet()) {
            this.set(entry.getKey(), (V)((MemoryBlock)entry.getValue()));
        }
    }

    @Override
    public boolean replace(Data key, V oldValue, V newValue) {
        int slot;
        this.ensureMemory();
        int mask = this.allocatedSlotCount - 1;
        int wrappedAround = slot = BehmSlotAccessor.rehash(key, this.perturbation) & mask;
        while (this.accessor.isAssigned(slot)) {
            long slotKey = this.accessor.getKey(slot);
            if (NativeMemoryDataUtil.equals(slotKey, key)) {
                long current = this.accessor.getValue(slot);
                if (this.memoryBlockProcessor.isEqual(current, oldValue)) {
                    this.accessor.setValue(slot, newValue);
                    if (current != 0L) {
                        this.memoryBlockProcessor.dispose(current);
                    }
                    return true;
                }
                return false;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return false;
    }

    @Override
    public V replace(Data key, V value) {
        int slot;
        this.ensureMemory();
        int mask = this.allocatedSlotCount - 1;
        int wrappedAround = slot = BehmSlotAccessor.rehash(key, this.perturbation) & mask;
        while (this.accessor.isAssigned(slot)) {
            long slotKey = this.accessor.getKey(slot);
            if (NativeMemoryDataUtil.equals(slotKey, key)) {
                long current = this.accessor.getValue(slot);
                this.accessor.setValue(slot, value);
                return this.readV(current);
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return null;
    }

    private void expandAndPut(long pendingKey, V pendingValue, int freeSlot) {
        this.ensureMemory();
        assert (this.assignedSlotCount == this.resizeAt);
        assert (!this.accessor.isAssigned(freeSlot));
        BehmSlotAccessor oldAccessor = this.accessorFactory.create(this.accessor);
        int oldAllocated = this.allocatedSlotCount;
        this.allocateBuffer(CapacityUtil.nextCapacity(this.allocatedSlotCount));
        ++this.assignedSlotCount;
        oldAccessor.setKey(freeSlot, pendingKey);
        oldAccessor.setValue(freeSlot, pendingValue);
        int mask = this.allocatedSlotCount - 1;
        int slot = oldAllocated;
        while (--slot >= 0) {
            if (!oldAccessor.isAssigned(slot)) continue;
            long key = oldAccessor.getKey(slot);
            long value = oldAccessor.getValue(slot);
            int newSlot = BehmSlotAccessor.rehash(NativeMemoryDataUtil.hashCode(key), this.perturbation) & mask;
            while (this.accessor.isAssigned(newSlot)) {
                newSlot = newSlot + 1 & mask;
            }
            this.accessor.setKey(newSlot, key);
            this.accessor.setValue(newSlot, value);
        }
        oldAccessor.delete();
    }

    @Override
    public V remove(Object k) {
        return this.removeInternal(k, true);
    }

    public V removeInternal(Object k, boolean tryDisposeKey) {
        int slot;
        this.ensureMemory();
        Data key = (Data)k;
        int mask = this.allocatedSlotCount - 1;
        int wrappedAround = slot = BehmSlotAccessor.rehash(key, this.perturbation) & mask;
        while (this.accessor.isAssigned(slot)) {
            long slotKey = this.accessor.getKey(slot);
            if (NativeMemoryDataUtil.equals(slotKey, key)) {
                NativeMemoryData data;
                --this.assignedSlotCount;
                long v = this.accessor.getValue(slot);
                if (tryDisposeKey && (key instanceof HeapData || key instanceof NativeMemoryData && (data = (NativeMemoryData)key).address() != slotKey)) {
                    this.memoryBlockProcessor.disposeData(this.accessor.keyData(slot));
                }
                this.shiftConflictingKeys(slot);
                ++this.modCount;
                return this.readV(v);
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return null;
    }

    @Override
    public boolean delete(Data key) {
        return this.deleteInternal(key, true);
    }

    public boolean deleteInternal(Data key, boolean tryDisposeKey) {
        V value = this.removeInternal(key, tryDisposeKey);
        if (value != null) {
            this.memoryBlockProcessor.dispose(value);
        }
        return value != null;
    }

    @Override
    public boolean remove(Object k, Object v) {
        int slot;
        this.ensureMemory();
        Data key = (Data)k;
        MemoryBlock value = (MemoryBlock)v;
        int mask = this.allocatedSlotCount - 1;
        int wrappedAround = slot = BehmSlotAccessor.rehash(key, this.perturbation) & mask;
        while (this.accessor.isAssigned(slot)) {
            long keyAddress = this.accessor.getKey(slot);
            if (NativeMemoryDataUtil.equals(keyAddress, key)) {
                long current = this.accessor.getValue(slot);
                if (this.memoryBlockProcessor.isEqual(current, value)) {
                    NativeMemoryData data;
                    --this.assignedSlotCount;
                    if (key instanceof HeapData || key instanceof NativeMemoryData && (data = (NativeMemoryData)key).address() != keyAddress) {
                        this.memoryBlockProcessor.disposeData(this.accessor.keyData(slot));
                    }
                    if (value.address() != current) {
                        this.memoryBlockProcessor.dispose(current);
                    }
                    this.shiftConflictingKeys(slot);
                    return true;
                }
                return false;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return false;
    }

    private void shiftConflictingKeys(int slotCurr) {
        int slotPrev;
        int mask = this.allocatedSlotCount - 1;
        while (true) {
            slotPrev = slotCurr;
            slotCurr = slotCurr + 1 & mask;
            while (this.accessor.isAssigned(slotCurr)) {
                int slotOther = BehmSlotAccessor.rehash(NativeMemoryDataUtil.hashCode(this.accessor.getKey(slotCurr)), this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.accessor.isAssigned(slotCurr)) break;
            this.accessor.setKey(slotPrev, this.accessor.getKey(slotCurr));
            this.accessor.setValue(slotPrev, this.accessor.getValue(slotCurr));
        }
        this.accessor.setKey(slotPrev, 0L);
        this.accessor.setValue(slotPrev, 0L);
    }

    @Override
    public V get(Object k) {
        return this.get0(k, false);
    }

    public V getIfSameKey(Object k) {
        return this.get0(k, true);
    }

    private V get0(Object k, boolean onlyIfSame) {
        int slot;
        this.ensureMemory();
        Data key = (Data)k;
        int mask = this.allocatedSlotCount - 1;
        int wrappedAround = slot = BehmSlotAccessor.rehash(key, this.perturbation) & mask;
        while (this.accessor.isAssigned(slot)) {
            long slotKeyAddr = this.accessor.getKey(slot);
            if (onlyIfSame ? this.same(slotKeyAddr, (NativeMemoryData)key) : NativeMemoryDataUtil.equals(slotKeyAddr, key)) {
                long value = this.accessor.getValue(slot);
                return this.readV(value);
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return null;
    }

    private boolean same(long addrOfKey1, NativeMemoryData key2) {
        return addrOfKey1 == key2.address();
    }

    public long getNativeKeyAddress(Data key) {
        int slot;
        this.ensureMemory();
        int mask = this.allocatedSlotCount - 1;
        int wrappedAround = slot = BehmSlotAccessor.rehash(key, this.perturbation) & mask;
        while (this.accessor.isAssigned(slot)) {
            long slotKey = this.accessor.getKey(slot);
            if (NativeMemoryDataUtil.equals(slotKey, key)) {
                return slotKey;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0L;
    }

    public long getNativeValueAddress(Data key) {
        int slot;
        this.ensureMemory();
        int mask = this.allocatedSlotCount - 1;
        int wrappedAround = slot = BehmSlotAccessor.rehash(key, this.perturbation) & mask;
        while (this.accessor.isAssigned(slot)) {
            long slotKey = this.accessor.getKey(slot);
            if (NativeMemoryDataUtil.equals(slotKey, key)) {
                return this.accessor.getValue(slot);
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return 0L;
    }

    private void ensureMemory() {
        if (this.accessor == null) {
            throw new IllegalStateException("Map is already destroyed!");
        }
    }

    @Override
    public boolean containsKey(Object k) {
        int slot;
        this.ensureMemory();
        Data key = (Data)k;
        int mask = this.allocatedSlotCount - 1;
        int wrappedAround = slot = BehmSlotAccessor.rehash(key, this.perturbation) & mask;
        while (this.accessor.isAssigned(slot)) {
            long slotKey = this.accessor.getKey(slot);
            if (NativeMemoryDataUtil.equals(slotKey, key)) {
                return true;
            }
            if ((slot = slot + 1 & mask) != wrappedAround) continue;
            break;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object v) {
        this.ensureMemory();
        MemoryBlock value = (MemoryBlock)v;
        for (int slot = 0; slot < this.allocatedSlotCount; ++slot) {
            long current;
            if (!this.accessor.isAssigned(slot) || !this.memoryBlockProcessor.isEqual(current = this.accessor.getValue(slot), value)) continue;
            return true;
        }
        return false;
    }

    public SlottableIterator<Data> newRandomEvictionKeyIterator() {
        return new RandomKeyIter();
    }

    public SlottableIterator<V> newRandomEvictionValueIterator() {
        return new RandomValueIter();
    }

    public SlottableIterator<Map.Entry<Data, V>> newRandomEvictionCachedEntryIterator() {
        return new CachedRandomEntryIter();
    }

    private void failIfModified(boolean enable, int lastKnownModCount) {
        if (enable && lastKnownModCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public Set<Data> keySet() {
        this.ensureMemory();
        return new KeySet();
    }

    protected KeyIter keyIter(int startSlot) {
        return new KeyIter(startSlot);
    }

    @Override
    public Collection<V> values() {
        this.ensureMemory();
        return new Values();
    }

    public final Iterator<V> valueIter() {
        return new ValueIter();
    }

    public final Iterator<V> valueIter(boolean failFast) {
        return new ValueIter(failFast);
    }

    protected V readV(long slotValue) {
        if (slotValue == 0L) {
            return null;
        }
        return this.memoryBlockProcessor.read(slotValue);
    }

    @Override
    public Set<Map.Entry<Data, V>> entrySet() {
        this.ensureMemory();
        return new EntrySet();
    }

    public int fetchAllWithBaseSlot(int baseSlot, IntConsumer slotConsumer) {
        int currentKeyBaseSlot;
        int currentKeyHashCode;
        long currentKey;
        this.ensureMemory();
        int mask = this.allocatedSlotCount - 1;
        int currentSlot = baseSlot = baseSlot >= 0 && baseSlot <= this.allocatedSlotCount ? baseSlot : 0;
        int nextBaseSlot = -1;
        while (this.accessor.isAssigned(currentSlot)) {
            currentKey = this.accessor.getKey(currentSlot);
            currentKeyHashCode = NativeMemoryDataUtil.hashCode(currentKey);
            currentKeyBaseSlot = BehmSlotAccessor.rehash(currentKeyHashCode, this.perturbation) & mask;
            if (currentKeyBaseSlot == baseSlot) {
                slotConsumer.accept(currentSlot);
            } else if (currentKeyBaseSlot > baseSlot) {
                nextBaseSlot = nextBaseSlot == -1 ? currentKeyBaseSlot : Math.min(nextBaseSlot, currentKeyBaseSlot);
            }
            if ((currentSlot = currentSlot + 1 & mask) != baseSlot) continue;
            return nextBaseSlot;
        }
        if (nextBaseSlot > 0) {
            while (true) {
                if (this.accessor.isAssigned(currentSlot)) {
                    currentKey = this.accessor.getKey(currentSlot);
                    currentKeyHashCode = NativeMemoryDataUtil.hashCode(currentKey);
                    currentKeyBaseSlot = BehmSlotAccessor.rehash(currentKeyHashCode, this.perturbation) & mask;
                    if (currentKeyBaseSlot > baseSlot) {
                        return Math.min(nextBaseSlot, currentKeyBaseSlot);
                    }
                } else if (currentSlot == baseSlot) {
                    return nextBaseSlot;
                }
                currentSlot = currentSlot + 1 & mask;
            }
        }
        if (currentSlot < baseSlot) {
            return nextBaseSlot;
        }
        while (currentSlot < this.allocatedSlotCount) {
            if (this.accessor.isAssigned(currentSlot & mask)) {
                nextBaseSlot = currentSlot & mask;
                break;
            }
            ++currentSlot;
        }
        return nextBaseSlot;
    }

    public final Iterator<Map.Entry<Data, V>> entryIter(boolean failFast) {
        return new EntryIter(failFast);
    }

    protected SlottableIterator<Map.Entry<Data, V>> entryIter(int slot) {
        return new EntryIter(slot);
    }

    public final Iterator<Map.Entry<Data, V>> cachedEntryIter(boolean failFast) {
        return new CachedEntryIter(failFast);
    }

    @Override
    public void clear() {
        this.ensureMemory();
        ++this.modCount;
        if (this.accessor != null) {
            KeyIter iter2 = new KeyIter();
            while (iter2.hasNext()) {
                iter2.nextSlot();
                iter2.remove();
            }
            this.assignedSlotCount = 0;
            this.accessor.clear();
        }
    }

    public void clearWithoutKeyDisposal() {
        this.ensureMemory();
        ++this.modCount;
        if (this.accessor != null) {
            KeyIter iter2 = new KeyIter();
            while (iter2.hasNext()) {
                iter2.nextSlot();
                iter2.removeInternal(false);
            }
            this.assignedSlotCount = 0;
            this.accessor.clear();
        }
    }

    public NativeMemoryData storeHeaderOffHeap(MemoryAllocator malloc, long addressGiven) {
        long address = addressGiven;
        int size = 40;
        if (addressGiven <= 0L) {
            address = malloc.allocate(size);
        }
        long pointer = address;
        GlobalMemoryAccessor unsafe = GlobalMemoryAccessorRegistry.MEM;
        unsafe.putInt(pointer, 36);
        unsafe.putInt(pointer += 4L, this.allocatedSlotCount);
        unsafe.putInt(pointer += 4L, this.assignedSlotCount);
        unsafe.putFloat(pointer += 4L, this.loadFactor);
        unsafe.putInt(pointer += 4L, this.resizeAt);
        unsafe.putInt(pointer += 4L, this.perturbation);
        unsafe.putLong(pointer += 4L, this.accessor.baseAddr);
        unsafe.putLong(pointer += 8L, this.accessor.size);
        return new NativeMemoryData(address, size);
    }

    public static <V extends MemoryBlock> BinaryElasticHashMap<V> loadFromOffHeapHeader(EnterpriseSerializationService ss, MemoryAllocator malloc, long address, BehmSlotAccessorFactory behmSlotAccessorFactory, MemoryBlockAccessor memoryBlockAccessor) {
        GlobalMemoryAccessor unsafe = GlobalMemoryAccessorRegistry.MEM;
        long pointer = address + 4L;
        int allocatedSlotCount = unsafe.getInt(pointer);
        int assignedSlotCount = unsafe.getInt(pointer += 4L);
        float loadFactor = unsafe.getFloat(pointer += 4L);
        int resizeAt = unsafe.getInt(pointer += 4L);
        int perturbation = unsafe.getInt(pointer += 4L);
        long baseAddr = unsafe.getLong(pointer += 4L);
        long size = unsafe.getLong(pointer += 8L);
        return new BinaryElasticHashMap<V>(allocatedSlotCount, assignedSlotCount, loadFactor, resizeAt, perturbation, baseAddr, size, malloc, ss, behmSlotAccessorFactory, memoryBlockAccessor);
    }

    @Override
    public void dispose() {
        if (this.accessor != null) {
            this.accessor.delete();
        }
        this.allocatedSlotCount = 0;
        this.accessor = null;
        this.resizeAt = 0;
    }

    @Override
    public int size() {
        return this.assignedSlotCount;
    }

    public int capacity() {
        return this.allocatedSlotCount;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return "BinaryElasticHashMap{address=" + String.valueOf(this.accessor) + ", allocated=" + this.allocatedSlotCount + ", assigned=" + this.assignedSlotCount + ", loadFactor=" + this.loadFactor + ", resizeAt=" + this.resizeAt + "}";
    }

    protected class RandomKeyIter
    extends RandomSlotIter<Data> {
        protected RandomKeyIter() {
        }

        @Override
        public Data next() {
            this.nextSlot();
            return BinaryElasticHashMap.this.accessor.keyData(this.currentSlot);
        }
    }

    protected class RandomValueIter
    extends RandomSlotIter<V> {
        protected RandomValueIter() {
        }

        @Override
        public V next() {
            this.nextSlot();
            long slotValue = BinaryElasticHashMap.this.accessor.getValue(this.currentSlot);
            Object value = BinaryElasticHashMap.this.readV(slotValue);
            return value;
        }
    }

    protected class CachedRandomEntryIter
    extends RandomSlotIter<Map.Entry<Data, V>> {
        MapEntry cachedEntry;

        protected CachedRandomEntryIter() {
            this.cachedEntry = new MapEntry();
        }

        @Override
        public Map.Entry<Data, V> next() {
            this.nextSlot();
            return this.cachedEntry.init(this.currentSlot);
        }
    }

    private class KeySet
    extends AbstractSet<Data> {
        private KeySet() {
        }

        @Override
        public Iterator<Data> iterator() {
            return new KeyIter();
        }

        @Override
        public int size() {
            return BinaryElasticHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return BinaryElasticHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return BinaryElasticHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            BinaryElasticHashMap.this.clear();
        }
    }

    protected class KeyIter
    extends SlotIter<Data>
    implements Iterator<Data> {
        KeyIter() {
        }

        KeyIter(int startSlot) {
            super(startSlot, true);
        }

        KeyIter(int startSlot, boolean failFast) {
            super(startSlot, failFast);
        }

        @Override
        public Data next() {
            this.nextSlot();
            return BinaryElasticHashMap.this.accessor.keyData(this.currentSlot);
        }

        @Override
        public void removeInternal(boolean disposeKey) {
            super.removeInternal(disposeKey);
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIter();
        }

        @Override
        public int size() {
            return BinaryElasticHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return BinaryElasticHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            BinaryElasticHashMap.this.clear();
        }
    }

    protected class ValueIter
    extends SlotIter<V>
    implements Iterator<V> {
        public ValueIter() {
        }

        public ValueIter(boolean failFast) {
            super(failFast);
        }

        @Override
        public V next() {
            this.nextSlot();
            long slotValue = BinaryElasticHashMap.this.accessor.getValue(this.currentSlot);
            return BinaryElasticHashMap.this.readV(slotValue);
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Data, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Data, V>> iterator() {
            return new EntryIter();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = BinaryElasticHashMap.this.get(e.getKey());
            return value != null && ((MemoryBlock)value).equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Data key = (Data)e.getKey();
            boolean deleted = BinaryElasticHashMap.this.delete(key);
            return deleted;
        }

        @Override
        public int size() {
            return BinaryElasticHashMap.this.size();
        }

        @Override
        public void clear() {
            BinaryElasticHashMap.this.clear();
        }
    }

    private class EntryIter
    extends SlotIter<Map.Entry<Data, V>> {
        EntryIter() {
        }

        EntryIter(boolean failFast) {
            super(failFast);
        }

        EntryIter(int slot) {
            this(slot, true);
        }

        EntryIter(int slot, boolean failFast) {
            super(failFast);
            if (slot < 0 || slot > BinaryElasticHashMap.this.allocatedSlotCount) {
                slot = 0;
            }
            this.nextSlot = this.advance(slot);
        }

        @Override
        public Map.Entry<Data, V> next() {
            this.nextSlot();
            return new MapEntry(this.currentSlot);
        }
    }

    private class CachedEntryIter
    extends EntryIter {
        private MapEntry entry;

        CachedEntryIter(boolean failFast) {
            super(failFast);
            this.entry = new MapEntry();
        }

        @Override
        public Map.Entry<Data, V> next() {
            this.nextSlot();
            return this.entry.init(this.currentSlot);
        }
    }

    protected class MapEntry
    implements Map.Entry<Data, V> {
        private int slot;

        protected MapEntry() {
        }

        protected MapEntry(int slot) {
            this.init(slot);
        }

        protected MapEntry init(int slot) {
            this.slot = slot;
            return this;
        }

        @Override
        public Data getKey() {
            return BinaryElasticHashMap.this.accessor.keyData(this.slot);
        }

        @Override
        public V getValue() {
            long value = BinaryElasticHashMap.this.accessor.getValue(this.slot);
            return BinaryElasticHashMap.this.readV(value);
        }

        @Override
        public V setValue(V value) {
            Object current = this.getValue();
            BinaryElasticHashMap.this.accessor.setValue(this.slot, value);
            return current;
        }
    }

    public abstract class SlotIter<E>
    implements SlottableIterator<E> {
        int nextSlot = -1;
        int currentSlot = -1;
        private NativeMemoryData keyHolder;
        private boolean failFast;
        private int lastKnownModCount;

        SlotIter() {
            this(0, true);
        }

        SlotIter(boolean failFast) {
            this(0, failFast);
        }

        SlotIter(int startSlot, boolean failFast) {
            this.failFast = failFast;
            this.lastKnownModCount = BinaryElasticHashMap.this.modCount;
            this.nextSlot = this.advance(startSlot);
        }

        final int advance(int start) {
            BinaryElasticHashMap.this.ensureMemory();
            BinaryElasticHashMap.this.failIfModified(this.failFast, this.lastKnownModCount);
            for (int slot = start; slot < BinaryElasticHashMap.this.allocatedSlotCount; ++slot) {
                if (!BinaryElasticHashMap.this.accessor.isAssigned(slot)) continue;
                return slot;
            }
            return -1;
        }

        @Override
        public final boolean hasNext() {
            return this.nextSlot > -1;
        }

        @Override
        public final int nextSlot() {
            if (this.nextSlot < 0) {
                throw new NoSuchElementException();
            }
            BinaryElasticHashMap.this.failIfModified(this.failFast, this.lastKnownModCount);
            this.currentSlot = this.nextSlot;
            this.nextSlot = this.advance(this.nextSlot + 1);
            return this.currentSlot;
        }

        @Override
        public final void remove() {
            this.removeInternal(true);
        }

        public void removeInternal(boolean disposeKey) {
            BinaryElasticHashMap.this.ensureMemory();
            if (this.currentSlot < 0) {
                throw new NoSuchElementException();
            }
            BinaryElasticHashMap.this.failIfModified(this.failFast, this.lastKnownModCount);
            long key = BinaryElasticHashMap.this.accessor.getKey(this.currentSlot);
            long value = BinaryElasticHashMap.this.accessor.getValue(this.currentSlot);
            --BinaryElasticHashMap.this.assignedSlotCount;
            BinaryElasticHashMap.this.shiftConflictingKeys(this.currentSlot);
            if (disposeKey) {
                BinaryElasticHashMap.this.memoryBlockProcessor.disposeData(this.readIntoKeyHolder(key));
            }
            if (value != 0L) {
                BinaryElasticHashMap.this.memoryBlockProcessor.dispose(value);
            }
            if (BinaryElasticHashMap.this.accessor.isAssigned(this.currentSlot)) {
                this.nextSlot = this.currentSlot;
            }
            this.lastKnownModCount = BinaryElasticHashMap.this.modCount;
        }

        private NativeMemoryData readIntoKeyHolder(long key) {
            if (this.keyHolder == null) {
                this.keyHolder = new NativeMemoryData();
            }
            this.keyHolder.reset(key);
            return this.keyHolder;
        }

        @Override
        public int getNextSlot() {
            return this.nextSlot;
        }

        @Override
        public int getCurrentSlot() {
            return this.currentSlot;
        }
    }

    private abstract class RandomSlotIter<E>
    implements SlottableIterator<E> {
        int currentSlot = -1;
        private int iterationCount;
        private int initialSize;
        private int nextSlot;
        private NativeMemoryData keyHolder;
        private int lastKnownModCount;

        RandomSlotIter() {
            this.initialSize = BinaryElasticHashMap.this.assignedSlotCount;
            this.nextSlot = -1;
            this.keyHolder = new NativeMemoryData();
            this.lastKnownModCount = BinaryElasticHashMap.this.modCount;
            this.nextSlot = this.advanceAndIncrementIterations();
        }

        final int advanceAndIncrementIterations() {
            BinaryElasticHashMap.this.ensureMemory();
            if (this.iterationCount == this.initialSize) {
                return -1;
            }
            int slot = this.advance();
            ++this.iterationCount;
            return slot;
        }

        final int advance() {
            int slot;
            BinaryElasticHashMap.this.ensureMemory();
            BinaryElasticHashMap.this.failIfModified(true, this.lastKnownModCount);
            while (!BinaryElasticHashMap.this.accessor.isAssigned(slot = BinaryElasticHashMap.this.getRandom().nextInt(BinaryElasticHashMap.this.capacity())) || slot == this.currentSlot) {
            }
            return slot;
        }

        @Override
        public final boolean hasNext() {
            return this.nextSlot > -1;
        }

        @Override
        public final int nextSlot() {
            BinaryElasticHashMap.this.ensureMemory();
            if (this.nextSlot < 0) {
                throw new NoSuchElementException();
            }
            BinaryElasticHashMap.this.failIfModified(true, this.lastKnownModCount);
            this.currentSlot = this.nextSlot;
            if (!BinaryElasticHashMap.this.accessor.isAssigned(this.currentSlot)) {
                this.currentSlot = this.advance();
                if (this.currentSlot < 0) {
                    throw new ConcurrentModificationException("Map was modified externally.");
                }
            }
            this.nextSlot = this.advanceAndIncrementIterations();
            return this.currentSlot;
        }

        @Override
        public final void remove() {
            this.removeInternal(true);
        }

        protected void removeInternal(boolean disposeKey) {
            BinaryElasticHashMap.this.ensureMemory();
            if (this.currentSlot < 0) {
                throw new NoSuchElementException();
            }
            BinaryElasticHashMap.this.failIfModified(true, this.lastKnownModCount);
            long key = BinaryElasticHashMap.this.accessor.getKey(this.currentSlot);
            long value = BinaryElasticHashMap.this.accessor.getValue(this.currentSlot);
            --BinaryElasticHashMap.this.assignedSlotCount;
            BinaryElasticHashMap.this.shiftConflictingKeys(this.currentSlot);
            if (disposeKey) {
                this.keyHolder.reset(key);
                BinaryElasticHashMap.this.memoryBlockProcessor.disposeData(this.keyHolder);
            }
            if (value != 0L) {
                BinaryElasticHashMap.this.memoryBlockProcessor.dispose(value);
            }
            if (BinaryElasticHashMap.this.accessor.isAssigned(this.currentSlot)) {
                this.nextSlot = this.currentSlot;
            }
            this.lastKnownModCount = BinaryElasticHashMap.this.modCount;
        }

        @Override
        public int getNextSlot() {
            return this.nextSlot;
        }

        @Override
        public int getCurrentSlot() {
            return this.currentSlot;
        }
    }
}

